/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons;

import java.util.function.Function;
import java.util.function.Supplier;
import net.dongliu.commons.Lazy;

class LazyImpl<T>
implements Lazy<T> {
    private boolean initialized;
    private Supplier<T> supplier = () -> {
        LazyImpl lazyImpl = this;
        synchronized (lazyImpl) {
            if (!this.initialized) {
                Object value = supplier.get();
                this.supplier = () -> value;
                this.initialized = true;
            }
        }
        return this.supplier.get();
    };

    LazyImpl(Supplier<T> supplier) {
    }

    @Override
    public T get() {
        return this.supplier.get();
    }

    @Override
    public <R> Lazy<R> map(Function<? super T, ? extends R> function) {
        return Lazy.of(() -> function.apply((T)this.get()));
    }
}

