/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Prints {
    private static final Printer defaultPrinter = new Printer(" ", System.lineSeparator(), System.out);

    public static void print(@Nullable Object value) {
        defaultPrinter.print(value);
    }

    public static void print(@Nullable Object value1, @Nullable Object value2) {
        defaultPrinter.print(value1, value2);
    }

    public static void print(@Nullable Object value1, @Nullable Object value2, @Nullable Object value3) {
        defaultPrinter.print(value1, value2, value3);
    }

    public static void print(@Nullable Object value1, @Nullable Object value2, @Nullable Object value3, @Nullable Object value4) {
        defaultPrinter.print(value1, value2, value3, value4);
    }

    public static void print(@Nullable Object value1, @Nullable Object value2, @Nullable Object value3, @Nullable Object value4, @Nullable Object value5) {
        defaultPrinter.print(value1, value2, value3, value4, value5);
    }

    public static void print(Object ... values) {
        defaultPrinter.print(values);
    }

    public void printValues(@NonNull Iterable<@Nullable ?> iterable) {
        defaultPrinter.printValues(iterable);
    }

    public void printMap(@NonNull Map<@Nullable ?, @Nullable ?> map) {
        defaultPrinter.printMap(map);
    }

    public static Printer sep(String sep) {
        Objects.requireNonNull(sep);
        return defaultPrinter.sep(sep);
    }

    public static Printer end(String end) {
        Objects.requireNonNull(end);
        return defaultPrinter.end(end);
    }

    public static Printer out(Appendable appendable) {
        Objects.requireNonNull(appendable);
        return defaultPrinter.out(appendable);
    }

    public static class Printer {
        private final String sep;
        private final String end;
        private final Appendable out;

        private Printer(String sep, String end, Appendable out) {
            this.sep = sep;
            this.end = end;
            this.out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void print(@Nullable Object value) {
            Appendable appendable = this.out;
            synchronized (appendable) {
                this.write(String.valueOf(value));
                this.write(this.end);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void print(@Nullable Object value1, @Nullable Object value2) {
            Appendable appendable = this.out;
            synchronized (appendable) {
                this.write(String.valueOf(value1));
                this.write(this.sep);
                this.write(String.valueOf(value2));
                this.write(this.end);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void print(@Nullable Object value1, @Nullable Object value2, @Nullable Object value3) {
            Appendable appendable = this.out;
            synchronized (appendable) {
                this.write(String.valueOf(value1));
                this.write(this.sep);
                this.write(String.valueOf(value2));
                this.write(this.sep);
                this.write(String.valueOf(value3));
                this.write(this.end);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void print(@Nullable Object value1, @Nullable Object value2, @Nullable Object value3, @Nullable Object value4) {
            Appendable appendable = this.out;
            synchronized (appendable) {
                this.write(String.valueOf(value1));
                this.write(this.sep);
                this.write(String.valueOf(value2));
                this.write(this.sep);
                this.write(String.valueOf(value3));
                this.write(this.sep);
                this.write(String.valueOf(value4));
                this.write(this.end);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void print(@Nullable Object value1, @Nullable Object value2, @Nullable Object value3, @Nullable Object value4, @Nullable Object value5) {
            Appendable appendable = this.out;
            synchronized (appendable) {
                this.write(String.valueOf(value1));
                this.write(this.sep);
                this.write(String.valueOf(value2));
                this.write(this.sep);
                this.write(String.valueOf(value3));
                this.write(this.sep);
                this.write(String.valueOf(value4));
                this.write(this.sep);
                this.write(String.valueOf(value5));
                this.write(this.end);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void print(Object ... values) {
            Objects.requireNonNull(values);
            if (values.length == 0) {
                return;
            }
            Appendable appendable = this.out;
            synchronized (appendable) {
                for (int i = 0; i < values.length; ++i) {
                    this.write(String.valueOf(values[i]));
                    if (i >= values.length - 1) continue;
                    this.write(this.sep);
                }
                this.write(this.end);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void printValues(@NonNull Iterable<@Nullable ?> iterable) {
            Objects.requireNonNull(iterable);
            Appendable appendable = this.out;
            synchronized (appendable) {
                Iterator<?> iterator = iterable.iterator();
                boolean first = true;
                while (iterator.hasNext()) {
                    if (!first) {
                        this.write(this.sep);
                    }
                    Object value = iterator.next();
                    this.write(String.valueOf(value));
                    first = false;
                }
                this.write(this.end);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void printMap(@NonNull Map<@Nullable ?, @Nullable ?> map) {
            Objects.requireNonNull(map);
            Appendable appendable = this.out;
            synchronized (appendable) {
                int i = 0;
                int size = map.size();
                for (Map.Entry<?, ?> entry : map.entrySet()) {
                    this.write(String.valueOf(entry.getKey()));
                    this.write(" = ");
                    this.write(String.valueOf(entry.getValue()));
                    if (i++ >= size - 1) continue;
                    this.write(this.sep);
                }
                this.write(this.end);
            }
        }

        public Printer sep(String sep) {
            Objects.requireNonNull(sep);
            return new Printer(sep, this.end, this.out);
        }

        public Printer end(String end) {
            Objects.requireNonNull(end);
            return new Printer(this.sep, end, this.out);
        }

        public Printer out(Appendable appendable) {
            Objects.requireNonNull(appendable);
            return new Printer(this.sep, this.end, appendable);
        }

        private void write(String str) {
            try {
                this.out.append(str);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

