/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.dongliu.commons.concurrent.Threads;

public abstract class RateLimiter {
    private final double permitsPerSecond;
    private final long maxReserved;
    private final double nanosPerPermits;
    private final Lock lock = new ReentrantLock();
    private long lastNanos;

    private RateLimiter(double permitsPerSecond) {
        this.permitsPerSecond = permitsPerSecond;
        this.nanosPerPermits = 1.0E9 / permitsPerSecond;
        this.lastNanos = System.nanoTime();
        this.maxReserved = Math.max((long)(permitsPerSecond * 3.0), 1L);
    }

    public static RateLimiter of(double permitsPerSecond) {
        return new RateLimiter(RateLimiter.checkPermits(permitsPerSecond)){};
    }

    private static double checkPermits(double permits) {
        if (permits < 0.0) {
            throw new IllegalArgumentException("illegal permits: " + permits);
        }
        return permits;
    }

    public void acquire() {
        this.acquire(1);
    }

    public void acquire(int n) {
        this.checkCount(n);
        long nanosToSleep = this.acquireInternal(n, false);
        if (nanosToSleep > 0L) {
            Threads.sleepNanos(nanosToSleep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long acquireInternal(int n, boolean isTry) {
        long nanos = (long)((double)n * this.nanosPerPermits);
        this.lock.lock();
        try {
            long newNanos;
            long nanosToSleep;
            long current = System.nanoTime();
            long lastNanosMin = current - (long)((double)this.maxReserved * this.nanosPerPermits);
            if (lastNanosMin > this.lastNanos) {
                this.lastNanos = lastNanosMin;
            }
            if ((nanosToSleep = (newNanos = this.lastNanos + nanos) - current) < 0L || !isTry) {
                this.lastNanos = newNanos;
            }
            long l = nanosToSleep;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean tryAcquire() {
        return this.tryAcquire(1);
    }

    public boolean tryAcquire(int n) {
        this.checkCount(n);
        return this.acquireInternal(n, true) < 0L;
    }

    public double permitsPerSecond() {
        return this.permitsPerSecond;
    }

    private int checkCount(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("invalid count value: " + count);
        }
        return count;
    }
}

