/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons;

import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class Stopwatch {
    private long startNanos;
    private int status;
    private long stopElapsedNanos;
    private static final int STATUS_UNSTARTED = 0;
    private static final int STATUS_STARTED = 1;
    private static final int STATUS_STOPPED = 2;

    private Stopwatch() {
    }

    public static Stopwatch create() {
        return new Stopwatch();
    }

    public Stopwatch start() {
        if (this.status == 1) {
            throw new IllegalStateException("Stopwatch already started.");
        }
        this.startNanos = System.nanoTime();
        this.status = 1;
        return this;
    }

    public Stopwatch stop() {
        if (this.status != 1) {
            throw new IllegalStateException("Stop watch not started, status: " + this.status);
        }
        this.stopElapsedNanos = System.nanoTime() - this.startNanos;
        this.status = 2;
        return this;
    }

    public Duration elapsed() {
        return Duration.ofNanos(this.elapsedNanos());
    }

    public long elapsed(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedNanos(), TimeUnit.NANOSECONDS);
    }

    public long elapsedNanos() {
        switch (this.status) {
            case 0: {
                throw new IllegalStateException("Stopwatch not started");
            }
            case 1: {
                return System.nanoTime() - this.startNanos;
            }
            case 2: {
                return this.stopElapsedNanos;
            }
        }
        throw new IllegalStateException("should not happen, status: " + this.status);
    }

    public long elapsedMillis() {
        return this.elapsed(TimeUnit.MILLISECONDS);
    }
}

