/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.dongliu.commons.collection.Iterables;
import net.dongliu.commons.collection.Lists;
import net.dongliu.commons.collection.PartitionResult;
import net.dongliu.commons.function.IndexedConsumer;
import net.dongliu.commons.function.LastAwareConsumer;

public class Collections2 {
    @Deprecated
    public static <T> T[] toArray(Collection<? extends T> c, IntFunction<T[]> maker) {
        Objects.requireNonNull(c);
        return c.toArray(maker.apply(c.size()));
    }

    public static <S, T> List<T> convertToList(Collection<S> c, Function<? super S, ? extends T> mapper) {
        Objects.requireNonNull(c);
        if (c.isEmpty()) {
            return Lists.of();
        }
        ArrayList<T> list = new ArrayList<T>(c.size());
        boolean i = false;
        for (S s : c) {
            list.add(mapper.apply(s));
        }
        return Collections.unmodifiableList(list);
    }

    public static <T> PartitionResult<List<T>> partitionToList(Collection<T> list, Predicate<? super T> predicate) {
        Objects.requireNonNull(list);
        ArrayList<T> list1 = new ArrayList<T>(Math.min(16, list.size()));
        ArrayList<T> list2 = new ArrayList<T>(Math.min(16, list.size()));
        for (T e : list) {
            if (predicate.test(e)) {
                list1.add(e);
                continue;
            }
            list2.add(e);
        }
        return new PartitionResult<List<T>>(Collections.unmodifiableList(list1), Collections.unmodifiableList(list2));
    }

    public static <T> void forEach(Collection<T> c, LastAwareConsumer<? super T> consumer) {
        Iterables.forEachLastAware(c, consumer);
    }

    public static <T> void forEachIndexed(Collection<T> c, IndexedConsumer<? super T> consumer) {
        Iterables.forEachIndexed(c, consumer);
    }
}

