/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.dongliu.commons.exception.TooManyElementsException;
import net.dongliu.commons.function.IndexedConsumer;
import net.dongliu.commons.function.LastAwareConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Iterables {
    public static <T> T getOneExactly(Iterable<T> iterable) throws NoSuchElementException, TooManyElementsException {
        Iterator<T> iterator;
        Objects.requireNonNull(iterable);
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                throw new NoSuchElementException();
            }
            if (size > 1) {
                throw new TooManyElementsException("iterable has more than one elements");
            }
        }
        if (!(iterator = iterable.iterator()).hasNext()) {
            throw new NoSuchElementException();
        }
        T value = iterator.next();
        if (iterator.hasNext()) {
            throw new TooManyElementsException("iterable has more than one elements");
        }
        return value;
    }

    public static <T> Optional<T> first(Iterable<T> iterable) {
        Objects.requireNonNull(iterable);
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            return Optional.of(iterator.next());
        }
        return Optional.empty();
    }

    public static <T> @Nullable T firstOrNull(Iterable<T> iterable) {
        Objects.requireNonNull(iterable);
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static <T> Optional<T> find(Iterable<T> iterable, Predicate<? super T> predicate) {
        Objects.requireNonNull(iterable);
        for (T e : iterable) {
            if (!predicate.test(e)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public static <T> @Nullable T findOrNull(Iterable<T> list, Predicate<? super T> predicate) {
        Objects.requireNonNull(list);
        for (T e : list) {
            if (!predicate.test(e)) continue;
            return e;
        }
        return null;
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        Objects.requireNonNull(iterable);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> void forEachLastAware(Iterable<T> iterable, LastAwareConsumer<? super T> consumer) {
        Objects.requireNonNull(iterable);
        Objects.requireNonNull(consumer);
        Iterator<T> iterator = iterable.iterator();
        boolean hasNext = iterator.hasNext();
        if (!hasNext) {
            return;
        }
        do {
            T value = iterator.next();
            hasNext = iterator.hasNext();
            consumer.on(value, !hasNext);
        } while (hasNext);
    }

    public static <T> void forEachIndexed(Iterable<T> iterable, IndexedConsumer<? super T> consumer) {
        Objects.requireNonNull(iterable);
        Objects.requireNonNull(consumer);
        Iterator<T> iterator = iterable.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            T value = iterator.next();
            consumer.accept(index++, value);
        }
    }
}

