/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.collection;

import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Iterators {
    public static <T> Stream<T> stream(Iterator<T> it) {
        Objects.requireNonNull(it);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 0), false);
    }

    public static <T> Optional<T> next(Iterator<T> it) {
        Objects.requireNonNull(it);
        if (it.hasNext()) {
            return Optional.of(it.next());
        }
        return Optional.empty();
    }

    public static <T> @Nullable T nextOrNull(Iterator<T> it) {
        Objects.requireNonNull(it);
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }
}

