/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.collection;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Sets {
    private static final int INIT_CAPACITY = 16;
    private static final float LOAD_FACTOR = 0.75f;

    public static <T> Set<T> nullToEmpty(@Nullable Set<T> set) {
        if (set == null) {
            return Sets.of();
        }
        return set;
    }

    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    public static <T> HashSet<T> newHashSet(T v) {
        HashSet<T> set = new HashSet<T>();
        set.add(v);
        return set;
    }

    public static <T> HashSet<T> newHashSet(T v1, T v2) {
        HashSet<T> set = new HashSet<T>();
        set.add(v1);
        set.add(v2);
        return set;
    }

    public static <T> HashSet<T> newHashSet(T v1, T v2, T v3) {
        HashSet<T> set = new HashSet<T>();
        set.add(v1);
        set.add(v2);
        set.add(v3);
        return set;
    }

    public static <T> HashSet<T> newHashSet(T v1, T v2, T v3, T v4) {
        HashSet<T> set = new HashSet<T>();
        set.add(v1);
        set.add(v2);
        set.add(v3);
        set.add(v4);
        return set;
    }

    public static <T> HashSet<T> newHashSet(T v1, T v2, T v3, T v4, T v5) {
        HashSet<T> set = new HashSet<T>();
        set.add(v1);
        set.add(v2);
        set.add(v3);
        set.add(v4);
        set.add(v5);
        return set;
    }

    @SafeVarargs
    public static <T> HashSet<T> newHashSet(T ... values) {
        HashSet set = new HashSet(Math.max(16, (int)((float)values.length / 0.75f)));
        Collections.addAll(set, values);
        return set;
    }

    @SafeVarargs
    public static <T, R extends Set<T>> R newSet(Supplier<R> supplier, T ... values) {
        Set set = (Set)supplier.get();
        Collections.addAll(set, values);
        return (R)set;
    }

    public static <T> Set<T> of() {
        return Collections.emptySet();
    }

    public static <T> Set<T> of(T value) {
        return Collections.singleton(value);
    }

    @SafeVarargs
    public static <T> Set<T> of(T ... values) {
        return Collections.unmodifiableSet(Sets.newHashSet(values));
    }

    public static <S, T> Set<T> convert(Set<S> set, Function<? super S, ? extends T> function) {
        Objects.requireNonNull(set);
        HashSet<T> newSet = new HashSet<T>(Sets.calculateCapacity(set.size()));
        for (S e : set) {
            newSet.add(function.apply(e));
        }
        return Collections.unmodifiableSet(newSet);
    }

    @Deprecated
    public static <S, T> Set<T> convertTo(Set<S> set, Function<? super S, ? extends T> function) {
        return Sets.convert(set, function);
    }

    public static <T> Set<T> filter(Set<T> set, Predicate<? super T> predicate) {
        Objects.requireNonNull(set);
        HashSet<T> newSet = new HashSet<T>(Math.min(Sets.calculateCapacity(set.size()), 16));
        for (T e : set) {
            if (!predicate.test(e)) continue;
            newSet.add(e);
        }
        return Collections.unmodifiableSet(newSet);
    }

    private static int calculateCapacity(int size) {
        return (int)((float)size / 0.75f) + 1;
    }
}

