/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.concurrent;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public abstract class ReferenceCounted<T extends ReferenceCounted<T>> {
    private volatile long count = 1L;
    private static final AtomicLongFieldUpdater<ReferenceCounted> COUNT = AtomicLongFieldUpdater.newUpdater(ReferenceCounted.class, "count");

    protected ReferenceCounted() {
    }

    public long refCount() {
        return this.count;
    }

    public T retain() {
        return this.retain(1);
    }

    public T retain(int increment) {
        ReferenceCounted.checkCount(increment);
        int old = (int)COUNT.getAndAdd(this, increment);
        if (old <= 0 || old + increment < old) {
            COUNT.getAndAdd(this, -increment);
            throw new IllegalStateException("Illegal retain, current reference count: " + old + ", increase count: " + increment);
        }
        return this.self();
    }

    public boolean release() {
        return this.release(1);
    }

    public boolean release(int decrement) {
        ReferenceCounted.checkCount(decrement);
        int old = (int)COUNT.getAndAdd(this, -decrement);
        if (old == decrement) {
            this.destroy();
            return true;
        }
        if (old < decrement || old - decrement > old) {
            COUNT.getAndAdd(this, decrement);
            throw new IllegalStateException("Illegal release, current reference count: " + old + ", decrease count: " + decrement);
        }
        return false;
    }

    protected abstract void destroy();

    private T self() {
        return (T)this;
    }

    private static void checkCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count " + count + " should larger than or equal with zero");
        }
    }
}

