/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.function;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class Functions {
    public static <T, R> Function<T, R> memoize(Function<T, R> function) {
        Objects.requireNonNull(function);
        if (function instanceof MemoizedFunction) {
            return function;
        }
        return new MemoizedFunction(function);
    }

    private static class MemoizedFunction<T, R>
    implements Function<T, R> {
        private final Function<T, R> function;
        private final ConcurrentMap<T, R> map = new ConcurrentHashMap<T, R>();

        private MemoizedFunction(Function<T, R> function) {
            this.function = function;
        }

        @Override
        public R apply(T t) {
            Objects.requireNonNull(t);
            Object value = this.map.get(t);
            if (value != null) {
                return (R)value;
            }
            value = this.map.computeIfAbsent(t, this.function);
            Objects.requireNonNull(value);
            return (R)value;
        }
    }
}

