/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.hash;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Objects;
import net.dongliu.commons.Hexes;
import net.dongliu.commons.Lazy;
import net.dongliu.commons.exception.DigestEncodeException;

public class Digests {
    private static final String ALG_SHA_512 = "SHA-512";
    private static final String ALG_SHA_256 = "SHA-256";
    private static final String ALG_SHA1 = "SHA1";
    private static final String ALG_MD5 = "MD5";
    private static final Lazy<Encoder> md5 = Lazy.of(() -> new Encoder(ALG_MD5));
    private static final Lazy<Encoder> sha1 = Lazy.of(() -> new Encoder(ALG_SHA1));
    private static final Lazy<Encoder> sha256 = Lazy.of(() -> new Encoder(ALG_SHA_256));
    private static final Lazy<Encoder> sha512 = Lazy.of(() -> new Encoder(ALG_SHA_512));

    public static Encoder md5() {
        return md5.get();
    }

    public static Encoder sha1() {
        return sha1.get();
    }

    public static Encoder sha256() {
        return sha256.get();
    }

    public static Encoder sha512() {
        return sha512.get();
    }

    public static class DigestResult {
        private final byte[] data;

        private DigestResult(byte[] data) {
            this.data = data;
        }

        public byte[] asBytes() {
            return this.data;
        }

        public String asHex() {
            return this.asHex(true);
        }

        public String asHex(boolean uppercase) {
            return Hexes.encoder(uppercase).encode(this.data);
        }

        public String asBase64() {
            return Base64.getEncoder().encodeToString(this.data);
        }
    }

    public static class Encoder {
        private static final int BULK_SIZE = 8192;
        private final String algorithm;

        private Encoder(String algorithm) {
            this.algorithm = algorithm;
        }

        public DigestResult digest(String str) {
            return this.digest(Objects.requireNonNull(str), StandardCharsets.UTF_8);
        }

        public DigestResult digest(String str, Charset charset) {
            Objects.requireNonNull(str);
            Objects.requireNonNull(charset);
            return this.digest(str.getBytes(charset));
        }

        public DigestResult digest(byte[] data) {
            int size;
            Objects.requireNonNull(data);
            MessageDigest md = Encoder.messageDigest(this.algorithm);
            for (int offset = 0; offset < data.length; offset += size) {
                size = Math.min(8192, data.length - offset);
                md.update(data, offset, size);
            }
            return new DigestResult(md.digest());
        }

        public DigestResult digest(InputStream in) throws IOException {
            int read;
            Objects.requireNonNull(in);
            MessageDigest md = Encoder.messageDigest(this.algorithm);
            byte[] data = new byte[8192];
            while ((read = in.read(data)) != -1) {
                md.update(data, 0, read);
            }
            return new DigestResult(md.digest());
        }

        private static MessageDigest messageDigest(String algorithm) {
            try {
                return MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new DigestEncodeException(e);
            }
        }
    }
}

