/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.io;

import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Closeables {
    public static void closeQuietly(@Nullable AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(AutoCloseable ... closeables) {
        for (AutoCloseable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeAll(@NonNull Throwable throwable, AutoCloseable ... closeables) {
        Objects.requireNonNull(throwable);
        Objects.requireNonNull(closeables);
        for (AutoCloseable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception e) {
                throwable.addSuppressed(e);
            }
        }
    }

    public static void closeAll(@NonNull Throwable throwable, @NonNull List<@Nullable AutoCloseable> closeables) {
        Objects.requireNonNull(throwable);
        Objects.requireNonNull(closeables);
        for (AutoCloseable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception e) {
                throwable.addSuppressed(e);
            }
        }
    }
}

