/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.Buffer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class Readers {
    private static final int BUFFER_SIZE = 8192;

    public static void transferTo(Reader reader, Writer writer) throws IOException {
        int count;
        char[] buffer = new char[8192];
        while ((count = reader.read(buffer)) >= 0) {
            writer.write(buffer, 0, count);
        }
    }

    public static void transferTo(Reader reader, Appendable appendable) throws IOException {
        CharBuffer charBuffer = CharBuffer.allocate(8192);
        while (reader.read(charBuffer) >= 0) {
            ((Buffer)charBuffer).flip();
            appendable.append(charBuffer);
        }
    }

    public static String readAll(Reader reader) throws IOException {
        try (StringWriter writer = new StringWriter();){
            Readers.transferTo(reader, writer);
            String string = writer.toString();
            return string;
        }
    }

    public static Stream<String> lines(Reader reader) {
        BufferedReader br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        return br.lines();
    }

    public static List<String> toLines(Reader reader) throws IOException {
        String line;
        BufferedReader br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        ArrayList<String> list = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            list.add(line);
        }
        return list;
    }

    public static long discardAll(Reader reader) throws IOException {
        int count;
        char[] buffer = new char[8192];
        long total = 0L;
        while ((count = reader.read(buffer)) >= 0) {
            total += (long)count;
        }
        return total;
    }
}

