/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.net;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.dongliu.commons.Strings;
import net.dongliu.commons.net.URLUtils;

public class URLBuilder {
    private String protocol = "";
    private String host = "";
    private int port = -1;
    private String path = "";
    private String query = "";
    private String fragment = "";

    private URLBuilder() {
    }

    public static URLBuilder ofURL(String url) throws MalformedURLException {
        return URLBuilder.ofURL(new URL(url));
    }

    public static URLBuilder ofURL(URL url) {
        Objects.requireNonNull(url);
        return new URLBuilder().protocol(url.getProtocol()).host(url.getHost()).port(url.getPort()).path(url.getPath()).query(Strings.nullToEmpty(url.getQuery())).fragment(Strings.nullToEmpty(url.getRef()));
    }

    public URLBuilder protocol(String protocol) {
        this.protocol = Objects.requireNonNull(protocol);
        return this;
    }

    public URLBuilder host(String host) {
        this.host = Objects.requireNonNull(host);
        return this;
    }

    public URLBuilder port(int port) {
        this.port = URLBuilder.checkPort(port);
        return this;
    }

    private static int checkPort(int port) {
        if (port != -1 && port < 0 || port > 65535) {
            throw new IllegalArgumentException("illegal port: " + port);
        }
        return port;
    }

    public URLBuilder path(String path) {
        this.path = Objects.requireNonNull(path);
        return this;
    }

    public URLBuilder query(String query) {
        this.query = Objects.requireNonNull(query);
        return this;
    }

    public URLBuilder query(List<Map.Entry<String, String>> params) {
        this.query = URLUtils.encodeParams(params);
        return this;
    }

    public URLBuilder query(List<Map.Entry<String, String>> params, Charset charset) {
        this.query = URLUtils.encodeParams(params, charset);
        return this;
    }

    public URLBuilder fragment(String fragment) {
        this.fragment = Objects.requireNonNull(fragment);
        return this;
    }

    public URL buildURL() throws MalformedURLException {
        StringBuilder fileBuilder = new StringBuilder();
        fileBuilder.append(this.path);
        if (!this.query.isEmpty()) {
            fileBuilder.append('?').append(this.query);
        }
        if (!this.fragment.isEmpty()) {
            fileBuilder.append('#').append(this.fragment);
        }
        return new URL(this.protocol, this.host, this.port, fileBuilder.toString());
    }

    public String buildURLString() throws MalformedURLException {
        return this.buildURL().toExternalForm();
    }
}

