/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.net;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.dongliu.commons.collection.Lists;
import net.dongliu.commons.collection.Pair;

public class URLUtils {
    public static String encode(String str, Charset charset) {
        try {
            return URLEncoder.encode(str, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decode(String str, Charset charset) {
        try {
            return URLDecoder.decode(str, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Map.Entry<String, String>> parseParams(String query) {
        return URLUtils.parseParams(query, StandardCharsets.UTF_8);
    }

    public static List<Map.Entry<String, String>> parseParams(String query, Charset charset) {
        Objects.requireNonNull(query);
        Objects.requireNonNull(charset);
        if (query.isEmpty()) {
            return Lists.of();
        }
        String[] segments = query.split("&");
        ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>(segments.length);
        for (String segment : segments) {
            int idx = segment.indexOf(61);
            Pair<String, String> param = idx < 0 ? Pair.of("", URLUtils.decode(segment, charset)) : Pair.of(URLUtils.decode(segment.substring(0, idx), charset), URLUtils.decode(segment.substring(idx + 1), charset));
            params.add(param);
        }
        return Collections.unmodifiableList(params);
    }

    public static String encodeParams(List<Map.Entry<String, String>> params) {
        return URLUtils.encodeParams(params, StandardCharsets.UTF_8);
    }

    public static String encodeParams(List<Map.Entry<String, String>> params, Charset charset) {
        StringBuilder sb = new StringBuilder();
        URLUtils.encodeParams(sb, params, charset);
        return sb.toString();
    }

    public static void encodeParams(Appendable sb, List<Map.Entry<String, String>> params, Charset charset) {
        Objects.requireNonNull(sb);
        Objects.requireNonNull(params);
        Objects.requireNonNull(charset);
        Lists.forEachLastAware(params, (param, last) -> {
            try {
                sb.append(URLUtils.encode((String)param.getKey(), charset)).append('=').append(URLUtils.encode((String)param.getValue(), charset));
                if (!last) {
                    sb.append('&');
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public static String resolve(String baseUrl, String otherUrl) throws MalformedURLException {
        return URLUtils.resolve(new URL(baseUrl), otherUrl).toExternalForm();
    }

    public static URL resolve(URL baseUrl, String otherUrl) throws MalformedURLException {
        Objects.requireNonNull(baseUrl);
        Objects.requireNonNull(otherUrl);
        if (otherUrl.isEmpty()) {
            return baseUrl;
        }
        if (otherUrl.contains(":")) {
            return new URL(otherUrl);
        }
        char firstChar = otherUrl.charAt(0);
        if (firstChar == '/') {
            if (otherUrl.length() >= 2 && otherUrl.charAt(1) == '/') {
                return new URL(baseUrl.getProtocol() + ":" + otherUrl);
            }
            return new URL(baseUrl.getProtocol(), baseUrl.getHost(), baseUrl.getPort(), otherUrl);
        }
        if (firstChar == '#') {
            String file = baseUrl.getFile();
            if (file.isEmpty()) {
                file = "/";
            }
            return new URL(baseUrl.getProtocol(), baseUrl.getHost(), baseUrl.getPort(), file + otherUrl);
        }
        return URLUtils.joinRelativeUrl(baseUrl, otherUrl, otherUrl);
    }

    private static URL joinRelativeUrl(URL baseUrl, String otherUrl, String relativePath) throws MalformedURLException {
        int pathIdx;
        String path;
        int relativeIdx;
        int lastRelativeIndex = -1;
        int depth = 1;
        block8: while ((relativeIdx = relativePath.indexOf(47, lastRelativeIndex + 1)) != -1) {
            String segment;
            switch (segment = relativePath.substring(lastRelativeIndex + 1, relativeIdx)) {
                case ".": {
                    break;
                }
                case "..": {
                    ++depth;
                    break;
                }
                default: {
                    break block8;
                }
            }
            lastRelativeIndex = relativeIdx;
        }
        if ((path = baseUrl.getPath()).isEmpty()) {
            path = "/";
        }
        int pathPrevIdx = path.length();
        while ((pathIdx = path.lastIndexOf(47, pathPrevIdx - 1)) != -1) {
            pathPrevIdx = pathIdx;
            if (--depth != 0) continue;
        }
        if (depth > 0) {
            throw new MalformedURLException("unable to concat url " + baseUrl + " and " + otherUrl);
        }
        String newPath = path.substring(0, pathPrevIdx) + '/' + relativePath.substring(lastRelativeIndex + 1);
        return new URL(baseUrl.getProtocol(), baseUrl.getHost(), baseUrl.getPort(), newPath);
    }
}

