/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.retry;

import net.dongliu.commons.retry.RetryBackOff;

public final class RetryBackOffs {
    private RetryBackOffs() {
    }

    public static RetryBackOff newFixBackOff(long delayMills) {
        return new FixDelayBackOff(delayMills);
    }

    public static RetryBackOff newExponentialBackOff(long initialDelayMillis, long maxDelayMillis) {
        return new BinaryExponentialBackOff(initialDelayMillis, maxDelayMillis);
    }

    private static long checkDelay(long delayMillis) {
        if (delayMillis < 0L) {
            throw new IllegalArgumentException("delay time less than 0: " + delayMillis);
        }
        return delayMillis;
    }

    private static class BinaryExponentialBackOff
    implements RetryBackOff {
        private final long initialDelay;
        private final long maxDelay;

        private BinaryExponentialBackOff(long initialDelay, long maxDelay) {
            this.initialDelay = RetryBackOffs.checkDelay(initialDelay);
            this.maxDelay = RetryBackOffs.checkDelay(maxDelay);
        }

        @Override
        public long nextIntervalOf(int retryTimes, long lastDelayMills, long lastSecondDelayMillis) {
            if (lastDelayMills == 0L) {
                return Math.min(this.initialDelay, this.maxDelay);
            }
            if (lastDelayMills >= this.maxDelay) {
                return lastDelayMills;
            }
            return Math.min(lastDelayMills * 2L, this.maxDelay);
        }
    }

    private static class FixDelayBackOff
    implements RetryBackOff {
        private final long delay;

        private FixDelayBackOff(long delay) {
            this.delay = RetryBackOffs.checkDelay(delay);
        }

        @Override
        public long nextIntervalOf(int retryTimes, long lastDelayMills, long lastSecondDelayMillis) {
            return this.delay;
        }
    }
}

