/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.sequence;

import java.util.NoSuchElementException;
import java.util.function.Predicate;
import net.dongliu.commons.sequence.Sequence;

class DropWhileSequence<T>
implements Sequence<T> {
    private final Sequence<T> sequence;
    private final Predicate<? super T> predicate;
    private boolean meet = true;
    private T firstValue;

    DropWhileSequence(Sequence<T> sequence, Predicate<? super T> predicate) {
        this.sequence = sequence;
        this.predicate = predicate;
    }

    @Override
    public boolean hasNext() {
        if (this.firstValue != null) {
            return true;
        }
        if (this.meet) {
            while (this.sequence.hasNext()) {
                T value = this.sequence.next();
                if (this.predicate.test(value)) continue;
                this.firstValue = value;
                this.meet = false;
                return true;
            }
        }
        return this.sequence.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.firstValue != null) {
            T value = this.firstValue;
            this.firstValue = null;
            return value;
        }
        return this.sequence.next();
    }
}

