/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.sequence;

import java.util.NoSuchElementException;
import net.dongliu.commons.sequence.Sequence;

class SliceSequence<T>
implements Sequence<T> {
    private final Sequence<T> sequence;
    private final long from;
    private final long to;
    private long index = 0L;

    SliceSequence(Sequence<T> sequence, long from, long to) {
        this.sequence = sequence;
        this.from = from;
        this.to = to;
    }

    @Override
    public boolean hasNext() {
        while (this.index < this.from) {
            if (!this.sequence.hasNext()) {
                return false;
            }
            if (this.index >= this.to) {
                return false;
            }
            this.sequence.next();
            ++this.index;
        }
        if (this.index >= this.to) {
            return false;
        }
        return this.sequence.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T value = this.sequence.next();
        ++this.index;
        return value;
    }
}

