/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.commons.sequence;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.dongliu.commons.sequence.Sequence;

class SortedSequence<T>
implements Sequence<T> {
    private Sequence<T> original;
    private final Comparator<? super T> comparator;
    private Sequence<T> delegate = null;

    SortedSequence(Sequence<T> original, Comparator<? super T> comparator) {
        this.original = original;
        this.comparator = comparator;
    }

    @Override
    public boolean hasNext() {
        if (this.delegate == null) {
            if (!this.original.hasNext()) {
                return false;
            }
            ArrayList<T> list = this.original.toArrayList();
            if (list.size() == 1) {
                Comparator value = (Comparator)Objects.requireNonNull(list.get(0));
                this.delegate = Sequence.of(list.get(0));
            } else {
                list.sort(this.comparator);
                this.delegate = Sequence.of(list);
            }
            this.original = null;
        }
        return this.delegate.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.delegate.next();
    }
}

