/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.lang.util;

import java.util.Collection;
import org.apache.shiro.lang.ShiroException;
import org.apache.shiro.lang.util.Destroyable;
import org.apache.shiro.lang.util.Initializable;

public abstract class LifecycleUtils {
    public static void init(Object o) throws ShiroException {
        if (o instanceof Initializable) {
            LifecycleUtils.init((Initializable)o);
        }
    }

    public static void init(Initializable initializable) throws ShiroException {
        initializable.init();
    }

    public static void init(Collection c) throws ShiroException {
        if (c == null || c.isEmpty()) {
            return;
        }
        for (Object o : c) {
            LifecycleUtils.init(o);
        }
    }

    public static void destroy(Object o) {
        if (o instanceof Destroyable) {
            LifecycleUtils.destroy((Destroyable)o);
        } else if (o instanceof Collection) {
            LifecycleUtils.destroy((Collection)o);
        }
    }

    public static void destroy(Destroyable d) {
        if (d != null) {
            try {
                d.destroy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void destroy(Collection c) {
        if (c == null || c.isEmpty()) {
            return;
        }
        for (Object o : c) {
            LifecycleUtils.destroy(o);
        }
    }
}

