/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.env;

import javax.servlet.ServletContext;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.config.ResourceConfigurable;
import org.apache.shiro.util.ClassUtils;
import org.apache.shiro.util.LifecycleUtils;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.util.UnknownClassException;
import org.apache.shiro.web.env.IniWebEnvironment;
import org.apache.shiro.web.env.MutableWebEnvironment;
import org.apache.shiro.web.env.WebEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentLoader {
    public static final String ENVIRONMENT_CLASS_PARAM = "shiroEnvironmentClass";
    public static final String CONFIG_LOCATIONS_PARAM = "shiroConfigLocations";
    public static final String ENVIRONMENT_ATTRIBUTE_KEY = EnvironmentLoader.class.getName() + ".ENVIRONMENT_ATTRIBUTE_KEY";
    private static final Logger log = LoggerFactory.getLogger(EnvironmentLoader.class);

    public WebEnvironment initEnvironment(ServletContext servletContext) throws IllegalStateException {
        if (servletContext.getAttribute(ENVIRONMENT_ATTRIBUTE_KEY) != null) {
            String msg = "There is already a Shiro environment associated with the current ServletContext.  Check if you have multiple EnvironmentLoader* definitions in your web.xml!";
            throw new IllegalStateException(msg);
        }
        servletContext.log("Initializing Shiro environment");
        log.info("Starting Shiro environment initialization.");
        long startTime = System.currentTimeMillis();
        try {
            WebEnvironment environment2 = this.createEnvironment(servletContext);
            servletContext.setAttribute(ENVIRONMENT_ATTRIBUTE_KEY, environment2);
            log.debug("Published WebEnvironment as ServletContext attribute with name [{}]", (Object)ENVIRONMENT_ATTRIBUTE_KEY);
            if (log.isInfoEnabled()) {
                long elapsed = System.currentTimeMillis() - startTime;
                log.info("Shiro environment initialized in {} ms.", (Object)elapsed);
            }
            return environment2;
        }
        catch (RuntimeException ex) {
            log.error("Shiro environment initialization failed", ex);
            servletContext.setAttribute(ENVIRONMENT_ATTRIBUTE_KEY, ex);
            throw ex;
        }
        catch (Error err) {
            log.error("Shiro environment initialization failed", err);
            servletContext.setAttribute(ENVIRONMENT_ATTRIBUTE_KEY, err);
            throw err;
        }
    }

    protected Class<?> determineWebEnvironmentClass(ServletContext servletContext) {
        String className = servletContext.getInitParameter(ENVIRONMENT_CLASS_PARAM);
        if (className != null) {
            try {
                return ClassUtils.forName(className);
            }
            catch (UnknownClassException ex) {
                throw new ConfigurationException("Failed to load custom WebEnvironment class [" + className + "]", ex);
            }
        }
        return IniWebEnvironment.class;
    }

    protected WebEnvironment createEnvironment(ServletContext sc) {
        Class<?> clazz = this.determineWebEnvironmentClass(sc);
        if (!MutableWebEnvironment.class.isAssignableFrom(clazz)) {
            throw new ConfigurationException("Custom WebEnvironment class [" + clazz.getName() + "] is not of required type [" + WebEnvironment.class.getName() + "]");
        }
        String configLocations = sc.getInitParameter(CONFIG_LOCATIONS_PARAM);
        boolean configSpecified = StringUtils.hasText(configLocations);
        if (configSpecified && !ResourceConfigurable.class.isAssignableFrom(clazz)) {
            String msg = "WebEnvironment class [" + clazz.getName() + "] does not implement the " + ResourceConfigurable.class.getName() + "interface.  This is required to accept any " + "configured " + CONFIG_LOCATIONS_PARAM + "value(s).";
            throw new ConfigurationException(msg);
        }
        MutableWebEnvironment environment2 = (MutableWebEnvironment)ClassUtils.newInstance(clazz);
        environment2.setServletContext(sc);
        if (configSpecified && environment2 instanceof ResourceConfigurable) {
            ((ResourceConfigurable)((Object)environment2)).setConfigLocations(configLocations);
        }
        this.customizeEnvironment(environment2);
        LifecycleUtils.init(environment2);
        return environment2;
    }

    protected void customizeEnvironment(WebEnvironment environment2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyEnvironment(ServletContext servletContext) {
        servletContext.log("Cleaning up Shiro Environment");
        try {
            Object environment2 = servletContext.getAttribute(ENVIRONMENT_ATTRIBUTE_KEY);
            LifecycleUtils.destroy(environment2);
        }
        finally {
            servletContext.removeAttribute(ENVIRONMENT_ATTRIBUTE_KEY);
        }
    }
}

