/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.env;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.config.Ini;
import org.apache.shiro.io.ResourceUtils;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.Destroyable;
import org.apache.shiro.util.Initializable;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.web.config.IniFilterChainResolverFactory;
import org.apache.shiro.web.config.WebIniSecurityManagerFactory;
import org.apache.shiro.web.env.ResourceBasedWebEnvironment;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IniWebEnvironment
extends ResourceBasedWebEnvironment
implements Initializable,
Destroyable {
    public static final String DEFAULT_WEB_INI_RESOURCE_PATH = "/WEB-INF/shiro.ini";
    private static final Logger log = LoggerFactory.getLogger(IniWebEnvironment.class);
    private Ini ini;

    @Override
    public void init() {
        Ini ini = this.getIni();
        String[] configLocations = this.getConfigLocations();
        if (log.isWarnEnabled() && !CollectionUtils.isEmpty(ini) && configLocations != null && configLocations.length > 0) {
            log.warn("Explicit INI instance has been provided, but configuration locations have also been specified.  The {} implementation does not currently support multiple Ini config, but this may be supported in the future. Only the INI instance will be used for configuration.", (Object)IniWebEnvironment.class.getName());
        }
        if (CollectionUtils.isEmpty(ini)) {
            log.debug("Checking any specified config locations.");
            ini = this.getSpecifiedIni(configLocations);
        }
        if (CollectionUtils.isEmpty(ini)) {
            log.debug("No INI instance or config locations specified.  Trying default config locations.");
            ini = this.getDefaultIni();
        }
        if (CollectionUtils.isEmpty(ini)) {
            String msg = "Shiro INI configuration was either not found or discovered to be empty/unconfigured.";
            throw new ConfigurationException(msg);
        }
        this.setIni(ini);
        this.configure();
    }

    protected void configure() {
        this.objects.clear();
        WebSecurityManager securityManager = this.createWebSecurityManager();
        this.setWebSecurityManager(securityManager);
        FilterChainResolver resolver = this.createFilterChainResolver();
        if (resolver != null) {
            this.setFilterChainResolver(resolver);
        }
    }

    protected Ini getSpecifiedIni(String[] configLocations) throws ConfigurationException {
        Ini ini = null;
        if (configLocations != null && configLocations.length > 0) {
            if (configLocations.length > 1) {
                log.warn("More than one Shiro .ini config location has been specified.  Only the first will be used for configuration as the {} implementation does not currently support multiple files.  This may be supported in the future however.", (Object)IniWebEnvironment.class.getName());
            }
            ini = this.createIni(configLocations[0], true);
        }
        return ini;
    }

    protected Ini getDefaultIni() {
        Ini ini = null;
        String[] configLocations = this.getDefaultConfigLocations();
        if (configLocations != null) {
            for (String location : configLocations) {
                ini = this.createIni(location, false);
                if (CollectionUtils.isEmpty(ini)) continue;
                log.debug("Discovered non-empty INI configuration at location '{}'.  Using for configuration.", (Object)location);
                break;
            }
        }
        return ini;
    }

    protected Ini createIni(String configLocation, boolean required) throws ConfigurationException {
        Ini ini = null;
        if (configLocation != null) {
            ini = this.convertPathToIni(configLocation, required);
        }
        if (required && CollectionUtils.isEmpty(ini)) {
            String msg = "Required configuration location '" + configLocation + "' does not exist or did not " + "contain any INI configuration.";
            throw new ConfigurationException(msg);
        }
        return ini;
    }

    protected FilterChainResolver createFilterChainResolver() {
        FilterChainResolver resolver = null;
        Ini ini = this.getIni();
        if (!CollectionUtils.isEmpty(ini)) {
            Ini.Section urls = ini.getSection("urls");
            Ini.Section filters = ini.getSection("filters");
            if (!CollectionUtils.isEmpty(urls) || !CollectionUtils.isEmpty(filters)) {
                IniFilterChainResolverFactory factory = new IniFilterChainResolverFactory(ini, this.objects);
                resolver = (FilterChainResolver)factory.getInstance();
            }
        }
        return resolver;
    }

    protected WebSecurityManager createWebSecurityManager() {
        Ini ini = this.getIni();
        WebIniSecurityManagerFactory factory = CollectionUtils.isEmpty(ini) ? new WebIniSecurityManagerFactory() : new WebIniSecurityManagerFactory(ini);
        WebSecurityManager wsm = (WebSecurityManager)factory.getInstance();
        Map<String, ?> beans2 = factory.getBeans();
        if (!CollectionUtils.isEmpty(beans2)) {
            this.objects.putAll(beans2);
        }
        return wsm;
    }

    protected String[] getDefaultConfigLocations() {
        return new String[]{DEFAULT_WEB_INI_RESOURCE_PATH, "classpath:shiro.ini"};
    }

    private Ini convertPathToIni(String path, boolean required) {
        Ini ini = null;
        if (StringUtils.hasText(path)) {
            InputStream is;
            block9: {
                is = null;
                if (!ResourceUtils.hasResourcePrefix(path)) {
                    is = this.getServletContextResourceStream(path);
                } else {
                    try {
                        is = ResourceUtils.getInputStreamForPath(path);
                    }
                    catch (IOException e) {
                        if (required) {
                            throw new ConfigurationException(e);
                        }
                        if (!log.isDebugEnabled()) break block9;
                        log.debug("Unable to load optional path '" + path + "'.", e);
                    }
                }
            }
            if (is != null) {
                ini = new Ini();
                ini.load(is);
            } else if (required) {
                throw new ConfigurationException("Unable to load resource path '" + path + "'");
            }
        }
        return ini;
    }

    private InputStream getServletContextResourceStream(String path) {
        InputStream is = null;
        path = WebUtils.normalize(path);
        ServletContext sc = this.getServletContext();
        if (sc != null) {
            is = sc.getResourceAsStream(path);
        }
        return is;
    }

    public Ini getIni() {
        return this.ini;
    }

    public void setIni(Ini ini) {
        this.ini = ini;
    }
}

