/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.servlet;

import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.web.servlet.ServletContextSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFilter
extends ServletContextSupport
implements Filter {
    private static final transient Logger log = LoggerFactory.getLogger(AbstractFilter.class);
    protected FilterConfig filterConfig;

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        this.setServletContext(filterConfig.getServletContext());
    }

    protected String getInitParam(String paramName) {
        FilterConfig config = this.getFilterConfig();
        if (config != null) {
            return StringUtils.clean(config.getInitParameter(paramName));
        }
        return null;
    }

    @Override
    public final void init(FilterConfig filterConfig) throws ServletException {
        this.setFilterConfig(filterConfig);
        try {
            this.onFilterConfigSet();
        }
        catch (Exception e) {
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            if (log.isErrorEnabled()) {
                log.error("Unable to start Filter: [" + e.getMessage() + "].", e);
            }
            throw new ServletException(e);
        }
    }

    protected void onFilterConfigSet() throws Exception {
    }

    @Override
    public void destroy() {
    }
}

