import React, { useState } from 'react'
import { Alert } from 'antd'
import { useTransition, animated } from '@react-spring/web'
import { config } from '@react-spring/core'

const Toggle = () => {
  const [toggle, setToggle] = useState(false)
  const transitions = useTransition(toggle, {
    from: { position: 'absolute', opacity: 0 },
    enter: { opacity: 1 },
    leave: { opacity: 0 },
    reverse: toggle,
    delay: 200,
    config: config.molasses,
    onRest: () => setToggle(!toggle),
  })
  return transitions(({ opacity }, item) =>
    item ? (
      <animated.div
        style={{
          position: 'absolute',
          opacity: opacity.to({ range: [0.0, 1.0], output: [0, 1] }),
        }}
      >
        <Alert
          title="Success Tips"
          description="Detailed description and advice about successful copywriting."
          type="success"
          showIcon
        />
      </animated.div>
    ) : (
      <animated.div
        style={{
          position: 'absolute',
          opacity: opacity.to({ range: [1.0, 0.0], output: [1, 0] }),
        }}
      >
        <Alert
          title="Informational Notes"
          description="Additional description and information about copywriting."
          type="info"
          showIcon
        />
      </animated.div>
    )
  )
}
export default Toggle
