package com.meethere.SystemFunctionalTesting;// Generated by Selenium IDE
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.CoreMatchers.is;


import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.openqa.selenium.By;
import org.springframework.core.annotation.Order;

@TestMethodOrder(MethodOrderer.OrderAnnotation.class)
public class LoginTest extends BaseTest {

  @Order(1)
  @Test
  public void login_success_user() {
    driver.get("http://localhost:8888/index");
    assertThat(driver.getTitle(), is("MeetHere"));
    driver.findElement(By.linkText("登录")).click();
    assertThat(driver.getTitle(), is("登录-MeetHere"));
    driver.findElement(By.id("userID")).sendKeys("test001");
    driver.findElement(By.id("password")).click();
    driver.findElement(By.id("password")).sendKeys("1234");
    driver.findElement(By.id("submit")).click();
    assertThat(driver.getTitle(), is("MeetHere"));
    driver.close();
  }

  @Order(2)
  @Test
  public void login_fail_when_userId_is_null() {
    driver.get("http://localhost:8888/index");
    assertThat(driver.getTitle(), is("MeetHere"));
    driver.findElement(By.linkText("登录")).click();
    assertThat(driver.getTitle(), is("登录-MeetHere"));
    driver.findElement(By.id("password")).click();
    driver.findElement(By.id("password")).sendKeys("1234");
    driver.findElement(By.id("submit")).click();
    assertThat(driver.getTitle(), is("登录-MeetHere"));
    driver.close();
  }

  @Order(3)
  @Test
  public void login_fail_when_user_not_exist() {
    driver.get("http://localhost:8888/index");
    assertThat(driver.getTitle(), is("MeetHere"));
    driver.findElement(By.linkText("登录")).click();
    assertThat(driver.getTitle(), is("登录-MeetHere"));
    driver.findElement(By.id("userID")).sendKeys("user000");
    driver.findElement(By.id("password")).click();
    driver.findElement(By.id("password")).sendKeys("1234");
    driver.findElement(By.id("submit")).click();
    assertThat(driver.getTitle(), is("登录-MeetHere"));
    assertThat(driver.findElement(By.cssSelector(".alert")).getText(), is("用户名或密码错误，请重新输入！"));
    driver.close();
  }

  @Order(4)
  @Test
  public void login_fail_when_password_is_null() {
    driver.get("http://localhost:8888/index");
    assertThat(driver.getTitle(), is("MeetHere"));
    driver.findElement(By.linkText("登录")).click();
    assertThat(driver.getTitle(), is("登录-MeetHere"));
    driver.findElement(By.id("userID")).sendKeys("test001");
    driver.findElement(By.id("submit")).click();
    assertThat(driver.getTitle(), is("登录-MeetHere"));
    driver.close();
  }

  @Order(5)
  @Test
  public void login_fail_when_password_not_match() {
    driver.get("http://localhost:8888/index");
    assertThat(driver.getTitle(), is("MeetHere"));
    driver.findElement(By.linkText("登录")).click();
    assertThat(driver.getTitle(), is("登录-MeetHere"));
    driver.findElement(By.id("userID")).sendKeys("user001");
    driver.findElement(By.id("password")).click();
    driver.findElement(By.id("password")).sendKeys("1");
    driver.findElement(By.id("submit")).click();
    assertThat(driver.getTitle(), is("登录-MeetHere"));
    assertThat(driver.findElement(By.cssSelector(".alert")).getText(), is("用户名或密码错误，请重新输入！"));
    driver.close();
  }

  @Order(6)
  @Test
  public void login_success_admin() {
    driver.get("http://localhost:8888/index");
    assertThat(driver.getTitle(), is("MeetHere"));
    driver.findElement(By.linkText("登录")).click();
    assertThat(driver.getTitle(), is("登录-MeetHere"));
    driver.findElement(By.id("userID")).sendKeys("admin");
    driver.findElement(By.id("password")).click();
    driver.findElement(By.id("password")).sendKeys("admin");
    driver.findElement(By.id("submit")).click();
    assertThat(driver.getTitle(), is("MeetHere-管理系统"));
    driver.close();
  }
}
