---
order: 8
title: Layout New Style
group:
  title: Blog
  path: /
nav:
  title: Blog
  path: /blog
  order: 3
time: 2020-04-21
---

With the release of the official version of antd, layout will also usher in a new design style. The new style will still focus on technology, optimizing the size and experience details on the basis of the original, designing more concisely and matching more business scenarios.

## AntDesign Pro Modification Points

| Content | Modify point |
| --- | --- |
| Navigation dimensions | Top navigation height changed from AntDesign Pro 64px to 48px - Side navigation width changed from AntDesign Pro 256px to 208px |
| Navigation layout mode | Add a hybrid mode based on the original one-sided edge or top navigation mode, and align it with the techUI's existing mode. |
| Top navigation detail optimization | Global search style modification, interactive modification with the top menu, open the search squeeze menu, turn off the search back to normal state - utility area Hover color modification, from blue to dark black #161726 |
| Side navigation detail optimization | Add custom accessibility actions to side navigation, pull filtering below - side navigation expands the collection icon modification, places at the bottom of side navigation - increases menu name is too long, menu height small information hidden interaction default to fixed mode |
| Mixed Mode | Top navigation provides custom top navigation that matches the original, but adds a perforated top bar. |

## The navigation menu section

### Structure and size

Side navigation width changed from 256px to 208px, navigation content and front and rear margins changed to 16px.

![image.png](https://gw.alipayobjects.com/zos/antfincdn/sEHoMffUP%26/1586503920221-16d9c22e-1373-40c9-8d08-e6edf5c68ee2.png)

### Custom secondary actions

Add custom assists, pull filter below.

![image.png](https://gw.alipayobjects.com/zos/antfincdn/gScRFjhdce/1586503972482-1f62c5ec-e6ce-478f-a7c6-2362d7c888f1.png)

### Menus are too long for too many interactions

The menu name is too long, the abbreviation is displayed, and hover appears with all the tooltip prompts.

![image.png](https://gw.alipayobjects.com/zos/antfincdn/4gtxYL3HP8/1586505237583-656e788e-d9d0-4d14-9278-dac102b9edd0.png)

When the menu name is too large or folds, the top title product title area, the auxiliary operating area and the bottom universal operating area are fixed, and the middle function menu area is sliding. Shadow splits appear in the upper and lower areas.

## Top navigation interaction section

Changes to interaction and navigation are the biggest changes this time.

### Structure and size

Top navigation height changed from 64px to 48px.

![image.png](https://gw.alipayobjects.com/zos/antfincdn/UtfyUhUaSV/1586502220305-25adb29e-5609-4eda-b4c4-ca117ec52580.png)

### Color version

Continue to offer dark, bright white versions, which change from `#001529` to OneX with the same dark `#1F293D`.

![image.png](https://gw.alipayobjects.com/zos/antfincdn/BnkRy%26WUJ9/1586502256521-88d3b504-de75-4ac0-a7c9-d6cd15bcae99%252520%281%29.png)

### Search interaction optimization

Search activates style modification, opens search squeeze menu, turns search back to normal.

![image.png](https://gw.alipayobjects.com/zos/antfincdn/0Xx9XYePgQ/1586503735289-59c77d00-2428-49a8-9bd2-d47330e2831c%252520%281%29.png)

### Utility Hover effect optimization

Utility Hover changed from blue background to dark black `#161726`.

![image.png](hthttps://gw.alipayobjects.com/zos/antfincdn/dvccJS41Tl/1586503854420-8236a5b9-66da-48a7-9f58-ea5c40a3b479.png)

## Mixed Menu New Mode

Top Global Navigation plus Side Navigation Blend mode, which supports Ant Design Pro's existing navigation mode to switch to this mode.

![image.png](https://gw.alipayobjects.com/zos/antfincdn/HSeAGqaEwn/1586504755352-479bf47d-97a6-4080-afed-d38ffe905e57.png)

### Demo

![image.png](https://gw.alipayobjects.com/zos/antfincdn/1r4WQhweas/1586964514728-bdca9455-e887-4c94-8091-30cf008937c8.png)
