/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.ae2.crafting;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.crafting.IPatternDetails;
import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.crafting.ICraftingSubmitResult;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.CraftingJobStatusPacket;
import appeng.crafting.CraftingLink;
import appeng.crafting.execution.CraftingCpuHelper;
import appeng.crafting.execution.CraftingCpuLogic;
import appeng.crafting.execution.CraftingSubmitResult;
import appeng.crafting.execution.ElapsedTimeTracker;
import appeng.crafting.inv.ICraftingInventory;
import appeng.crafting.inv.ListCraftingInventory;
import appeng.hooks.ticking.TickHandler;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.me.service.CraftingService;
import com.fast.fastcollection.OpenCacheHashSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gtocore.api.ae2.crafting.ExecutingCraftingJob;
import com.gtocore.common.data.GTOItems;
import com.gtocore.config.GTOConfig;
import com.gtocore.integration.ae.CraftingCpuHelperExtended;
import com.gtolib.GTOCore;
import com.gtolib.api.ae2.IPatternProviderLogic;
import com.gtolib.api.ae2.pattern.IDetails;
import com.gtolib.api.ae2.pattern.IParallelPatternDetails;
import com.gtolib.api.ae2.stacks.IKeyCounter;
import com.gtolib.utils.holder.IntHolder;
import com.gtolib.utils.holder.LongHolder;
import com.gtolib.utils.holder.ObjectHolder;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class OptimizedCraftingCpuLogic
extends CraftingCpuLogic {
    private ExecutingCraftingJob job = null;
    private Consumer<AEKey> listener = null;
    private final SetMultimap<AEKey, GlobalPos> pendingRequests = Multimaps.newSetMultimap((Map)new Reference2ReferenceOpenHashMap(), OpenCacheHashSet::new);
    private final SetMultimap<AEKey, IPatternProviderLogic.PushResult> craftingResults = Multimaps.newSetMultimap((Map)new Reference2ReferenceOpenHashMap(), ReferenceOpenHashSet::new);

    public OptimizedCraftingCpuLogic(CraftingCPUCluster cluster) {
        super(cluster);
    }

    protected void postChange(AEKey what) {
        this.lastModifiedOnTick = TickHandler.instance().getCurrentTick();
        if (this.listener != null) {
            this.listener.accept(what);
        }
    }

    public ICraftingSubmitResult trySubmitJob(IGrid grid, ICraftingPlan plan, IActionSource src, ICraftingRequester requester) {
        KeyCounter missingIng;
        if (this.job != null) {
            return CraftingSubmitResult.CPU_BUSY;
        }
        if (!this.cluster.isActive()) {
            return CraftingSubmitResult.CPU_OFFLINE;
        }
        if (this.cluster.getAvailableStorage() < plan.bytes()) {
            return CraftingSubmitResult.CPU_TOO_SMALL;
        }
        if (!this.inventory.list.isEmpty()) {
            GTOCore.LOGGER.error("Crafting CPU inventory is not empty yet a job was submitted.");
        }
        if (GTOConfig.INSTANCE.allowMissingCraftingJobs && src.player().isPresent()) {
            missingIng = CraftingCpuHelperExtended.tryExtractInitialItemsIgnoreMissing(plan, grid, this.inventory, src);
        } else {
            GenericStack missingIngredient = CraftingCpuHelper.tryExtractInitialItems((ICraftingPlan)plan, (IGrid)grid, (ListCraftingInventory)this.inventory, (IActionSource)src);
            if (missingIngredient != null) {
                return CraftingSubmitResult.missingIngredient((GenericStack)missingIngredient);
            }
            missingIng = new KeyCounter();
        }
        Integer playerId = src.player().map(p -> {
            Integer n;
            if (p instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)p;
                n = IPlayerRegistry.getPlayerId((ServerPlayer)serverPlayer);
            } else {
                n = null;
            }
            return n;
        }).orElse(null);
        UUID craftId = UUID.randomUUID();
        CraftingLink linkCpu = new CraftingLink(CraftingCpuHelper.generateLinkData((UUID)craftId, (requester == null ? 1 : 0) != 0, (boolean)false), (ICraftingCPU)this.cluster);
        this.job = new ExecutingCraftingJob(plan, this::postChange, linkCpu, playerId, missingIng);
        this.cluster.updateOutput(plan.finalOutput());
        this.cluster.markDirty();
        this.notifyJobOwner(this.job, CraftingJobStatusPacket.Status.STARTED);
        if (requester != null) {
            CraftingLink linkReq = new CraftingLink(CraftingCpuHelper.generateLinkData((UUID)craftId, (boolean)false, (boolean)true), requester);
            CraftingService craftingService = (CraftingService)grid.getCraftingService();
            craftingService.addLink(linkCpu);
            craftingService.addLink(linkReq);
            return CraftingSubmitResult.successful((ICraftingLink)linkReq);
        }
        return CraftingSubmitResult.successful(null);
    }

    public void tickCraftingLogic(IEnergyService eg, CraftingService cc) {
        long waitingFor;
        AEItemKey itemKey;
        AEKey aEKey;
        GenericStack stack;
        if (!this.cluster.isActive()) {
            return;
        }
        this.cantStoreItems = false;
        if (this.job == null) {
            this.storeItems();
            if (!this.inventory.list.isEmpty()) {
                this.cantStoreItems = true;
            }
            return;
        }
        if (this.job.link.isCanceled()) {
            this.cancel();
            return;
        }
        if (this.executeCrafting(this.cluster.getCoProcessors(), cc, eg, this.cluster.getLevel()) == 0 && (stack = this.getFinalJobOutput()) != null && (aEKey = stack.what()) instanceof AEItemKey && (itemKey = (AEItemKey)aEKey).getItem() == GTOItems.ORDER.get() && (waitingFor = this.getWaitingFor((AEKey)itemKey)) > 0L) {
            long remainingAmount = this.job.remainingAmount - waitingFor;
            if (remainingAmount <= 0L) {
                this.finishJob(true);
                this.cluster.updateOutput(null);
            } else {
                this.cluster.updateOutput(new GenericStack((AEKey)itemKey, remainingAmount));
            }
        }
    }

    private static void purgePatternEverywhere(Reference2ObjectOpenHashMap<AEKey, Object2LongOpenHashMap<IPatternDetails>> allocations, Object patternDefinition) {
        if (allocations == null || allocations.isEmpty() || patternDefinition == null) {
            return;
        }
        ObjectIterator outIt = allocations.reference2ObjectEntrySet().fastIterator();
        while (outIt.hasNext()) {
            Reference2ObjectMap.Entry out = (Reference2ObjectMap.Entry)outIt.next();
            Object2LongOpenHashMap inner = (Object2LongOpenHashMap)out.getValue();
            if (inner == null || inner.isEmpty()) {
                outIt.remove();
                continue;
            }
            ObjectIterator inIt = inner.object2LongEntrySet().fastIterator();
            while (inIt.hasNext()) {
                Object2LongMap.Entry pe = (Object2LongMap.Entry)inIt.next();
                if (!((IPatternDetails)pe.getKey()).getDefinition().equals(patternDefinition)) continue;
                inIt.remove();
            }
            if (!inner.isEmpty()) continue;
            outIt.remove();
        }
    }

    private int executeCrafting(int maxPatterns, CraftingService craftingService, IEnergyService energyService, Level level) {
        ExecutingCraftingJob job = this.job;
        if (job == null) {
            return 0;
        }
        IntHolder pushedPatterns = new IntHolder(0);
        ObjectIterator it = job.tasks.object2ObjectEntrySet().fastIterator();
        block8: while (it.hasNext()) {
            Object2ObjectMap.Entry task = (Object2ObjectMap.Entry)it.next();
            LongHolder progress = (LongHolder)task.getValue();
            if (progress.value <= 0L) {
                it.remove();
                continue;
            }
            if (!job.allocations.isEmpty()) {
                job.defsToPurge.clear();
                ObjectIterator outerIt = job.allocations.reference2ObjectEntrySet().fastIterator();
                while (outerIt.hasNext()) {
                    Reference2ObjectMap.Entry outer = (Reference2ObjectMap.Entry)outerIt.next();
                    Object2LongOpenHashMap inner = (Object2LongOpenHashMap)outer.getValue();
                    if (inner == null || inner.isEmpty()) continue;
                    ObjectIterator peIt = inner.object2LongEntrySet().fastIterator();
                    while (peIt.hasNext()) {
                        Object2LongMap.Entry pe = (Object2LongMap.Entry)peIt.next();
                        if (pe.getLongValue() > 0L) continue;
                        job.defsToPurge.add((Object)((IPatternDetails)pe.getKey()).getDefinition());
                    }
                }
                for (AEKey def : job.defsToPurge) {
                    OptimizedCraftingCpuLogic.purgePatternEverywhere(job.allocations, def);
                }
            }
            IPatternDetails tmp_details = (IPatternDetails)task.getKey();
            boolean isParallel = tmp_details instanceof IParallelPatternDetails;
            job.expectedOutputs.clear();
            ObjectHolder craftingContainer = new ObjectHolder(null);
            long parallelValue = 1L;
            if (isParallel && progress.value > 1L) {
                long parallel = OptimizedCraftingCpuLogic.getMaxParallel(progress.value, tmp_details, (Reference2LongOpenHashMap<AEKey>)IKeyCounter.of((KeyCounter)this.inventory.list).gtolib$getMap());
                if (parallel == 0L) continue;
                if (parallel > 1L) {
                    IParallelPatternDetails parallelPatternDetails = ((IParallelPatternDetails)tmp_details).getCopy();
                    parallelPatternDetails.parallel(parallel);
                    craftingContainer.value = OptimizedCraftingCpuLogic.extractPatternInputs((IPatternDetails)parallelPatternDetails, this.inventory, job.expectedOutputs);
                    if (craftingContainer.value == null) continue;
                    parallelValue = parallel;
                    tmp_details = parallelPatternDetails;
                }
            } else {
                craftingContainer.value = OptimizedCraftingCpuLogic.extractPatternInputs(tmp_details, this.inventory, job.expectedOutputs);
            }
            if (craftingContainer.value == null) continue;
            IPatternDetails details = tmp_details;
            AEKey targetOutputKey = details.getPrimaryOutput().what();
            boolean allocationLimited = false;
            long cappedParallel = parallelValue;
            if (!job.allocations.isEmpty()) {
                job.totalConsumed.clear();
                for (KeyCounter kc : (KeyCounter[])craftingContainer.value) {
                    if (kc == null) continue;
                    for (Reference2LongMap.Entry entry : kc) {
                        job.totalConsumed.addTo((Object)((AEKey)entry.getKey()), entry.getLongValue());
                    }
                }
                long minAllowedUnits = Long.MAX_VALUE;
                AEItemKey patternDefinition = details.getDefinition();
                ObjectIterator eIt = job.totalConsumed.reference2LongEntrySet().fastIterator();
                while (eIt.hasNext()) {
                    long perUnit;
                    Reference2LongMap.Entry e = (Reference2LongMap.Entry)eIt.next();
                    AEKey consumedKey = (AEKey)e.getKey();
                    long consumedTotal = e.getLongValue();
                    Object2LongOpenHashMap allocMap = (Object2LongOpenHashMap)job.allocations.get((Object)consumedKey);
                    if (allocMap == null || allocMap.isEmpty()) continue;
                    IPatternDetails allocKey = null;
                    ObjectIterator aeIt = allocMap.object2LongEntrySet().fastIterator();
                    while (aeIt.hasNext()) {
                        Object2LongMap.Entry ae = (Object2LongMap.Entry)aeIt.next();
                        if (!((IPatternDetails)ae.getKey()).getDefinition().equals(patternDefinition)) continue;
                        allocKey = (IPatternDetails)ae.getKey();
                        break;
                    }
                    if (allocKey == null) {
                        this.craftingResults.put((Object)targetOutputKey, (Object)IPatternProviderLogic.PushResult.INSUFFICIENT_PRIORITY);
                        CraftingCpuHelper.reinjectPatternInputs((ICraftingInventory)this.inventory, (KeyCounter[])((KeyCounter[])craftingContainer.value));
                        continue block8;
                    }
                    long quota = allocMap.getLong(allocKey);
                    long allowedUnits = quota / (perUnit = Math.max(1L, consumedTotal / parallelValue));
                    if (allowedUnits >= minAllowedUnits || (minAllowedUnits = allowedUnits) != 0L) continue;
                    break;
                }
                if (minAllowedUnits != Long.MAX_VALUE) {
                    if (minAllowedUnits <= 0L) {
                        this.craftingResults.put((Object)targetOutputKey, (Object)IPatternProviderLogic.PushResult.INSUFFICIENT_PRIORITY);
                        CraftingCpuHelper.reinjectPatternInputs((ICraftingInventory)this.inventory, (KeyCounter[])((KeyCounter[])craftingContainer.value));
                        continue;
                    }
                    if (minAllowedUnits < parallelValue) {
                        IParallelPatternDetails parDetails;
                        if (details instanceof IParallelPatternDetails && (parDetails = (IParallelPatternDetails)details).getParallel() > 1L) {
                            CraftingCpuHelper.reinjectPatternInputs((ICraftingInventory)this.inventory, (KeyCounter[])((KeyCounter[])craftingContainer.value));
                            parDetails.parallel(minAllowedUnits);
                            job.expectedOutputs.reset();
                            craftingContainer.value = OptimizedCraftingCpuLogic.extractPatternInputs(details, this.inventory, job.expectedOutputs);
                            if (craftingContainer.value == null) continue;
                            cappedParallel = minAllowedUnits;
                            allocationLimited = true;
                        } else {
                            this.craftingResults.put((Object)targetOutputKey, (Object)IPatternProviderLogic.PushResult.INSUFFICIENT_PRIORITY);
                            CraftingCpuHelper.reinjectPatternInputs((ICraftingInventory)this.inventory, (KeyCounter[])((KeyCounter[])craftingContainer.value));
                            continue;
                        }
                    }
                }
            }
            for (ICraftingProvider iCraftingProvider : craftingService.getProviders(details)) {
                if (craftingContainer.value == null) break;
                if (iCraftingProvider.isBusy()) continue;
                job.currentConsumed.clear();
                for (KeyCounter kc : (KeyCounter[])craftingContainer.value) {
                    if (kc == null) continue;
                    for (Reference2LongMap.Entry entry : kc) {
                        job.currentConsumed.addTo((Object)((AEKey)entry.getKey()), entry.getLongValue());
                    }
                }
                long finalParallelValue = cappedParallel;
                boolean finalAllocationLimited = allocationLimited;
                double powerNeeded = 0.0;
                KeyCounter[] kcArrPre = (KeyCounter[])craftingContainer.value;
                if (kcArrPre != null) {
                    powerNeeded = CraftingCpuHelper.calculatePatternPower((KeyCounter[])kcArrPre) * (double)finalParallelValue;
                }
                double powerNeededFinal = powerNeeded;
                Supplier<IPatternProviderLogic.PushResult> pushPatternSuccess = () -> {
                    if (powerNeededFinal > 0.0) {
                        energyService.extractAEPower(powerNeededFinal, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    }
                    ++pushedPatterns.value;
                    for (Reference2LongMap.Entry expectedOutput : job.expectedOutputs) {
                        job.waitingFor.insert((AEKey)expectedOutput.getKey(), expectedOutput.getLongValue(), Actionable.MODULATE);
                    }
                    job.purgeDefsLocal.clear();
                    ObjectIterator ceIt = job.currentConsumed.reference2LongEntrySet().fastIterator();
                    while (ceIt.hasNext()) {
                        Reference2LongMap.Entry ce = (Reference2LongMap.Entry)ceIt.next();
                        AEKey key = (AEKey)ce.getKey();
                        Object2LongOpenHashMap map = (Object2LongOpenHashMap)job.allocations.get((Object)key);
                        if (map == null || map.isEmpty()) continue;
                        IPatternDetails matchedKey = null;
                        AEItemKey detailsDef = details.getDefinition();
                        ObjectIterator aeIt = map.object2LongEntrySet().fastIterator();
                        while (aeIt.hasNext()) {
                            Object2LongMap.Entry ae = (Object2LongMap.Entry)aeIt.next();
                            if (!((IPatternDetails)ae.getKey()).getDefinition().equals(detailsDef)) continue;
                            matchedKey = (IPatternDetails)ae.getKey();
                            break;
                        }
                        if (matchedKey == null) continue;
                        long q = map.getLong(matchedKey);
                        long newQ = q - ce.getLongValue();
                        if (newQ <= 0L) {
                            job.purgeDefsLocal.add((Object)detailsDef);
                            continue;
                        }
                        map.put((Object)matchedKey, newQ);
                    }
                    for (AEKey def : job.purgeDefsLocal) {
                        OptimizedCraftingCpuLogic.purgePatternEverywhere(job.allocations, def);
                    }
                    progress.value -= finalParallelValue;
                    if (progress.value <= 0L) {
                        it.remove();
                        return IPatternProviderLogic.PushResult.BREAK;
                    }
                    if (pushedPatterns.value > maxPatterns) {
                        return IPatternProviderLogic.PushResult.BREAK_TASK_LOOP;
                    }
                    if (isParallel || finalAllocationLimited) {
                        return IPatternProviderLogic.PushResult.BREAK;
                    }
                    job.expectedOutputs.reset();
                    craftingContainer.value = OptimizedCraftingCpuLogic.extractPatternInputs(details, this.inventory, job.expectedOutputs);
                    return IPatternProviderLogic.PushResult.SUCCESS;
                };
                if (iCraftingProvider instanceof IPatternProviderLogic) {
                    IPatternProviderLogic logic = (IPatternProviderLogic)iCraftingProvider;
                    IPatternProviderLogic.PushResult result = logic.gtolib$pushPattern(details, craftingContainer, pushPatternSuccess);
                    if (result != IPatternProviderLogic.PushResult.PATTERN_DOES_NOT_EXIST) {
                        this.pendingRequests.put((Object)targetOutputKey, (Object)logic.gto$getPos());
                    }
                    if (!result.success()) {
                        this.craftingResults.put((Object)targetOutputKey, (Object)result);
                        continue;
                    }
                    this.craftingResults.removeAll((Object)targetOutputKey);
                    this.craftingResults.put((Object)targetOutputKey, (Object)result);
                    this.cluster.markDirty();
                    switch (result) {
                        case BREAK: {
                            continue block8;
                        }
                        case BREAK_TASK_LOOP: {
                            break block8;
                        }
                    }
                    continue;
                }
                if (!iCraftingProvider.pushPattern(details, (KeyCounter[])craftingContainer.value)) continue;
                IPatternProviderLogic.PushResult result = pushPatternSuccess.get();
                if (!result.success()) {
                    this.craftingResults.put((Object)targetOutputKey, (Object)result);
                    continue;
                }
                this.craftingResults.removeAll((Object)targetOutputKey);
                this.craftingResults.put((Object)targetOutputKey, (Object)result);
                this.cluster.markDirty();
                if (iCraftingProvider instanceof BlockEntity) {
                    BlockEntity be = (BlockEntity)iCraftingProvider;
                    this.pendingRequests.put((Object)targetOutputKey, (Object)GlobalPos.m_122643_((ResourceKey)be.m_58904_().m_46472_(), (BlockPos)be.m_58899_()));
                } else if (iCraftingProvider instanceof MetaMachine) {
                    MetaMachine mm = (MetaMachine)iCraftingProvider;
                    this.pendingRequests.put((Object)targetOutputKey, (Object)GlobalPos.m_122643_((ResourceKey)mm.getLevel().m_46472_(), (BlockPos)mm.getPos()));
                }
                switch (result) {
                    case BREAK: {
                        continue block8;
                    }
                    case BREAK_TASK_LOOP: {
                        break block8;
                    }
                }
            }
            if (craftingContainer.value == null) continue;
            CraftingCpuHelper.reinjectPatternInputs((ICraftingInventory)this.inventory, (KeyCounter[])((KeyCounter[])craftingContainer.value));
        }
        return pushedPatterns.value;
    }

    public long insert(AEKey what, long amount, Actionable type) {
        if (what == null || this.job == null) {
            return 0L;
        }
        long waitingFor = this.job.waitingFor.extract(what, amount, Actionable.SIMULATE);
        if (waitingFor <= 0L) {
            return 0L;
        }
        if (amount > waitingFor) {
            amount = waitingFor;
        }
        if (type == Actionable.MODULATE) {
            this.job.waitingFor.extract(what, amount, Actionable.MODULATE);
            if (amount == waitingFor) {
                this.pendingRequests.removeAll((Object)what);
            }
            this.job.tt.gtolib$decrementItems(amount, what.getType());
            this.cluster.markDirty();
        }
        long inserted = amount;
        if (what.matches(this.job.finalOutput)) {
            inserted = this.job.link.insert(what, amount, type);
            if (type == Actionable.MODULATE) {
                this.postChange(what);
                this.job.remainingAmount = Math.max(0L, this.job.remainingAmount - amount);
                if (this.job.remainingAmount <= 0L) {
                    this.finishJob(true);
                    this.cluster.updateOutput(null);
                } else {
                    this.cluster.updateOutput(new GenericStack(this.job.finalOutput.what(), this.job.remainingAmount));
                }
            }
        } else if (type == Actionable.MODULATE) {
            this.inventory.insert(what, amount, Actionable.MODULATE);
        }
        return inserted;
    }

    public void cancel() {
        if (this.job == null) {
            return;
        }
        this.cluster.updateOutput(null);
        this.finishJob(false);
    }

    private void storeItems() {
        if (this.inventory.list.isEmpty()) {
            return;
        }
        IGrid g = this.cluster.getGrid();
        if (g == null) {
            return;
        }
        MEStorage storage = g.getStorageService().getInventory();
        for (Reference2LongMap.Entry entry : this.inventory.list) {
            this.postChange((AEKey)entry.getKey());
            long inserted = storage.insert((AEKey)entry.getKey(), entry.getLongValue(), Actionable.MODULATE, this.cluster.getSrc());
            entry.setValue(entry.getLongValue() - inserted);
        }
        this.inventory.list.removeZeros();
        this.cluster.markDirty();
    }

    public boolean hasJob() {
        return this.job != null;
    }

    public GenericStack getFinalJobOutput() {
        return this.job != null ? this.job.finalOutput : null;
    }

    public ElapsedTimeTracker getElapsedTimeTracker() {
        if (this.job != null) {
            return this.job.timeTracker;
        }
        return new ElapsedTimeTracker();
    }

    public void readFromNBT(CompoundTag data) {
        this.inventory.readFromNBT(data.m_128437_("inventory", 10));
        if (data.m_128441_("job")) {
            this.job = new ExecutingCraftingJob(data.m_128469_("job"), this::postChange, this);
            if (this.job.finalOutput == null) {
                this.job = null;
            } else {
                this.cluster.updateOutput(new GenericStack(this.job.finalOutput.what(), this.job.remainingAmount));
                return;
            }
        }
        this.cluster.updateOutput(null);
    }

    public void writeToNBT(CompoundTag data) {
        data.m_128365_("inventory", (Tag)this.inventory.writeToNBT());
        if (this.job != null) {
            data.m_128365_("job", (Tag)this.job.writeToNBT());
        }
    }

    public ICraftingLink getLastLink() {
        if (this.job != null) {
            return this.job.link;
        }
        return null;
    }

    public void addListener(Consumer<AEKey> listener) {
        this.listener = listener;
    }

    public void removeListener(Consumer<AEKey> listener) {
        this.listener = null;
    }

    public long getWaitingFor(AEKey template) {
        if (this.job != null) {
            return this.job.waitingFor.extract(template, Long.MAX_VALUE, Actionable.SIMULATE);
        }
        return 0L;
    }

    public void getAllWaitingFor(Set<AEKey> waitingFor) {
        if (this.job != null) {
            for (Reference2LongMap.Entry entry : this.job.waitingFor.list) {
                waitingFor.add((AEKey)entry.getKey());
            }
        }
    }

    public long getPendingOutputs(AEKey template) {
        long count = 0L;
        if (this.job != null) {
            ObjectIterator it = this.job.tasks.object2ObjectEntrySet().fastIterator();
            while (it.hasNext()) {
                Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)it.next();
                for (GenericStack output : ((IPatternDetails)entry.getKey()).getOutputs()) {
                    if (!template.matches(output)) continue;
                    count += output.amount() * ((LongHolder)entry.getValue()).value;
                }
            }
        }
        return count;
    }

    public Set<GlobalPos> getPendingRequests(AEKey template) {
        return this.pendingRequests.get((Object)template);
    }

    public void getAllItems(KeyCounter out) {
        out.addAll(this.inventory.list);
        if (this.job != null) {
            out.addAll(this.job.waitingFor.list);
            ObjectIterator it = this.job.tasks.object2ObjectEntrySet().fastIterator();
            while (it.hasNext()) {
                Object2ObjectMap.Entry entry = (Object2ObjectMap.Entry)it.next();
                for (GenericStack output : ((IPatternDetails)entry.getKey()).getOutputs()) {
                    out.add(output.what(), output.amount() * ((LongHolder)entry.getValue()).value);
                }
            }
        }
    }

    private void finishJob(boolean success) {
        if (success) {
            this.job.link.markDone();
        } else {
            this.job.link.cancel();
        }
        this.job.waitingFor.clear();
        ObjectIterator it = this.job.tasks.object2ObjectEntrySet().fastIterator();
        while (it.hasNext()) {
            for (GenericStack output : ((IPatternDetails)((Object2ObjectMap.Entry)it.next()).getKey()).getOutputs()) {
                this.postChange(output.what());
            }
        }
        this.notifyJobOwner(this.job, success ? CraftingJobStatusPacket.Status.FINISHED : CraftingJobStatusPacket.Status.CANCELLED);
        this.job = null;
        this.pendingRequests.clear();
        this.craftingResults.clear();
        this.storeItems();
    }

    private void notifyJobOwner(ExecutingCraftingJob job, CraftingJobStatusPacket.Status status) {
        this.lastModifiedOnTick = TickHandler.instance().getCurrentTick();
        Integer playerId = job.playerId;
        if (playerId == null) {
            return;
        }
        MinecraftServer server = this.cluster.getLevel().m_7654_();
        ServerPlayer connectedPlayer = IPlayerRegistry.getConnected((MinecraftServer)server, (int)playerId);
        if (connectedPlayer != null) {
            UUID jobId = job.link.getCraftingID();
            NetworkHandler.instance().sendTo((BasePacket)new CraftingJobStatusPacket(jobId, job.finalOutput.what(), job.finalOutput.amount(), job.remainingAmount, status), connectedPlayer);
        }
    }

    private static KeyCounter[] extractPatternInputs(IPatternDetails details, ListCraftingInventory sourceInv, KeyCounter expectedOutputs) {
        IPatternDetails.IInput[] inputs = details.getInputs();
        KeyCounter[] inputHolder = OptimizedCraftingCpuLogic.getInputHolder((IDetails)details);
        boolean found = true;
        IKeyCounter counter = IKeyCounter.of((KeyCounter)sourceInv.list);
        for (int x = 0; x < inputs.length; ++x) {
            KeyCounter list = inputHolder[x];
            IPatternDetails.IInput input = inputs[x];
            long remainingMultiplier = input.getMultiplier();
            for (GenericStack stack : input.getPossibleInputs()) {
                long amount;
                long extracted;
                AEKey what = stack.what();
                if (!counter.gtolib$contains(what) || (extracted = sourceInv.extract(what, (amount = stack.amount()) * remainingMultiplier, Actionable.MODULATE)) == 0L) continue;
                list.add(what, extracted);
                if ((remainingMultiplier -= extracted / amount) == 0L) break;
            }
            if (remainingMultiplier <= 0L) continue;
            found = false;
            break;
        }
        if (!found) {
            CraftingCpuHelper.reinjectPatternInputs((ICraftingInventory)sourceInv, (KeyCounter[])inputHolder);
            return null;
        }
        for (GenericStack output : details.getOutputs()) {
            expectedOutputs.add(output.what(), output.amount());
        }
        return inputHolder;
    }

    private static long getMaxParallel(long maxParallel, IPatternDetails details, Reference2LongOpenHashMap<AEKey> sourceInv) {
        if (sourceInv == null) {
            return 0L;
        }
        for (IPatternDetails.IInput input : details.getInputs()) {
            long extracted = 0L;
            for (GenericStack stack : input.getPossibleInputs()) {
                extracted += sourceInv.getLong((Object)stack.what()) / stack.amount();
            }
            if ((maxParallel = Math.min(maxParallel, extracted / input.getMultiplier())) >= 1L) continue;
            return 0L;
        }
        return maxParallel;
    }

    private static KeyCounter[] getInputHolder(IDetails details) {
        int length = details.getInputs().length;
        KeyCounter[] inputHolder = new KeyCounter[length];
        KeyCounter[] ih = details.gtolib$getInputHolder();
        for (int x = 0; x < length; ++x) {
            KeyCounter kc = ih[x];
            kc.clear();
            inputHolder[x] = kc;
        }
        return inputHolder;
    }

    @Generated
    public SetMultimap<AEKey, IPatternProviderLogic.PushResult> getCraftingResults() {
        return this.craftingResults;
    }
}

