/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.ae2.gui;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0002J\u0016\u0010\u0019\u001a\u00020\u00072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0002J\u0012\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/gtocore/api/ae2/gui/AdvMathExpParser;", "", "<init>", "()V", "MAX_SHIFT", "", "MAX_EXPONENT", "Ljava/math/BigDecimal;", "MAX_BASE", "PRECISION", "MATH_CONTEXT", "Ljava/math/MathContext;", "UNIT_MAP", "", "", "parse", "expression", "", "format", "Ljava/text/DecimalFormat;", "tokenize", "", "expr", "shuntingYard", "tokens", "evaluate", "rpn", "test", "", "performance", "", "Op", "gtocore"})
@SourceDebugExtension(value={"SMAP\nAdvMathExpParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdvMathExpParser.kt\ncom/gtocore/api/ae2/gui/AdvMathExpParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,451:1\n1#2:452\n480#3:453\n426#3:454\n1252#4,4:455\n*S KotlinDebug\n*F\n+ 1 AdvMathExpParser.kt\ncom/gtocore/api/ae2/gui/AdvMathExpParser\n*L\n24#1:453\n24#1:454\n24#1:455,4\n*E\n"})
public final class AdvMathExpParser {
    @NotNull
    public static final AdvMathExpParser INSTANCE;
    private static final int MAX_SHIFT = 64;
    @NotNull
    private static final BigDecimal MAX_EXPONENT;
    @NotNull
    private static final BigDecimal MAX_BASE;
    private static final int PRECISION = 30;
    @NotNull
    private static final MathContext MATH_CONTEXT;
    @NotNull
    private static final Map<Character, BigDecimal> UNIT_MAP;

    private AdvMathExpParser() {
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final BigDecimal parse(@NotNull String expression, @Nullable DecimalFormat format) throws IllegalArgumentException, ArithmeticException {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (StringsKt.isBlank((CharSequence)expression)) {
            BigDecimal bigDecimal = BigDecimal.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"ZERO");
            return bigDecimal;
        }
        List<Object> tokens = INSTANCE.tokenize(expression, format);
        List<Object> rpn = INSTANCE.shuntingYard(tokens);
        return INSTANCE.evaluate(rpn);
    }

    public static /* synthetic */ BigDecimal parse$default(String string, DecimalFormat decimalFormat, int n, Object object) throws IllegalArgumentException, ArithmeticException {
        if ((n & 2) != 0) {
            decimalFormat = null;
        }
        return AdvMathExpParser.parse(string, decimalFormat);
    }

    private final List<Object> tokenize(String expr, DecimalFormat format) {
        int len = expr.length();
        ArrayList<Object> tokens = new ArrayList<Object>(len / 2);
        int i = 0;
        while (i < len) {
            char c = expr.charAt(i);
            Op symbol = Op.Companion.fromSymbol(c);
            if (CharsKt.isWhitespace((char)c)) {
                ++i;
                continue;
            }
            if (Character.isDigit(c) || c == '.') {
                BigDecimal unitMultiplier;
                BigDecimal valDecimal;
                int start = i;
                while (i < len && (Character.isDigit(expr.charAt(i)) || expr.charAt(i) == '.')) {
                    ++i;
                }
                if (i < len && (expr.charAt(i) == 'e' || expr.charAt(i) == 'E')) {
                    int mark = i++;
                    if (i < len && (expr.charAt(i) == '+' || expr.charAt(i) == '-')) {
                        ++i;
                    }
                    if (i < len && Character.isDigit(expr.charAt(i))) {
                        while (i < len && Character.isDigit(expr.charAt(i))) {
                            ++i;
                        }
                    } else {
                        i = mark;
                    }
                }
                Intrinsics.checkNotNullExpressionValue((Object)expr.substring(start, i), (String)"substring(...)");
                if (format != null) {
                    ParsePosition pp = new ParsePosition(0);
                    Number num = format.parse(numStr, pp);
                    v0 = pp.getIndex() != numStr.length() ? new BigDecimal(numStr) : new BigDecimal(num.toString());
                } else {
                    v0 = valDecimal = new BigDecimal(numStr);
                }
                if (i < len && (unitMultiplier = UNIT_MAP.get(Character.valueOf(expr.charAt(i)))) != null) {
                    BigDecimal bigDecimal = valDecimal.multiply(unitMultiplier);
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"multiply(...)");
                    valDecimal = bigDecimal;
                    ++i;
                }
                tokens.add(valDecimal);
                continue;
            }
            if (symbol == Op.L_PAREN || symbol == Op.R_PAREN) {
                tokens.add((Object)symbol);
                ++i;
                continue;
            }
            if (c == '<' && i + 1 < len && expr.charAt(i + 1) == c) {
                tokens.add((Object)Op.L_SHIFT);
                i += 2;
                continue;
            }
            if (c == '>' && i + 1 < len && expr.charAt(i + 1) == c) {
                tokens.add((Object)Op.R_SHIFT);
                i += 2;
                continue;
            }
            if (symbol == Op.MINUS) {
                boolean bl = tokens.isEmpty() || CollectionsKt.last((List)tokens) instanceof Op && CollectionsKt.last((List)tokens) != Op.R_PAREN ? tokens.add((Object)Op.UNARY_MINUS) : tokens.add((Object)symbol);
                ++i;
                continue;
            }
            if (symbol == Op.PLUS || symbol == Op.MULTIPLY || symbol == Op.DIVIDE || symbol == Op.POWER) {
                tokens.add((Object)symbol);
                ++i;
                continue;
            }
            throw new IllegalArgumentException("Unexpected character at index " + i + ": '" + c + "'");
        }
        return tokens;
    }

    private final List<Object> shuntingYard(List<? extends Object> tokens) {
        ArrayList<Object> output = new ArrayList<Object>();
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        block4: for (Object object : tokens) {
            Object object2 = object;
            if (object2 instanceof BigDecimal) {
                output.add(object);
                continue;
            }
            if (!(object2 instanceof Op)) continue;
            switch (WhenMappings.$EnumSwitchMapping$0[((Op)((Object)object)).ordinal()]) {
                case 1: {
                    stack.push(object);
                    continue block4;
                }
                case 2: {
                    while (!((Collection)stack).isEmpty() && stack.peek() != Op.L_PAREN) {
                        output.add(stack.peek());
                        stack.pop();
                    }
                    if (stack.isEmpty()) {
                        throw new IllegalArgumentException("Mismatched parentheses");
                    }
                    stack.pop();
                    continue block4;
                }
            }
            while (!((Collection)stack).isEmpty() && stack.peek() != Op.L_PAREN) {
                boolean shouldPop;
                Op top = (Op)((Object)stack.peek());
                boolean bl = object == Op.UNARY_MINUS ? top.getPrecedence() > ((Op)((Object)object)).getPrecedence() : (shouldPop = top.getPrecedence() >= ((Op)((Object)object)).getPrecedence());
                if (!shouldPop) break;
                output.add(stack.pop());
            }
            stack.push(object);
        }
        while (!((Collection)stack).isEmpty()) {
            Op top = (Op)((Object)stack.pop());
            if (top == Op.L_PAREN) {
                throw new IllegalArgumentException("Mismatched parentheses");
            }
            output.add((Object)top);
        }
        return output;
    }

    private final BigDecimal evaluate(List<? extends Object> rpn) {
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        for (Object object : rpn) {
            Object object2 = object;
            if (object2 instanceof BigDecimal) {
                stack.push(object);
                continue;
            }
            if (!(object2 instanceof Op)) continue;
            if (object == Op.UNARY_MINUS) {
                if (stack.isEmpty()) {
                    throw new IllegalArgumentException("Invalid expression: missing operand for unary minus");
                }
                BigDecimal b2 = (BigDecimal)stack.pop();
                stack.push(b2.negate(MATH_CONTEXT));
                continue;
            }
            if (stack.size() < 2) {
                throw new IllegalArgumentException("Invalid expression");
            }
            BigDecimal b2 = (BigDecimal)stack.pop();
            BigDecimal a2 = (BigDecimal)stack.pop();
            BigDecimal res = switch (WhenMappings.$EnumSwitchMapping$0[((Op)((Object)object)).ordinal()]) {
                case 3 -> a2.add(b2, MATH_CONTEXT);
                case 4 -> a2.subtract(b2, MATH_CONTEXT);
                case 5 -> a2.multiply(b2, MATH_CONTEXT);
                case 6 -> a2.divide(b2, MATH_CONTEXT);
                case 7 -> {
                    b2 = b2.stripTrailingZeros();
                    if (b2.compareTo(MAX_EXPONENT) > 0) {
                        throw new ArithmeticException("Exponent too large");
                    }
                    if (a2.compareTo(MAX_BASE) > 0) {
                        throw new ArithmeticException("Base too large");
                    }
                    if (b2.scale() > 0) {
                        throw new ArithmeticException("Non-integer exponent not supported");
                    }
                    yield a2.pow(b2.intValueExact(), MATH_CONTEXT);
                }
                case 8 -> {
                    BigInteger bi = a2.toBigInteger();
                    int shift = b2.intValue();
                    if (shift > 64) {
                        throw new ArithmeticException("Shift amount too large");
                    }
                    yield new BigDecimal(bi.shiftLeft(shift));
                }
                case 9 -> {
                    BigInteger bi = a2.toBigInteger();
                    int shift = b2.intValue();
                    if (shift > 64) {
                        throw new ArithmeticException("Shift amount too large");
                    }
                    yield new BigDecimal(bi.shiftRight(shift));
                }
                default -> throw new IllegalArgumentException("Unknown operator: " + object);
            };
            stack.push(res);
        }
        if (stack.size() != 1) {
            throw new IllegalArgumentException("Invalid expression result");
        }
        Object e = stack.pop();
        Intrinsics.checkNotNullExpressionValue(e, (String)"pop(...)");
        return (BigDecimal)e;
    }

    @JvmOverloads
    public final void test(boolean performance) {
        String[] expected;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"0", (Object)new BigDecimal("0")), TuplesKt.to((Object)"1 + 1", (Object)new BigDecimal("2")), TuplesKt.to((Object)"10 - 4", (Object)new BigDecimal("6")), TuplesKt.to((Object)"2 * 3", (Object)new BigDecimal("6")), TuplesKt.to((Object)"10 / 2", (Object)new BigDecimal("5")), TuplesKt.to((Object)"10 / 4", (Object)new BigDecimal("2.5")), TuplesKt.to((Object)"0.1 + 0.2", (Object)new BigDecimal("0.3")), TuplesKt.to((Object)"-1 + 5", (Object)new BigDecimal("4")), TuplesKt.to((Object)"-3 * 2", (Object)new BigDecimal("-6")), TuplesKt.to((Object)"5 + -2", (Object)new BigDecimal("3")), TuplesKt.to((Object)"5 - -2", (Object)new BigDecimal("7")), TuplesKt.to((Object)"1 + 2 * 3", (Object)new BigDecimal("7")), TuplesKt.to((Object)"(1 + 2) * 3", (Object)new BigDecimal("9")), TuplesKt.to((Object)"10 - 2 + 3", (Object)new BigDecimal("11")), TuplesKt.to((Object)"100 / 10 * 2", (Object)new BigDecimal("20")), TuplesKt.to((Object)"2 + 3 << 2", (Object)new BigDecimal("20")), TuplesKt.to((Object)"1 << 2 + 3", (Object)new BigDecimal("32")), TuplesKt.to((Object)"4 * 2 ^ 3", (Object)new BigDecimal("32")), TuplesKt.to((Object)"2 ^ 3", (Object)new BigDecimal("8")), TuplesKt.to((Object)"2 ^ 3 ^ 2", (Object)new BigDecimal("64")), TuplesKt.to((Object)"2 ^ (3 ^ 2)", (Object)new BigDecimal("512")), TuplesKt.to((Object)"1k", (Object)new BigDecimal("1000")), TuplesKt.to((Object)"1.5k", (Object)new BigDecimal("1500.0")), TuplesKt.to((Object)"1m", (Object)new BigDecimal("1000000")), TuplesKt.to((Object)"0.5g", (Object)new BigDecimal("500000000")), TuplesKt.to((Object)"2t", (Object)new BigDecimal("2000000000000")), TuplesKt.to((Object)"100k", (Object)new BigDecimal("100000")), TuplesKt.to((Object)"1m + 1k", (Object)new BigDecimal("1001000")), TuplesKt.to((Object)"1e3", (Object)new BigDecimal("1000")), TuplesKt.to((Object)"1.5E2", (Object)new BigDecimal("150.0")), TuplesKt.to((Object)"1e-2", (Object)new BigDecimal("0.01")), TuplesKt.to((Object)"1.2e2k", (Object)new BigDecimal("120000.0")), TuplesKt.to((Object)"5e-1k", (Object)new BigDecimal("500.0")), TuplesKt.to((Object)"1 << 10", (Object)new BigDecimal("1024")), TuplesKt.to((Object)"8 >> 2", (Object)new BigDecimal("2")), TuplesKt.to((Object)"1k << 1", (Object)new BigDecimal("2000")), TuplesKt.to((Object)"1.5 << 1", (Object)new BigDecimal("2")), TuplesKt.to((Object)"3.9 >> 1", (Object)new BigDecimal("1")), TuplesKt.to((Object)"255 >> 0", (Object)new BigDecimal("255")), TuplesKt.to((Object)"1.5k * 2 + 500", (Object)new BigDecimal("3500.0")), TuplesKt.to((Object)"(1k + 2k) / 3", (Object)new BigDecimal("1000")), TuplesKt.to((Object)"1m / 1k", (Object)new BigDecimal("1000")), TuplesKt.to((Object)"1g / 1m", (Object)new BigDecimal("1000")), TuplesKt.to((Object)"1 << 4 + 1", (Object)new BigDecimal("32")), TuplesKt.to((Object)"3 * 5m", (Object)new BigDecimal("15000000")), TuplesKt.to((Object)"100 * (2 + 1.2e2k / 60k)", (Object)new BigDecimal("400")), TuplesKt.to((Object)"100 * (-2) + 50k / (2 + 3)", (Object)new BigDecimal("9800"))};
        Map testCases = MapsKt.mapOf((Pair[])pairArray);
        Object[] objectArray = new String[]{"1 + 2|3", "3 *4 |12", "1 + 2 * 3 |7", "1 - 6|-5", "23.4 + 0.6|24", "1 - -4|5", "1 + 4*3*2|25", "1/0|failed", "1/(1 - 1)|failed", "3 + 2 * 4 - 1 /2|10.5", "1 + (2 * (2 * (1 + 1)))|9", "arkazkdhz|failed", "1 + 2 3 7 - 1|failed", "2 + + 2|failed", "-1 -1|-2", "- (1 + 1)|-2", "2 * -1|-2", "2 -2|0", "-  1|-1", "-1|-1", "- - - - - 5|-5", "-(-(-(-2)))|2", "1 - -1|2", "1 + -(2|failed", "NaN|failed", "1 / 0|failed", "64/4|16", "-2^2|-4", "2^2*3|12", "2^3.1|failed", "2^31|failed", "2^3^4|4096", "2^30^30^30|failed", "2^-1|failed"};
        List ae2cases = CollectionsKt.listOf((Object[])objectArray);
        boolean allPass = true;
        for (Map.Entry entry : testCases.entrySet()) {
            Object object;
            Object $this$test_u24lambda_u242;
            String expr = (String)entry.getKey();
            expected = (String[])entry.getValue();
            Object object2 = this;
            try {
                $this$test_u24lambda_u242 = object2;
                boolean bl = false;
                $this$test_u24lambda_u242 = Result.constructor-impl((Object)AdvMathExpParser.parse(expr, new DecimalFormat("#.##########")));
            }
            catch (Throwable bl) {
                $this$test_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = $this$test_u24lambda_u242;
            if (Result.exceptionOrNull-impl((Object)object2) == null) {
                object = object2;
            } else {
                Throwable it;
                boolean bl = false;
                System.out.println((Object)("\u001b[31mERROR\u001b[0m: " + expr + " -> Exception: " + it.getMessage()));
                object = null;
            }
            BigDecimal result = (BigDecimal)object;
            boolean pass = result != null && result.compareTo((BigDecimal)expected) == 0;
            boolean bl = allPass = allPass && pass;
            if (pass) {
                System.out.println((Object)("\u001b[32mPASS\u001b[0m: " + expr + " = " + result));
                continue;
            }
            System.out.println((Object)("\u001b[31mFAIL\u001b[0m: " + expr + " -> Expected: " + (BigDecimal)expected + ", Got: " + result));
        }
        for (String string : ae2cases) {
            Object object;
            Object $this$test_u24lambda_u244;
            expected = new String[]{"|"};
            List parts = StringsKt.split$default((CharSequence)string, (String[])expected, (boolean)false, (int)0, (int)6, null);
            String expr = (String)parts.get(0);
            String expectedStr = (String)parts.get(1);
            BigDecimal expected2 = Intrinsics.areEqual((Object)expectedStr, (Object)"failed") ? null : new BigDecimal(expectedStr);
            Object bl = this;
            try {
                $this$test_u24lambda_u244 = bl;
                boolean bl2 = false;
                $this$test_u24lambda_u244 = Result.constructor-impl((Object)AdvMathExpParser.parse(expr, new DecimalFormat("#.##########")));
            }
            catch (Throwable bl2) {
                $this$test_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            bl = $this$test_u24lambda_u244;
            if (Result.exceptionOrNull-impl((Object)bl) == null) {
                object = bl;
            } else {
                boolean bl3 = false;
                object = null;
            }
            BigDecimal result = (BigDecimal)object;
            boolean pass = expected2 == null ? result == null : result != null && result.compareTo(expected2) == 0;
            boolean bl4 = allPass = allPass && pass;
            if (pass) {
                System.out.println((Object)("\u001b[32mPASS\u001b[0m: " + expr + " = " + result));
                continue;
            }
            System.out.println((Object)("\u001b[31mFAIL\u001b[0m: " + expr + " -> Expected: " + expected2 + ", Got: " + result));
        }
        if (allPass) {
            System.out.println((Object)"\u001b[32mAll test cases passed!\u001b[0m");
        } else {
            System.out.println((Object)"\u001b[31mSome test cases failed.\u001b[0m");
        }
        if (!performance) {
            return;
        }
        String expression = "1k * 2 + 500 - (300 / 2) + 4 ^ 3 - (1 << 5) + 1.5m / 3";
        int iterations = 1000000;
        long startTime = System.currentTimeMillis();
        DecimalFormat format = new DecimalFormat("#.##########");
        int expected2 = 0;
        while (expected2 < iterations) {
            int it = expected2++;
            boolean bl = false;
            AdvMathExpParser.parse(expression, format);
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        System.out.println((Object)("Evaluated expression " + iterations + " times in " + duration + " ms"));
        System.out.println((Object)("Average time per evaluation: " + duration * 1000000L / (long)iterations + " ns"));
    }

    public static /* synthetic */ void test$default(AdvMathExpParser advMathExpParser, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        advMathExpParser.test(bl);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final BigDecimal parse(@NotNull String expression) throws IllegalArgumentException, ArithmeticException {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return AdvMathExpParser.parse$default(expression, null, 2, null);
    }

    @JvmOverloads
    public final void test() {
        AdvMathExpParser.test$default(this, false, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$mapKeysTo$iv$iv;
        INSTANCE = new AdvMathExpParser();
        BigDecimal bigDecimal = BigDecimal.valueOf(30);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        MAX_EXPONENT = bigDecimal;
        MAX_BASE = new BigDecimal(String.valueOf(1.0E9));
        MATH_CONTEXT = new MathContext(30, RoundingMode.FLOOR);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('k'), (Object)new BigDecimal("1E3")), TuplesKt.to((Object)Character.valueOf('m'), (Object)new BigDecimal("1E6")), TuplesKt.to((Object)Character.valueOf('g'), (Object)new BigDecimal("1E9")), TuplesKt.to((Object)Character.valueOf('t'), (Object)new BigDecimal("1E12")), TuplesKt.to((Object)Character.valueOf('p'), (Object)new BigDecimal("1E15"))};
        Map map = MapsKt.mapOf((Pair[])pairArray);
        boolean bl = false;
        Map $this$mapKeys$iv = map;
        boolean $i$f$mapKeys = false;
        Map map2 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl2 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Character c = Character.valueOf(Character.toUpperCase(((Character)it.getKey()).charValue()));
            Map map4 = map3;
            boolean bl3 = false;
            entry = it$iv$iv.getValue();
            map4.put(c, entry);
        }
        Map upperMap = destination$iv$iv;
        UNIT_MAP = MapsKt.plus((Map)map, (Map)upperMap);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0082\u0081\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0016B\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015\u00a8\u0006\u0017"}, d2={"Lcom/gtocore/api/ae2/gui/AdvMathExpParser$Op;", "", "precedence", "", "symbol", "", "<init>", "(Ljava/lang/String;IILjava/lang/String;)V", "getPrecedence", "()I", "getSymbol", "()Ljava/lang/String;", "PLUS", "MINUS", "MULTIPLY", "DIVIDE", "POWER", "L_SHIFT", "R_SHIFT", "UNARY_MINUS", "L_PAREN", "R_PAREN", "Companion", "gtocore"})
    @SourceDebugExtension(value={"SMAP\nAdvMathExpParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdvMathExpParser.kt\ncom/gtocore/api/ae2/gui/AdvMathExpParser$Op\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,451:1\n1208#2,2:452\n1236#2,4:454\n1617#2,9:458\n1869#2:467\n1870#2:469\n1626#2:470\n1#3:468\n*S KotlinDebug\n*F\n+ 1 AdvMathExpParser.kt\ncom/gtocore/api/ae2/gui/AdvMathExpParser$Op\n*L\n42#1:452,2\n42#1:454,4\n44#1:458,9\n44#1:467\n44#1:469\n44#1:470\n44#1:468\n*E\n"})
    private static final class Op
    extends Enum<Op> {
        @NotNull
        public static final Companion Companion;
        private final int precedence;
        @Nullable
        private final String symbol;
        @NotNull
        private static final Map<String, Op> map;
        @NotNull
        private static final Map<Character, Op> charMap;
        public static final /* enum */ Op PLUS;
        public static final /* enum */ Op MINUS;
        public static final /* enum */ Op MULTIPLY;
        public static final /* enum */ Op DIVIDE;
        public static final /* enum */ Op POWER;
        public static final /* enum */ Op L_SHIFT;
        public static final /* enum */ Op R_SHIFT;
        public static final /* enum */ Op UNARY_MINUS;
        public static final /* enum */ Op L_PAREN;
        public static final /* enum */ Op R_PAREN;
        private static final /* synthetic */ Op[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Op(int precedence, String symbol) {
            this.precedence = precedence;
            this.symbol = symbol;
        }

        public final int getPrecedence() {
            return this.precedence;
        }

        @Nullable
        public final String getSymbol() {
            return this.symbol;
        }

        public static Op[] values() {
            return (Op[])$VALUES.clone();
        }

        public static Op valueOf(String value) {
            return Enum.valueOf(Op.class, value);
        }

        @NotNull
        public static EnumEntries<Op> getEntries() {
            return $ENTRIES;
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$mapNotNullTo$iv$iv;
            void $this$associateByTo$iv$iv;
            PLUS = new Op(2, "+");
            MINUS = new Op(2, "-");
            MULTIPLY = new Op(3, "*");
            DIVIDE = new Op(3, "/");
            POWER = new Op(5, "^");
            L_SHIFT = new Op(1, "<<");
            R_SHIFT = new Op(1, ">>");
            UNARY_MINUS = new Op(4, null);
            L_PAREN = new Op(0, "(");
            R_PAREN = new Op(0, ")");
            $VALUES = opArray = new Op[]{Op.PLUS, Op.MINUS, Op.MULTIPLY, Op.DIVIDE, Op.POWER, Op.L_SHIFT, Op.R_SHIFT, Op.UNARY_MINUS, Op.L_PAREN, Op.R_PAREN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Iterable $this$associateBy$iv = (Iterable)Op.getEntries();
            boolean $i$f$associateBy = false;
            int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void p0;
                Op op = (Op)((Object)element$iv$iv);
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(p0.symbol, element$iv$iv);
            }
            map = destination$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)Op.getEntries();
            boolean $i$f$mapNotNull = false;
            Iterable capacity$iv22 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Pair it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Op it = (Op)((Object)element$iv$iv);
                boolean bl2 = false;
                if ((it.symbol != null && it.symbol.length() == 1 ? TuplesKt.to((Object)Character.valueOf(it.symbol.charAt(0)), (Object)((Object)it)) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            charMap = MapsKt.toMap((Iterable)((List)iterable));
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0006J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\tR\u001c\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/gtocore/api/ae2/gui/AdvMathExpParser$Op$Companion;", "", "<init>", "()V", "map", "", "", "Lcom/gtocore/api/ae2/gui/AdvMathExpParser$Op;", "charMap", "", "fromSymbol", "symbol", "c", "gtocore"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Op fromSymbol(@NotNull String symbol) {
                Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
                return (Op)((Object)map.get(symbol));
            }

            @Nullable
            public final Op fromSymbol(char c) {
                return (Op)((Object)charMap.get(Character.valueOf(c)));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Op.values().length];
            try {
                nArray[Op.L_PAREN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Op.R_PAREN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Op.PLUS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Op.MINUS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Op.MULTIPLY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Op.DIVIDE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Op.POWER.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Op.L_SHIFT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Op.R_SHIFT.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

