/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.data;

import appeng.api.stacks.AEItemKey;
import com.gtocore.common.data.GTOItems;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public enum Algae {
    BlueAlge(170, 180, 10, (Supplier<Item>)GTOItems.BLUE_ALGAE),
    BrownAlge(10, 140, 240, (Supplier<Item>)GTOItems.BROWN_ALGAE),
    GoldAlge(80, 70, 190, (Supplier<Item>)GTOItems.GOLD_ALGAE),
    GreenAlge(180, 40, 220, (Supplier<Item>)GTOItems.GREEN_ALGAE),
    RedAlge(40, 200, 230, (Supplier<Item>)GTOItems.RED_ALGAE);

    private static final Algae[] VALUES;
    public final int redAbsorption;
    public final int greenAbsorption;
    public final int blueAbsorption;
    private Supplier<Item> itemSupplier;
    private Item item;

    public static void init() {
        for (Algae algae : VALUES) {
            algae.item = algae.itemSupplier.get();
            algae.itemSupplier = null;
        }
    }

    private Algae(int redAbsorption, int greenAbsorption, int blueAbsorption, Supplier<Item> itemSupplier) {
        this.redAbsorption = redAbsorption;
        this.greenAbsorption = greenAbsorption;
        this.blueAbsorption = blueAbsorption;
        this.itemSupplier = itemSupplier;
    }

    public AEItemKey aeKey() {
        return AEItemKey.of((ItemLike)this.item);
    }

    public static boolean isAlgae(AEItemKey key) {
        Item item = key.getItem();
        for (Algae algae : VALUES) {
            if (algae.item != item) continue;
            return true;
        }
        return false;
    }

    public int getColor() {
        return 255 - this.redAbsorption << 16 | 255 - this.greenAbsorption << 8 | 255 - this.blueAbsorption;
    }

    public Component getDisplayName() {
        return Component.m_237119_().m_7220_(this.aeKey().getDisplayName()).m_130948_(Style.f_131099_.m_178520_(this.getColor()));
    }

    static {
        VALUES = Algae.values();
    }
}

