/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.gui.helper;

import com.gtocore.api.gui.helper.LineChartBuilder;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0004\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u00bc\u0001\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u00062\b\b\u0002\u0010\u0010\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u00062\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00062\b\b\u0002\u0010\u0017\u001a\u00020\u00152\b\b\u0002\u0010\u0018\u001a\u00020\u00062\b\b\u0002\u0010\u0019\u001a\u00020\u00132\b\b\u0002\u0010\u001a\u001a\u00020\u00152\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001cJ:\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0018\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00050\n2\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0006H\u0002J:\u0010%\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0018\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00050\n2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0006H\u0002J:\u0010\u0017\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0018\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00050\n2\u0006\u0010'\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0006H\u0002J\u001e\u0010(\u001a\u00020)2\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a8\u0006*"}, d2={"Lcom/gtocore/api/gui/helper/LineChartHelper;", "", "<init>", "()V", "drawLineChart", "Lkotlin/Pair;", "", "graphics", "Lnet/minecraft/client/gui/GuiGraphics;", "data", "", "", "totalWidth", "totalHeight", "borderWidth", "backgroundColor", "borderColor", "lineColor", "lineWidth", "", "drawAreaFill", "", "areaFillColor", "drawDataPoints", "dataPointColor", "dataPointRadius", "autoReboundY", "minYBound", "", "maxYBound", "drawArea", "", "matrix", "Lorg/joml/Matrix4f;", "points", "bottomY", "color", "drawThickLines", "width", "radius", "builder", "Lcom/gtocore/api/gui/helper/LineChartBuilder;", "gtocore"})
@SourceDebugExtension(value={"SMAP\nLineChartHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineChartHelper.kt\ncom/gtocore/api/gui/helper/LineChartHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n1563#2:231\n1634#2,3:232\n1563#2:235\n1634#2,3:236\n1563#2:239\n1634#2,3:240\n1869#2,2:243\n*S KotlinDebug\n*F\n+ 1 LineChartHelper.kt\ncom/gtocore/api/gui/helper/LineChartHelper\n*L\n58#1:231\n58#1:232,3\n65#1:235\n65#1:236,3\n100#1:239\n100#1:240,3\n201#1:243,2\n*E\n"})
public final class LineChartHelper {
    @NotNull
    public static final LineChartHelper INSTANCE = new LineChartHelper();

    private LineChartHelper() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Integer, Integer> drawLineChart(@NotNull GuiGraphics graphics, @Nullable List<? extends Number> data, int totalWidth, int totalHeight, int borderWidth, int backgroundColor, int borderColor, int lineColor, float lineWidth, boolean drawAreaFill, int areaFillColor, boolean drawDataPoints, int dataPointColor, float dataPointRadius, boolean autoReboundY, double minYBound, double maxYBound) {
        void $this$mapTo$iv$iv;
        Object it;
        Collection collection;
        Collection collection2;
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        int innerWidth = totalWidth - borderWidth * 2;
        int innerHeight = totalHeight - borderWidth * 2;
        if (borderWidth > 0) {
            DrawerHelper.drawBorder((GuiGraphics)graphics, (int)0, (int)0, (int)totalWidth, (int)totalHeight, (int)borderColor, (int)borderWidth);
        }
        if (innerWidth > 0 && innerHeight > 0) {
            DrawerHelper.drawSolidRect((GuiGraphics)graphics, (int)borderWidth, (int)borderWidth, (int)innerWidth, (int)innerHeight, (int)backgroundColor);
        }
        if ((collection2 = (Collection)data) == null || collection2.isEmpty() || innerWidth <= 0 || innerHeight <= 0) {
            return TuplesKt.to((Object)totalWidth, (Object)totalHeight);
        }
        List doubleData = null;
        Ref.DoubleRef minValue = new Ref.DoubleRef();
        minValue.element = Double.MAX_VALUE;
        double maxValue = 0.0;
        maxValue = Double.MIN_VALUE;
        if (autoReboundY) {
            $this$map$iv = data;
            $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Number number = (Number)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                double d = ((Number)it).doubleValue();
                if (d < minValue.element) {
                    minValue.element = d;
                }
                if (d > maxValue) {
                    maxValue = d;
                }
                collection.add(d);
            }
            doubleData = (List)destination$iv$iv;
        } else {
            $this$map$iv = data;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Number)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Number)it).doubleValue());
            }
            doubleData = (List)destination$iv$iv;
            if (!Double.isNaN(minYBound)) {
                v0 = minYBound;
            } else {
                Double d = CollectionsKt.minOrNull((Iterable)doubleData);
                v0 = minValue.element = d != null ? d : 0.0;
            }
            if (!Double.isNaN(maxYBound)) {
                v2 = maxYBound;
            } else {
                Double d = CollectionsKt.maxOrNull((Iterable)doubleData);
                v2 = maxValue = d != null ? d : 0.0;
            }
        }
        if (data.size() == 1) {
            if (drawDataPoints) {
                float pointX = (float)borderWidth + (float)innerWidth / 2.0f;
                float pointY = (float)borderWidth + (float)innerHeight / 2.0f;
                DrawerHelper.drawSolidRect((GuiGraphics)graphics, (int)((int)(pointX - dataPointRadius)), (int)((int)(pointY - dataPointRadius)), (int)((int)(dataPointRadius * (float)2)), (int)((int)(dataPointRadius * (float)2)), (int)dataPointColor);
            }
            return TuplesKt.to((Object)totalWidth, (Object)totalHeight);
        }
        double dataRange = maxValue == minValue.element ? 0.0 : maxValue - minValue.element;
        Function1 mapX = arg_0 -> LineChartHelper.drawLineChart$lambda$2(borderWidth, data, innerWidth, arg_0);
        Function1 mapY = arg_0 -> LineChartHelper.drawLineChart$lambda$3(dataRange, borderWidth, innerHeight, minValue, arg_0);
        Iterable $this$map$iv = (Iterable)CollectionsKt.getIndices((Collection)doubleData);
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void i;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair(mapX.invoke((Object)((int)i)), mapY.invoke(doubleData.get((int)i))));
        }
        List points = (List)destination$iv$iv;
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        if (drawAreaFill) {
            Intrinsics.checkNotNull((Object)matrix);
            this.drawArea(matrix, points, (float)borderWidth + (float)innerHeight, areaFillColor);
        }
        Intrinsics.checkNotNull((Object)matrix);
        this.drawThickLines(matrix, points, lineWidth, lineColor);
        if (drawDataPoints) {
            this.drawDataPoints(matrix, points, dataPointRadius, dataPointColor);
        }
        return TuplesKt.to((Object)totalWidth, (Object)totalHeight);
    }

    public static /* synthetic */ Pair drawLineChart$default(LineChartHelper lineChartHelper, GuiGraphics guiGraphics, List list, int n, int n2, int n3, int n4, int n5, int n6, float f, boolean bl, int n7, boolean bl2, int n8, float f2, boolean bl3, double d, double d2, int n9, Object object) {
        if ((n9 & 0x10) != 0) {
            n3 = 1;
        }
        if ((n9 & 0x20) != 0) {
            n4 = -12566464;
        }
        if ((n9 & 0x40) != 0) {
            n5 = -16777216;
        }
        if ((n9 & 0x80) != 0) {
            n6 = -13710223;
        }
        if ((n9 & 0x100) != 0) {
            f = 1.5f;
        }
        if ((n9 & 0x200) != 0) {
            bl = false;
        }
        if ((n9 & 0x400) != 0) {
            n7 = 1076808817;
        }
        if ((n9 & 0x800) != 0) {
            bl2 = true;
        }
        if ((n9 & 0x1000) != 0) {
            n8 = -1;
        }
        if ((n9 & 0x2000) != 0) {
            f2 = 2.0f;
        }
        if ((n9 & 0x4000) != 0) {
            bl3 = true;
        }
        if ((n9 & 0x8000) != 0) {
            d = Double.NaN;
        }
        if ((n9 & 0x10000) != 0) {
            d2 = Double.NaN;
        }
        return lineChartHelper.drawLineChart(guiGraphics, list, n, n2, n3, n4, n5, n6, f, bl, n7, bl2, n8, f2, bl3, d, d2);
    }

    private final void drawArea(Matrix4f matrix, List<Pair<Float, Float>> points, float bottomY, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(color & 0xFF) / 255.0f;
        float a2 = (float)(color >> 24 & 0xFF) / 255.0f;
        Tesselator tessellate = Tesselator.m_85913_();
        BufferBuilder buffer = tessellate.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        for (Pair<Float, Float> point : points) {
            buffer.m_252986_(matrix, ((Number)point.getFirst()).floatValue(), ((Number)point.getSecond()).floatValue(), 0.0f).m_85950_(r, g, b2, a2).m_5752_();
            buffer.m_252986_(matrix, ((Number)point.getFirst()).floatValue(), bottomY, 0.0f).m_85950_(r, g, b2, a2).m_5752_();
        }
        tessellate.m_85914_();
        RenderSystem.disableBlend();
    }

    private final void drawThickLines(Matrix4f matrix, List<Pair<Float, Float>> points, float width, int color) {
        if (points.size() < 2) {
            return;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(color & 0xFF) / 255.0f;
        float a2 = (float)(color >> 24 & 0xFF) / 255.0f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        int n = points.size() - 1;
        for (int i = 0; i < n; ++i) {
            float y2;
            float dy;
            Pair<Float, Float> pair = points.get(i);
            float x1 = ((Number)pair.component1()).floatValue();
            float y1 = ((Number)pair.component2()).floatValue();
            Pair<Float, Float> pair2 = points.get(i + 1);
            float x2 = ((Number)pair2.component1()).floatValue();
            float dx = x2 - x1;
            float length = (float)Math.sqrt(dx * dx + (dy = (y2 = ((Number)pair2.component2()).floatValue()) - y1) * dy);
            if (length == 0.0f) continue;
            float halfWidth = width / 2.0f;
            float offsetX = -dy / length * halfWidth;
            float offsetY = dx / length * halfWidth;
            buffer.m_252986_(matrix, x1 - offsetX, y1 - offsetY, 0.0f).m_85950_(r, g, b2, a2).m_5752_();
            buffer.m_252986_(matrix, x1 + offsetX, y1 + offsetY, 0.0f).m_85950_(r, g, b2, a2).m_5752_();
            buffer.m_252986_(matrix, x2 + offsetX, y2 + offsetY, 0.0f).m_85950_(r, g, b2, a2).m_5752_();
            buffer.m_252986_(matrix, x2 - offsetX, y2 - offsetY, 0.0f).m_85950_(r, g, b2, a2).m_5752_();
        }
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    private final void drawDataPoints(Matrix4f matrix, List<Pair<Float, Float>> points, float radius, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(color & 0xFF) / 255.0f;
        float a2 = (float)(color >> 24 & 0xFF) / 255.0f;
        float halfRadius = radius / 2.0f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Iterable $this$forEach$iv = points;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            float x = ((Number)pair.component1()).floatValue();
            float y = ((Number)pair.component2()).floatValue();
            buffer.m_252986_(matrix, x - halfRadius, y - halfRadius, 0.0f).m_85950_(r, g, b2, a2).m_5752_();
            buffer.m_252986_(matrix, x + halfRadius, y - halfRadius, 0.0f).m_85950_(r, g, b2, a2).m_5752_();
            buffer.m_252986_(matrix, x + halfRadius, y + halfRadius, 0.0f).m_85950_(r, g, b2, a2).m_5752_();
            buffer.m_252986_(matrix, x - halfRadius, y + halfRadius, 0.0f).m_85950_(r, g, b2, a2).m_5752_();
        }
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    @NotNull
    public final LineChartBuilder builder(@NotNull GuiGraphics graphics, @Nullable List<? extends Number> data) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        return new LineChartBuilder(graphics, data);
    }

    private static final float drawLineChart$lambda$2(int $borderWidth, List $data, int $innerWidth, int index) {
        return (float)$borderWidth + (float)index / (float)($data.size() - 1) * (float)$innerWidth;
    }

    private static final float drawLineChart$lambda$3(double $dataRange, int $borderWidth, int $innerHeight, Ref.DoubleRef $minValue, double value) {
        return $dataRange == 0.0 ? (float)$borderWidth + (float)$innerHeight / 2.0f : (float)((double)($borderWidth + $innerHeight) - (value - $minValue.element) / $dataRange * (double)$innerHeight);
    }
}

