/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.machine.part;

import com.fast.fastcollection.O2OOpenCacheHashMap;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gtocore.common.data.GTOMachines;
import com.gtolib.api.lang.CNEN;
import java.util.Map;
import net.minecraft.world.level.block.Block;

public final class GTOPartAbility
extends PartAbility {
    public static final Map<String, CNEN> LANG = GTCEu.isDataGen() ? new O2OOpenCacheHashMap() : null;
    public static final PartAbility NEUTRON_ACCELERATOR = new GTOPartAbility("neutron_accelerator", "\u4e2d\u5b50\u52a0\u901f\u5668", "Neutron Accelerator");
    public static final PartAbility THREAD_HATCH = new GTOPartAbility("thread_hatch", "\u7ebf\u7a0b\u4ed3", "Thread Hatch");
    public static final PartAbility OVERCLOCK_HATCH = new GTOPartAbility("overclock_hatch", "\u8d85\u9891\u4ed3", "Overclock Hatch");
    public static final PartAbility ACCELERATE_HATCH = new GTOPartAbility("accelerate_hatch", "\u52a0\u901f\u4ed3", "Accelerate Hatch");
    public static final PartAbility DRONE_HATCH = new GTOPartAbility("drone_hatch", "\u65e0\u4eba\u673a\u4ed3", "Drone Hatch");
    public static final PartAbility PASSTHROUGH_HATCH_MANA = new GTOPartAbility("passthrogh_hatch_mana", "\u9b54\u529b\u901a\u884c\u4ed3", "Mana Passthrough Hatch");
    public static final PartAbility INPUT_MANA = new GTOPartAbility("input_mana", "\u9b54\u529b\u8f93\u5165\u4ed3", "Input Mana");
    public static final PartAbility OUTPUT_MANA = new GTOPartAbility("output_mana", "\u9b54\u529b\u8f93\u51fa\u4ed3", "Output Mana");
    public static final PartAbility EXTRACT_MANA = new GTOPartAbility("extract_mana", "\u9b54\u529b\u62bd\u53d6\u4ed3", "Extract Mana");
    public static final PartAbility COMPUTING_COMPONENT = new GTOPartAbility("computing_component", "\u8ba1\u7b97\u7ec4\u4ef6", "Computing Component Hatch");
    public static final PartAbility CATALYST_HATCH = new GTOPartAbility("catalyst_hatch", "\u50ac\u5316\u5242\u4ed3", "Catalyst Hatch");
    public static final PartAbility ITEMS_INPUT = new GTOPartAbility("items_input", "\u7269\u54c1\u8f93\u5165\u4ed3", "Items Input");
    public static final PartAbility ITEMS_OUTPUT = new GTOPartAbility("items_output", "\u7269\u54c1\u8f93\u51fa\u4ed3", "Items Output");
    public static final PartAbility STEAM_IMPORT_FLUIDS = new GTOPartAbility("steam_import_fluids", "\u84b8\u6c7d\u6d41\u4f53\u8f93\u5165\u4ed3", "Steam Import Fluids");
    public static final PartAbility STEAM_EXPORT_FLUIDS = new GTOPartAbility("steam_export_fluids", "\u84b8\u6c7d\u6d41\u4f53\u8f93\u51fa\u4ed3", "Steam Export Fluids");

    public GTOPartAbility(String name, String cn, String en) {
        super(name);
        if (LANG != null) {
            LANG.put("gtocore.part_ability." + name, new CNEN(cn, en));
        }
    }

    public static void init() {
        PartAbility.STEAM_IMPORT_ITEMS.register(2, (Block)GTMachines.ITEM_IMPORT_BUS[0].get());
        PartAbility.STEAM_EXPORT_ITEMS.register(2, (Block)GTMachines.ITEM_EXPORT_BUS[0].get());
        STEAM_IMPORT_FLUIDS.register(2, (Block)GTOMachines.INFINITE_INTAKE_HATCH.get());
        for (MachineDefinition machine : GTMachines.ITEM_IMPORT_BUS) {
            if (machine == null) continue;
            ITEMS_INPUT.register(machine.getTier(), (Block)machine.get());
        }
        for (MachineDefinition machine : GTMachines.ITEM_EXPORT_BUS) {
            if (machine == null) continue;
            ITEMS_OUTPUT.register(machine.getTier(), (Block)machine.get());
        }
    }

    static {
        if (LANG != null) {
            LANG.put("gtocore.part_ability.export_items", new CNEN("\u7269\u54c1\u8f93\u51fa\u4ed3", "Items Output"));
            LANG.put("gtocore.part_ability.import_items", new CNEN("\u7269\u54c1\u8f93\u5165\u4ed3", "Items Input"));
            LANG.put("gtocore.part_ability.export_fluids", new CNEN("\u6d41\u4f53\u8f93\u51fa\u4ed3", "Fluids Output"));
            LANG.put("gtocore.part_ability.import_fluids", new CNEN("\u6d41\u4f53\u8f93\u5165\u4ed3", "Fluids Input"));
            LANG.put("gtocore.part_ability.export_fluids_1x", new CNEN("\u6d41\u4f53\u8f93\u51fa\u4ed3(\u4e00\u91cd)", "Fluids Output (1x)"));
            LANG.put("gtocore.part_ability.import_fluids_1x", new CNEN("\u6d41\u4f53\u8f93\u5165\u4ed3(\u4e00\u91cd)", "Fluids Input (1x)"));
            LANG.put("gtocore.part_ability.export_fluids_4x", new CNEN("\u6d41\u4f53\u8f93\u51fa\u4ed3(\u56db\u91cd)", "Fluids Output (4x)"));
            LANG.put("gtocore.part_ability.import_fluids_4x", new CNEN("\u6d41\u4f53\u8f93\u5165\u4ed3(\u56db\u91cd)", "Fluids Input (4x)"));
            LANG.put("gtocore.part_ability.export_fluids_9x", new CNEN("\u6d41\u4f53\u8f93\u51fa\u4ed3(\u4e5d\u91cd)", "Fluids Output (9x)"));
            LANG.put("gtocore.part_ability.import_fluids_9x", new CNEN("\u6d41\u4f53\u8f93\u5165\u4ed3(\u4e5d\u91cd)", "Fluids Input (9x)"));
            LANG.put("gtocore.part_ability.input_energy", new CNEN("\u80fd\u6e90\u4ed3", "Energy Input"));
            LANG.put("gtocore.part_ability.output_energy", new CNEN("\u52a8\u529b\u4ed3", "Energy Output"));
            LANG.put("gtocore.part_ability.substation_input_energy", new CNEN("\u53d8\u7535\u7ad9\u80fd\u91cf\u8f93\u5165\u4ed3", "Substation Energy Input"));
            LANG.put("gtocore.part_ability.substation_output_energy", new CNEN("\u53d8\u7535\u7ad9\u80fd\u91cf\u8f93\u51fa\u4ed3", "Substation Energy Output"));
            LANG.put("gtocore.part_ability.rotor_holder", new CNEN("\u8f6c\u5b50\u652f\u67b6", "Rotor Holder"));
            LANG.put("gtocore.part_ability.pump_fluid_hatch", new CNEN("\u6c34\u6cf5\u4ed3", "Pump Fluid Hatch"));
            LANG.put("gtocore.part_ability.steam", new CNEN("\u84b8\u6c7d\u4ed3", "Steam Hatch"));
            LANG.put("gtocore.part_ability.steam_import_items", new CNEN("\u84b8\u6c7d\u7269\u54c1\u8f93\u5165\u4ed3", "Steam Import Items"));
            LANG.put("gtocore.part_ability.steam_export_items", new CNEN("\u84b8\u6c7d\u7269\u54c1\u8f93\u51fa\u4ed3", "Steam Export Items"));
            LANG.put("gtocore.part_ability.maintenance", new CNEN("\u7ef4\u62a4\u4ed3", "Maintenance Hatch"));
            LANG.put("gtocore.part_ability.muffler", new CNEN("\u6d88\u58f0\u4ed3", "Muffler"));
            LANG.put("gtocore.part_ability.tank_valve", new CNEN("\u50a8\u7f50\u9600\u95e8", "Tank Valve"));
            LANG.put("gtocore.part_ability.passthrough_hatch", new CNEN("\u901a\u884c\u4ed3", "Passthrough Hatch"));
            LANG.put("gtocore.part_ability.parallel_hatch", new CNEN("\u5e76\u884c\u4ed3", "Parallel Hatch"));
            LANG.put("gtocore.part_ability.input_laser", new CNEN("\u6fc0\u5149\u80fd\u6e90\u4ed3", "Input Laser"));
            LANG.put("gtocore.part_ability.output_laser", new CNEN("\u6fc0\u5149\u52a8\u529b\u4ed3", "Output Laser"));
            LANG.put("gtocore.part_ability.computation_data_reception", new CNEN("\u7b97\u529b\u6570\u636e\u9776\u4ed3", "Computation Data Reception"));
            LANG.put("gtocore.part_ability.computation_data_transmission", new CNEN("\u7b97\u529b\u6570\u636e\u6e90\u4ed3", "Computation Data Transmission"));
            LANG.put("gtocore.part_ability.optical_data_reception", new CNEN("\u5149\u5b66\u6570\u636e\u9776\u4ed3", "Optical Data Reception"));
            LANG.put("gtocore.part_ability.optical_data_transmission", new CNEN("\u5149\u5b66\u6570\u636e\u6e90\u4ed3", "Optical Data Transmission"));
            LANG.put("gtocore.part_ability.data_access", new CNEN("\u6570\u636e\u8bbf\u95ee\u4ed3", "Data Access"));
            LANG.put("gtocore.part_ability.hpca_component", new CNEN("\u9ad8\u6027\u80fd\u8ba1\u7b97\u7ec4\u4ef6", "HPCA Component"));
        }
    }
}

