/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.misc;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\u0012\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006 "}, d2={"Lcom/gtocore/api/misc/NetworkStats;", "", "totalNodes", "", "totalClusters", "totalConnections", "averageLoadFactor", "", "maxPossibleConnections", "<init>", "(IIIDI)V", "getTotalNodes", "()I", "getTotalClusters", "getTotalConnections", "getAverageLoadFactor", "()D", "getMaxPossibleConnections", "connectionEfficiency", "getConnectionEfficiency", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "gtocore"})
public final class NetworkStats {
    private final int totalNodes;
    private final int totalClusters;
    private final int totalConnections;
    private final double averageLoadFactor;
    private final int maxPossibleConnections;

    public NetworkStats(int totalNodes, int totalClusters, int totalConnections, double averageLoadFactor, int maxPossibleConnections) {
        this.totalNodes = totalNodes;
        this.totalClusters = totalClusters;
        this.totalConnections = totalConnections;
        this.averageLoadFactor = averageLoadFactor;
        this.maxPossibleConnections = maxPossibleConnections;
    }

    public final int getTotalNodes() {
        return this.totalNodes;
    }

    public final int getTotalClusters() {
        return this.totalClusters;
    }

    public final int getTotalConnections() {
        return this.totalConnections;
    }

    public final double getAverageLoadFactor() {
        return this.averageLoadFactor;
    }

    public final int getMaxPossibleConnections() {
        return this.maxPossibleConnections;
    }

    public final double getConnectionEfficiency() {
        return this.maxPossibleConnections > 0 ? (double)this.totalConnections / (double)this.maxPossibleConnections : 0.0;
    }

    public final int component1() {
        return this.totalNodes;
    }

    public final int component2() {
        return this.totalClusters;
    }

    public final int component3() {
        return this.totalConnections;
    }

    public final double component4() {
        return this.averageLoadFactor;
    }

    public final int component5() {
        return this.maxPossibleConnections;
    }

    @NotNull
    public final NetworkStats copy(int totalNodes, int totalClusters, int totalConnections, double averageLoadFactor, int maxPossibleConnections) {
        return new NetworkStats(totalNodes, totalClusters, totalConnections, averageLoadFactor, maxPossibleConnections);
    }

    public static /* synthetic */ NetworkStats copy$default(NetworkStats networkStats, int n, int n2, int n3, double d, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = networkStats.totalNodes;
        }
        if ((n5 & 2) != 0) {
            n2 = networkStats.totalClusters;
        }
        if ((n5 & 4) != 0) {
            n3 = networkStats.totalConnections;
        }
        if ((n5 & 8) != 0) {
            d = networkStats.averageLoadFactor;
        }
        if ((n5 & 0x10) != 0) {
            n4 = networkStats.maxPossibleConnections;
        }
        return networkStats.copy(n, n2, n3, d, n4);
    }

    @NotNull
    public String toString() {
        return "NetworkStats(totalNodes=" + this.totalNodes + ", totalClusters=" + this.totalClusters + ", totalConnections=" + this.totalConnections + ", averageLoadFactor=" + this.averageLoadFactor + ", maxPossibleConnections=" + this.maxPossibleConnections + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.totalNodes);
        result = result * 31 + Integer.hashCode(this.totalClusters);
        result = result * 31 + Integer.hashCode(this.totalConnections);
        result = result * 31 + Double.hashCode(this.averageLoadFactor);
        result = result * 31 + Integer.hashCode(this.maxPossibleConnections);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NetworkStats)) {
            return false;
        }
        NetworkStats networkStats = (NetworkStats)other;
        if (this.totalNodes != networkStats.totalNodes) {
            return false;
        }
        if (this.totalClusters != networkStats.totalClusters) {
            return false;
        }
        if (this.totalConnections != networkStats.totalConnections) {
            return false;
        }
        if (Double.compare(this.averageLoadFactor, networkStats.averageLoadFactor) != 0) {
            return false;
        }
        return this.maxPossibleConnections == networkStats.maxPossibleConnections;
    }
}

