/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.api.report;

import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixRegistry;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class AffixReporter {
    private static final Path LOG_DIR = Paths.get("logs", "report");
    private static final Pattern PATTERN = Pattern.compile("[^a-zA-Z0-9.-]");

    public static void getAffixReporter() {
        AffixReporter.exportAllAffixesToFile();
        AffixReporter.exportCompleteAffixReport();
        AffixReporter.exportAllAffixesToArrays();
    }

    private static void exportAllAffixesToFile() {
        try {
            if (!Files.exists(LOG_DIR, new LinkOption[0])) {
                Files.createDirectories(LOG_DIR, new FileAttribute[0]);
            }
            String timestamp = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
            Path outputFile = LOG_DIR.resolve("affixes_report_" + timestamp + ".txt");
            try (BufferedWriter writer = Files.newBufferedWriter(outputFile, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                writer.write("=== \u8bcd\u7f00\u7cfb\u7edf\u62a5\u544a ===\n");
                writer.write("\u751f\u6210\u65f6\u95f4: " + String.valueOf(new Date()) + "\n\n");
                writer.write("=== \u6240\u6709\u5df2\u6ce8\u518c\u8bcd\u7f00 ===\n");
                Collection allAffixes = AffixRegistry.INSTANCE.getValues();
                writer.write("\u8bcd\u7f00\u603b\u6570: " + allAffixes.size() + "\n\n");
                ArrayList<String> affixId = new ArrayList<String>();
                ArrayList<String> affixType = new ArrayList<String>();
                ArrayList<String> affixPrefixName = new ArrayList<String>();
                ArrayList<String> affixSuffixName = new ArrayList<String>();
                for (Affix affix : allAffixes) {
                    ResourceLocation id = AffixRegistry.INSTANCE.getKey((CodecProvider)affix);
                    writer.write("addRecord(\"" + id.toString() + "\",\"" + affix.getName(true).getString() + " \u00b7 " + affix.getName(false).getString() + "\",\"" + affix.getName(true).getString() + " \u00b7 " + affix.getName(false).getString() + "\");\n");
                    affixId.add(id.toString());
                    affixType.add(String.valueOf(affix.getType()));
                    String prefixName = affix.getName(true).getString();
                    String suffixName = affix.getName(false).getString();
                    affixPrefixName.add(prefixName);
                    affixSuffixName.add(suffixName);
                }
                writer.write("---\n");
                writer.write("\n\n=== \u6309\u6570\u7ec4\u8f93\u51fa\u7684\u8bcd\u7f00 ===\n");
                AffixReporter.writeStringArrayToFile(writer, "affixId", affixId);
                AffixReporter.writeStringArrayToFile(writer, "affixType", affixType);
                AffixReporter.writeStringArrayToFile(writer, "affixPrefixName", affixPrefixName);
                AffixReporter.writeStringArrayToFile(writer, "affixSuffixName", affixSuffixName);
                writer.write("\n\n=== \u6309\u7c7b\u578b\u5206\u7c7b\u7684\u8bcd\u7f00 ===\n");
                for (AffixType type : AffixType.values()) {
                    Collection affixesOfType = AffixHelper.byType((AffixType)type);
                    if (affixesOfType.isEmpty()) continue;
                    writer.write(String.valueOf(type) + "\u7c7b\u578b\u8bcd\u7f00 (" + affixesOfType.size() + "\u4e2a):\n");
                    for (DynamicHolder holder : affixesOfType) {
                        if (!holder.isBound()) continue;
                        writer.write("  - " + String.valueOf(holder.getId()) + "\n");
                    }
                    writer.write("---\n");
                }
                writer.write("\n\n=== \u7a00\u6709\u5ea6\u4fe1\u606f ===\n");
                for (LootRarity rarity : RarityRegistry.INSTANCE.getValues()) {
                    writer.write("\u7a00\u6709\u5ea6: " + String.valueOf(RarityRegistry.INSTANCE.getKey((CodecProvider)rarity)) + " (\u6743\u91cd: " + rarity.getWeight() + ")\n");
                }
                writer.write("\n\u62a5\u544a\u751f\u6210\u5b8c\u6210\u3002\n");
            }
            System.out.println("\u8bcd\u7f00\u62a5\u544a\u5df2\u4fdd\u5b58\u5230: " + String.valueOf(outputFile.toAbsolutePath()));
        }
        catch (IOException e) {
            System.err.println("\u4fdd\u5b58\u8bcd\u7f00\u62a5\u544a\u65f6\u51fa\u9519: " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("\u751f\u6210\u8bcd\u7f00\u62a5\u544a\u65f6\u51fa\u9519: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void exportItemAffixesToFile(ItemStack stack) {
        try {
            if (!Files.exists(LOG_DIR, new LinkOption[0])) {
                Files.createDirectories(LOG_DIR, new FileAttribute[0]);
            }
            String timestamp = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
            String itemName = PATTERN.matcher(stack.m_41611_().getString()).replaceAll("_");
            Path outputFile = LOG_DIR.resolve("item_affixes_" + itemName + "_" + timestamp + ".txt");
            try (BufferedWriter writer = Files.newBufferedWriter(outputFile, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                writer.write("=== \u7269\u54c1\u8bcd\u7f00\u62a5\u544a ===\n");
                writer.write("\u751f\u6210\u65f6\u95f4: " + String.valueOf(new Date()) + "\n\n");
                writer.write("\u7269\u54c1: " + stack.m_41611_().getString() + "\n");
                writer.write("\u7269\u54c1ID: " + stack.m_41720_().m_5524_() + "\n");
                LootCategory category = LootCategory.forItem((ItemStack)stack);
                writer.write("\u7269\u54c1\u7c7b\u522b: " + category.getName() + "\n");
                DynamicHolder rarity = AffixHelper.getRarity((ItemStack)stack);
                writer.write("\u7a00\u6709\u5ea6: " + String.valueOf(rarity.isBound() ? rarity.getId() : "\u672a\u77e5") + "\n");
                Map affixes = AffixHelper.getAffixes((ItemStack)stack);
                if (affixes.isEmpty()) {
                    writer.write("\u6b64\u7269\u54c1\u6ca1\u6709\u4efb\u4f55\u8bcd\u7f00!\n");
                } else {
                    writer.write("\u8bcd\u7f00\u5217\u8868 (" + affixes.size() + "\u4e2a):\n");
                    for (Map.Entry entry : affixes.entrySet()) {
                        AffixInstance instance = (AffixInstance)entry.getValue();
                        if (instance.isValid()) {
                            writer.write("  - " + String.valueOf(instance.affix().getId()) + " (\u7b49\u7ea7: " + instance.level() + ")\n");
                            writer.write("    \u7c7b\u578b: " + String.valueOf(((Affix)instance.affix().get()).getType()) + "\n");
                            writer.write("    \u63cf\u8ff0: " + instance.getDescription().getString() + "\n");
                            continue;
                        }
                        writer.write("  - " + String.valueOf(instance.affix().getId()) + " (\u65e0\u6548)\n");
                    }
                }
                writer.write("\n\u62a5\u544a\u751f\u6210\u5b8c\u6210\u3002\n");
            }
            System.out.println("\u7269\u54c1\u8bcd\u7f00\u62a5\u544a\u5df2\u4fdd\u5b58\u5230: " + String.valueOf(outputFile.toAbsolutePath()));
        }
        catch (IOException e) {
            System.err.println("\u4fdd\u5b58\u7269\u54c1\u8bcd\u7f00\u62a5\u544a\u65f6\u51fa\u9519: " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("\u751f\u6210\u7269\u54c1\u8bcd\u7f00\u62a5\u544a\u65f6\u51fa\u9519: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void exportCompleteAffixReport() {
        try {
            if (!Files.exists(LOG_DIR, new LinkOption[0])) {
                Files.createDirectories(LOG_DIR, new FileAttribute[0]);
            }
            String timestamp = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
            Path outputFile = LOG_DIR.resolve("affix_complete_report_" + timestamp + ".txt");
            try (BufferedWriter writer = Files.newBufferedWriter(outputFile, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                writer.write("=== \u5b8c\u6574\u8bcd\u7f00\u7cfb\u7edf\u62a5\u544a ===\n");
                writer.write("\u751f\u6210\u65f6\u95f4: " + String.valueOf(new Date()) + "\n\n");
                writer.write("=== \u6240\u6709\u8bcd\u7f00\u6982\u89c8 ===\n");
                Collection allAffixes = AffixRegistry.INSTANCE.getValues();
                writer.write("\u8bcd\u7f00\u603b\u6570: " + allAffixes.size() + "\n\n");
                LootRarity defaultRarity = (LootRarity)RarityRegistry.getMinRarity().get();
                writer.write("\n=== \u6309\u7c7b\u578b\u5206\u7c7b\u7684\u8bcd\u7f00\u8be6\u60c5 ===\n");
                for (AffixType type : AffixType.values()) {
                    Collection affixesOfType = AffixHelper.byType((AffixType)type);
                    if (affixesOfType.isEmpty()) continue;
                    writer.write("\n" + String.valueOf(type) + "\u7c7b\u578b\u8bcd\u7f00 (" + affixesOfType.size() + "\u4e2a):\n");
                    writer.write("=".repeat(50) + "\n");
                    for (DynamicHolder holder : affixesOfType) {
                        if (!holder.isBound()) continue;
                        Affix affix = (Affix)holder.get();
                        writer.write("\u8bcd\u7f00ID: " + String.valueOf(holder.getId()) + "\n");
                        writer.write("  \u7c7b\u578b: " + String.valueOf(affix.getType()) + "\n");
                        String prefixName = affix.getName(true).getString();
                        String suffixName = affix.getName(false).getString();
                        writer.write("  \u524d\u7f00\u540d\u79f0: " + prefixName + "\n");
                        writer.write("  \u540e\u7f00\u540d\u79f0: " + suffixName + "\n");
                        writer.write("-".repeat(30) + "\n");
                    }
                }
                writer.write("\n\n=== \u7a00\u6709\u5ea6\u4fe1\u606f ===\n");
                for (LootRarity rarity : RarityRegistry.INSTANCE.getValues()) {
                    writer.write("\u7a00\u6709\u5ea6: " + String.valueOf(RarityRegistry.INSTANCE.getKey((CodecProvider)rarity)) + " (\u6743\u91cd: " + rarity.getWeight() + ", \u989c\u8272: " + String.valueOf(rarity.getColor()) + ")\n");
                }
                writer.write("\n\u62a5\u544a\u751f\u6210\u5b8c\u6210\u3002\n");
            }
            System.out.println("\u5b8c\u6574\u8bcd\u7f00\u62a5\u544a\u5df2\u4fdd\u5b58\u5230: " + String.valueOf(outputFile.toAbsolutePath()));
        }
        catch (IOException e) {
            System.err.println("\u4fdd\u5b58\u5b8c\u6574\u8bcd\u7f00\u62a5\u544a\u65f6\u51fa\u9519: " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("\u751f\u6210\u5b8c\u6574\u8bcd\u7f00\u62a5\u544a\u65f6\u51fa\u9519: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static String[][] exportAllAffixesToArrays() {
        try {
            Collection allAffixes = AffixRegistry.INSTANCE.getValues();
            int affixCount = allAffixes.size();
            String[] affixIds = new String[affixCount];
            String[] affixTypes = new String[affixCount];
            String[] prefixNames = new String[affixCount];
            String[] suffixNames = new String[affixCount];
            int index = 0;
            for (Affix affix : allAffixes) {
                ResourceLocation id = AffixRegistry.INSTANCE.getKey((CodecProvider)affix);
                affixIds[index] = id.toString();
                affixTypes[index] = affix.getType().toString();
                prefixNames[index] = affix.getName(true).getString();
                suffixNames[index] = affix.getName(false).getString();
                ++index;
            }
            return new String[][]{affixIds, affixTypes, prefixNames, suffixNames};
        }
        catch (Exception e) {
            System.err.println("\u63d0\u53d6\u8bcd\u7f00\u4fe1\u606f\u65f6\u51fa\u9519: " + e.getMessage());
            e.printStackTrace();
            return new String[4][0];
        }
    }

    public static void printAllAffixes() {
        System.out.println("=== \u6240\u6709\u5df2\u6ce8\u518c\u8bcd\u7f00 ===");
        Collection allAffixes = AffixRegistry.INSTANCE.getValues();
        if (allAffixes.isEmpty()) {
            System.out.println("\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u8bcd\u7f00!");
            return;
        }
        LootRarity defaultRarity = (LootRarity)RarityRegistry.getMinRarity().get();
        for (Affix affix : allAffixes) {
            ResourceLocation id = AffixRegistry.INSTANCE.getKey((CodecProvider)affix);
            System.out.println("\u8bcd\u7f00ID: " + String.valueOf(id));
            System.out.println("  \u7c7b\u578b: " + String.valueOf(affix.getType()));
            try {
                String description = affix.getDescription(ItemStack.f_41583_, defaultRarity, 1.0f).getString();
                System.out.println("  \u63cf\u8ff0: " + description);
            }
            catch (Exception e) {
                System.out.println("  \u63cf\u8ff0: [\u83b7\u53d6\u5931\u8d25: " + e.getMessage() + "]");
            }
            System.out.println("---");
        }
        System.out.println("\u603b\u8ba1: " + allAffixes.size() + " \u4e2a\u8bcd\u7f00");
    }

    private static void writeStringArrayToFile(BufferedWriter writer, String arrayName, List<String> list) throws IOException {
        StringJoiner joiner = new StringJoiner(", ", "String[] " + arrayName + " = {", "};");
        for (String item : list) {
            joiner.add("\"" + item.replace("\\", "\\\\").replace("\"", "\\\"") + "\"");
        }
        writer.write(joiner.toString());
        writer.write("\n");
    }
}

