/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client;

import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gtolib.api.network.NetworkPack;
import com.gtolib.api.player.IEnhancedPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public final class KeyMessage {
    public static final NetworkPack NETWORK_PACK = NetworkPack.registerC2S((String)"keyPressC2S", (p, b2) -> KeyMessage.pressAction(p, b2.m_130242_()));

    public static void init() {
    }

    private static void pressAction(ServerPlayer player, int type) {
        Level level = player.m_9236_();
        if (!level.m_46805_(player.m_20183_())) {
            return;
        }
        switch (type) {
            case 0: {
                KeyMessage.handleFlightSpeed((Player)player);
                break;
            }
            case 2: {
                KeyMessage.upgradeToolSpeed((Player)player);
                break;
            }
            case 3: {
                KeyMessage.drift(player);
            }
        }
    }

    private static void handleFlightSpeed(Player player) {
        float speed = IEnhancedPlayer.of((Player)player).getPlayerData().flySpeedAble;
        if (speed == 0.0f) {
            return;
        }
        CompoundTag data = player.getPersistentData();
        int speedFactor = data.m_128451_("fly_speed") + 1;
        if (player.m_6144_()) {
            player.m_150110_().m_35943_(0.05f);
            player.m_6885_();
            player.m_5661_((Component)Component.m_237115_((String)"gtocore.fly_speed_reset"), true);
            data.m_128473_("fly_speed");
        } else {
            float currentSpeed = player.m_150110_().m_35942_();
            if (currentSpeed < speed) {
                player.m_150110_().m_35943_(0.05f * (float)speedFactor);
                player.m_6885_();
                data.m_128405_("fly_speed", speedFactor);
                player.m_5661_((Component)Component.m_237110_((String)"gtocore.fly_speed", (Object[])new Object[]{speedFactor + 1}), true);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"gtocore.reach_limit"), true);
            }
        }
    }

    private static void upgradeToolSpeed(Player player) {
        ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
        Item item = itemStack.m_41720_();
        if (item instanceof IGTTool) {
            IGTTool gtTool = (IGTTool)item;
            if (gtTool.getToolType().name.contains("_vajra")) {
                if (player.m_6144_()) {
                    itemStack.m_41784_().m_128379_("MinersFervor", !itemStack.m_41784_().m_128471_("MinersFervor"));
                    player.m_5661_((Component)Component.m_237110_((String)(itemStack.m_41784_().m_128471_("MinersFervor") ? "gui.active" : "gui.inactive"), (Object[])new Object[]{Component.m_237115_((String)"enchantment.apotheosis.miners_fervor")}), true);
                    return;
                }
                float speed = itemStack.m_41784_().m_128457_("ToolSpeed");
                float newSpeed = KeyMessage.adjustToolSpeed(speed, 4, (int)gtTool.getMaterialToolSpeed(itemStack));
                itemStack.m_41784_().m_128350_("ToolSpeed", newSpeed);
                player.m_5661_((Component)Component.m_237110_((String)"jade.horseStat.speed", (Object[])new Object[]{Float.valueOf(newSpeed)}), true);
            }
        }
    }

    private static float adjustToolSpeed(float speed, int fallback, int max) {
        if (speed > 0.0f) {
            if (speed * 2.0f < (float)max) {
                return speed * 2.0f;
            }
            if (speed < (float)max) {
                return max;
            }
        }
        return fallback;
    }

    private static void drift(ServerPlayer player) {
        if (player instanceof IEnhancedPlayer) {
            IEnhancedPlayer enhancedPlayer = (IEnhancedPlayer)player;
            boolean disableDrift = !enhancedPlayer.getPlayerData().disableDrift;
            enhancedPlayer.getPlayerData().setDrift(disableDrift);
            if (disableDrift) {
                player.m_5661_((Component)Component.m_237115_((String)"key.gtocore.drift").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)"gtocore.machine.off")), true);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"key.gtocore.drift").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)"gtocore.machine.on")), true);
            }
        }
    }
}

