/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.forge;

import appeng.client.gui.AEBaseScreen;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantic;
import com.gtocore.client.KeyBind;
import com.gtocore.config.GTOConfig;
import com.gtocore.integration.Mods;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="gtocore", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DebugScreenInspector {
    private static boolean visible = false;

    @SubscribeEvent
    public static void onGuiRender(ScreenEvent.Render.Post event) {
        if (!visible) {
            return;
        }
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            AbstractContainerMenu menu = screen2.m_6262_();
            int containerSlotCount = 0;
            int inventorySlotCount = 0;
            GuiGraphics graphics = event.getGuiGraphics();
            PoseStack poseStack = graphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 350.0f);
            Font font = Minecraft.m_91087_().f_91062_;
            for (Slot slot : menu.f_38839_) {
                int color;
                if (slot.f_40218_ instanceof Inventory) {
                    color = ChatFormatting.YELLOW.m_126665_();
                    ++inventorySlotCount;
                } else {
                    color = 4095;
                    ++containerSlotCount;
                }
                graphics.m_280614_(font, (Component)Component.m_237113_((String)Integer.toString(slot.getSlotIndex())), screen2.getGuiLeft() + slot.f_40220_, screen2.getGuiTop() + slot.f_40221_, color, false);
            }
            graphics.m_280614_(font, (Component)Component.m_237113_((String)String.valueOf(containerSlotCount)).m_130940_(ChatFormatting.BLUE), 5, 25, 0xFFFFFF, false);
            graphics.m_280614_(font, (Component)Component.m_237113_((String)String.valueOf(inventorySlotCount)).m_130940_(ChatFormatting.YELLOW), 5, 40, 0xFFFFFF, false);
            poseStack.m_85849_();
            int mouseAbsX = event.getMouseX();
            int mouseAbsY = event.getMouseY();
            int mouseRelX = event.getMouseX() - screen2.getGuiLeft();
            int mouseRelY = event.getMouseY() - screen2.getGuiTop();
            graphics.m_280614_(font, (Component)Component.m_237113_((String)String.format("Mouse Abs: %d, %d", mouseAbsX, mouseAbsY)).m_130940_(ChatFormatting.GREEN), mouseAbsX + 5, mouseAbsY + 5, 0xFFFFFF, false);
            graphics.m_280614_(font, (Component)Component.m_237113_((String)String.format("Mouse Rel: %d, %d", mouseRelX, mouseRelY)).m_130940_(ChatFormatting.YELLOW), mouseAbsX + 5, mouseAbsY + 20, 0xFFFFFF, false);
            Slot slot = screen2.m_97744_((double)mouseAbsX, (double)mouseAbsY);
            if (slot != null) {
                AEBaseScreen aeScreen;
                SlotSemantic semantics;
                graphics.m_280614_(font, (Component)Component.m_237113_((String)slot.getClass().getSimpleName()).m_130940_(ChatFormatting.GOLD), mouseAbsX + 5, mouseAbsY - 30, 0xFFFFFF, false);
                if (screen2 instanceof AEBaseScreen && (semantics = ((AEBaseMenu)(aeScreen = (AEBaseScreen)screen2).m_6262_()).getSlotSemantic(slot)) != null) {
                    graphics.m_280614_(font, (Component)Component.m_237113_((String)semantics.id()).m_130940_(ChatFormatting.AQUA), mouseAbsX + 5, mouseAbsY - 45, 0xFFFFFF, false);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onKeyDown(ScreenEvent.KeyPressed.Pre event) {
        if (Mods.SFM.isLoaded()) {
            return;
        }
        if (!GTOConfig.INSTANCE.dev) {
            return;
        }
        KeyMapping toggleKey = KeyBind.debugInspectKey;
        boolean toggleKeyPressed = toggleKey.isActiveAndMatches(InputConstants.Type.KEYSYM.m_84895_(event.getKeyCode()));
        if (toggleKeyPressed) {
            visible = !visible;
            event.setCanceled(true);
        }
    }
}

