/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.gui;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.MultiblockState;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.predicates.SimplePredicate;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.xei.handlers.item.CycleItemStackHandler;
import com.gtocore.integration.emi.multipage.MultiblockInfoEmiRecipe;
import com.gtolib.api.gui.PatternSlotWidget;
import com.gtolib.api.gui.SelectedSlotWidget;
import com.gtolib.api.item.ItemHandlerModifiable;
import com.gtolib.api.machine.MultiblockDefinition;
import com.gtolib.api.machine.feature.multiblock.IMultiStructureMachine;
import com.lowdragmc.lowdraglib.client.scene.WorldSceneRenderer;
import com.lowdragmc.lowdraglib.client.utils.RenderUtils;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.BlockPosFace;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import dev.emi.emi.screen.RecipeScreen;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public final class PatternPreview
extends WidgetGroup {
    private static boolean isPartHighlighting = false;
    private final MultiblockInfoEmiRecipe recipe;
    private boolean isLoaded;
    private static TrackedDummyWorld LEVEL;
    private static final Map<MultiblockMachineDefinition, MBPattern[]> CACHE;
    private final SceneWidget sceneWidget;
    private final DraggableScrollableWidgetGroup scrollableWidgetGroup;
    private final MBPattern[] patterns;
    private final List<SimplePredicate> predicates = new ArrayList<SimplePredicate>();
    private int index;
    private int layer;
    private PatternSlotWidget[] slotWidgets;
    private SlotWidget[] candidates;

    private PatternPreview(MultiblockInfoEmiRecipe recipe, MultiblockMachineDefinition controllerDefinition) {
        super(0, 0, 160, 160);
        this.recipe = recipe;
        this.setClientSideWidget();
        this.layer = -1;
        this.sceneWidget = new MySceneWidget().setOnSelected(this::onPosSelected).setRenderFacing(false).setRenderFacing(false);
        this.addWidget((Widget)this.sceneWidget);
        this.scrollableWidgetGroup = new DraggableScrollableWidgetGroup(3, 132, 154, 22).setXScrollBarHeight(4).setXBarStyle((IGuiTexture)GuiTextures.SLIDER_BACKGROUND, (IGuiTexture)GuiTextures.BUTTON).setScrollable(true).setDraggable(true).setScrollWheelDirection(DraggableScrollableWidgetGroup.ScrollWheelDirection.HORIZONTAL);
        this.scrollableWidgetGroup.setScrollYOffset(0);
        this.addWidget((Widget)this.scrollableWidgetGroup);
        if (ConfigHolder.INSTANCE.client.useVBO) {
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> ((SceneWidget)this.sceneWidget).useCacheBuffer());
            } else {
                this.sceneWidget.useCacheBuffer();
            }
        }
        this.addWidget((Widget)new ImageWidget(3, 3, 160, 10, (IGuiTexture)new TextTexture(controllerDefinition.getDescriptionId(), -1).setType(TextTexture.TextType.ROLL).setWidth(170).setDropShadow(true)));
        if (CACHE.containsKey(controllerDefinition)) {
            this.patterns = CACHE.get(controllerDefinition);
        } else {
            MultiblockDefinition definition = MultiblockDefinition.of((MultiblockMachineDefinition)controllerDefinition);
            MultiblockDefinition.Pattern[] pattern = definition.getPatterns();
            this.patterns = new MBPattern[pattern.length];
            for (int i = 0; i < pattern.length; ++i) {
                this.patterns[i] = this.initializePattern(definition, pattern[i], i);
            }
            CACHE.put(controllerDefinition, this.patterns);
            definition.clear();
        }
        this.addWidget((Widget)new ButtonWidget(138, 30, 18, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture(), new TextTexture("1").setSupplier(() -> "P:" + this.index)}), this::updatePatternIndex).setHoverBorderTexture(1, -1));
        this.addWidget((Widget)new ButtonWidget(138, 50, 18, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture(), new TextTexture("1").setSupplier(() -> this.layer >= 0 ? "L:" + this.layer : "ALL")}), this::updateLayer).setHoverBorderTexture(1, -1));
        this.addWidget((Widget)new ButtonWidget(138, 70, 18, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture(), new TextTexture("1").setSupplier(() -> isPartHighlighting ? "H:ON" : "H:OFF")}), cd -> {
            isPartHighlighting = !isPartHighlighting;
        }).setHoverBorderTexture(1, -1));
        this.sceneWidget.setAfterWorldRender(w -> {
            if (!isPartHighlighting) {
                return;
            }
            this.patterns[this.index].partsSet.forEach(pos -> {
                PoseStack poseStack = new PoseStack();
                BlockPos pos0 = BlockPos.m_122022_((long)pos);
                RenderSystem.disableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)1);
                poseStack.m_85836_();
                poseStack.m_85837_((double)pos0.m_123341_() + 0.5, (double)pos0.m_123342_() + 0.5, (double)pos0.m_123343_() + 0.5);
                poseStack.m_85841_(1.02f, 1.02f, 1.02f);
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder buffer = tesselator.m_85915_();
                RenderSystem.setShader(GameRenderer::m_172811_);
                buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                RenderUtils.renderCubeFace((PoseStack)poseStack, (BufferBuilder)buffer, (float)-0.5f, (float)-0.5f, (float)-0.5f, (float)0.5f, (float)0.5f, (float)0.5f, (float)0.2f, (float)0.6f, (float)0.2f, (float)0.3f);
                tesselator.m_85914_();
                poseStack.m_85849_();
                RenderSystem.blendFunc((int)770, (int)771);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableDepthTest();
            });
        });
        this.setPage();
        recipe.patterns = this.patterns;
    }

    private void updatePatternIndex(ClickData clickData) {
        switch (clickData.button) {
            case 0: {
                this.index = this.index + 1 >= this.patterns.length ? 0 : this.index + 1;
                break;
            }
            case 1: {
                this.index = this.index - 1 < 0 ? this.patterns.length - 1 : this.index - 1;
                break;
            }
            case 2: {
                this.index = 0;
            }
        }
        this.setPage();
    }

    private void updateLayer(ClickData clickData) {
        MBPattern pattern = this.patterns[this.index];
        int maxLayerIndex = pattern.maxY - pattern.minY;
        switch (clickData.button) {
            case 0: {
                ++this.layer;
                if (this.layer <= maxLayerIndex) break;
                this.layer = -1;
                break;
            }
            case 1: {
                --this.layer;
                if (this.layer >= -1) break;
                this.layer = maxLayerIndex;
                break;
            }
            case 2: {
                this.layer = -1;
            }
        }
        if (this.layer == -1) {
            if (!pattern.controllerBase.isFormed()) {
                this.onFormedSwitch(true);
            }
        } else if (pattern.controllerBase.isFormed()) {
            this.onFormedSwitch(false);
        }
        this.setupScene(pattern);
    }

    private void setupScene(MBPattern pattern) {
        LongStream longStream = pattern.predicateMap.keySet().longStream();
        if (pattern.controllerBase.isFormed()) {
            LongSet set = (LongSet)pattern.controllerBase.getMultiblockState().getMatchContext().getOrDefault((Object)"renderMask", (Object)LongSets.EMPTY_SET);
            if (!set.isEmpty()) {
                this.sceneWidget.setRenderedCore((Collection)longStream.filter(pos -> !set.contains(pos)).mapToObj(BlockPos::m_122022_).filter(pos -> this.layer == -1 || this.layer + pattern.minY == pos.m_123342_()).collect(Collectors.toList()), null);
            } else {
                this.sceneWidget.setRenderedCore(longStream.mapToObj(BlockPos::m_122022_).filter(pos -> this.layer == -1 || this.layer + pattern.minY == pos.m_123342_()).toList(), null);
            }
        } else {
            this.sceneWidget.setRenderedCore(longStream.mapToObj(BlockPos::m_122022_).filter(pos -> this.layer == -1 || this.layer + pattern.minY == pos.m_123342_()).toList(), null);
        }
        this.sceneWidget.setCenter(pattern.center.m_252807_().m_252839_());
    }

    public static PatternPreview getPatternWidget(MultiblockInfoEmiRecipe recipe, MultiblockMachineDefinition controllerDefinition) {
        if (LEVEL == null) {
            if (Minecraft.m_91087_().f_91073_ == null) {
                GTCEu.LOGGER.error("Try to init pattern previews before level load");
                throw new IllegalStateException();
            }
            LEVEL = new TrackedDummyWorld();
        }
        return new PatternPreview(recipe, controllerDefinition);
    }

    private void setPage() {
        if (this.index >= this.patterns.length || this.index < 0) {
            return;
        }
        this.layer = -1;
        PatternSlotWidget[] pattern = this.patterns[this.index];
        this.setupScene((MBPattern)pattern);
        List<ItemStack> itemList = pattern.parts;
        this.recipe.i = this.index;
        if (this.slotWidgets != null) {
            for (PatternSlotWidget slotWidget : this.slotWidgets) {
                this.scrollableWidgetGroup.removeWidget((Widget)slotWidget);
            }
        }
        this.slotWidgets = new PatternSlotWidget[itemList.size()];
        for (int i = 0; i < this.slotWidgets.length; ++i) {
            this.slotWidgets[i] = new PatternSlotWidget((IItemHandlerModifiable)new ItemHandlerModifiable(itemList.get(i)), i, 4 + i * 18, 0);
            this.scrollableWidgetGroup.addWidget((Widget)this.slotWidgets[i]);
        }
    }

    private void onFormedSwitch(boolean isFormed) {
        MBPattern pattern = this.patterns[this.index];
        IMultiController controllerBase = pattern.controllerBase;
        if (isFormed) {
            this.layer = -1;
            this.loadControllerFormed(pattern.predicateMap.keySet(), controllerBase, this.index);
        } else {
            this.sceneWidget.setRenderedCore(pattern.predicateMap.keySet().longStream().mapToObj(BlockPos::m_122022_).toList(), null);
            controllerBase.onStructureInvalid();
        }
    }

    private void onPosSelected(BlockPos pos, Direction facing) {
        if (this.index >= this.patterns.length || this.index < 0) {
            return;
        }
        TraceabilityPredicate predicate = (TraceabilityPredicate)this.patterns[this.index].predicateMap.get(pos.m_121878_());
        if (predicate != null) {
            this.predicates.clear();
            this.predicates.addAll(predicate.common);
            this.predicates.addAll(predicate.limited);
            this.predicates.removeIf(p -> p == null || p.candidates == null);
            if (this.candidates != null) {
                for (SlotWidget candidate : this.candidates) {
                    this.removeWidget((Widget)candidate);
                }
            }
            ArrayList<List> candidateStacks = new ArrayList<List>();
            ArrayList<List> predicateTips = new ArrayList<List>();
            for (SimplePredicate simplePredicate : this.predicates) {
                List itemStacks = simplePredicate.getCandidates();
                if (itemStacks.isEmpty()) continue;
                candidateStacks.add(itemStacks);
                predicateTips.add(simplePredicate.getToolTips(predicate));
            }
            this.candidates = new SlotWidget[candidateStacks.size()];
            CycleItemStackHandler itemHandler = new CycleItemStackHandler(candidateStacks);
            int maxCol = (132 - ((this.slotWidgets.length - 1) / 9 + 1) * 18 - 35) % 18;
            for (int i = 0; i < candidateStacks.size(); ++i) {
                int finalI = i;
                this.candidates[i] = new SelectedSlotWidget((List)candidateStacks.get(i), (IItemHandlerModifiable)itemHandler, i, 3 + i / maxCol * 18, 3 + i % maxCol * 18).setBackgroundTexture((IGuiTexture)new ColorRectTexture(0x4FFFFFFF)).setOnAddedTooltips((slot, list) -> list.addAll((Collection)predicateTips.get(finalI)));
                this.addWidget((Widget)this.candidates[i]);
            }
        }
    }

    private void loadControllerFormed(LongSet poses, IMultiController controllerBase, int index) {
        BlockPattern pattern;
        if (controllerBase instanceof IMultiStructureMachine) {
            IMultiStructureMachine machine = (IMultiStructureMachine)controllerBase;
            pattern = (BlockPattern)machine.getMultiPattern().get(index);
        } else {
            Supplier[] subPattern = controllerBase.getSubPattern();
            pattern = subPattern != null && index > 0 ? (BlockPattern)subPattern[index - 1].get() : controllerBase.getPattern();
        }
        MultiblockState state = controllerBase.getMultiblockState();
        if (pattern != null && pattern.checkPatternAt(state, true)) {
            controllerBase.onStructureFormed();
        }
        state.clearCache();
        if (controllerBase.isFormed()) {
            LongSet set = (LongSet)state.getMatchContext().getOrDefault((Object)"renderMask", (Object)LongSets.EMPTY_SET);
            if (!set.isEmpty()) {
                this.sceneWidget.setRenderedCore(poses.longStream().filter(pos -> !set.contains(pos)).mapToObj(BlockPos::m_122022_).toList(), null);
            } else {
                this.sceneWidget.setRenderedCore(poses.longStream().mapToObj(BlockPos::m_122022_).toList(), null);
            }
        } else {
            GTCEu.LOGGER.warn("Pattern formed checking failed: {}", (Object)controllerBase.self().getDefinition());
        }
    }

    private MBPattern initializePattern(MultiblockDefinition definition, MultiblockDefinition.Pattern pattern, int index) {
        Long2ObjectOpenHashMap predicateMap;
        IMultiController iMultiController;
        Pair pair = pattern.initialize(definition, index);
        Reference2ReferenceOpenHashMap patternMap = (Reference2ReferenceOpenHashMap)pair.getSecond();
        BlockPos pos = (BlockPos)pair.getFirst();
        Long2ReferenceOpenHashMap blockMap = new Long2ReferenceOpenHashMap(patternMap.values().stream().mapToInt(LongOpenHashSet::size).sum());
        patternMap.forEach((b2, i) -> i.forEach(p -> blockMap.put(p, b2)));
        BlockEntity blockEntity = ((BlockInfo)blockMap.get(pos.m_121878_())).getBlockEntity(pos);
        if (blockEntity instanceof MetaMachineBlockEntity) {
            IMultiController controller;
            MetaMachineBlockEntity blockEntity2 = (MetaMachineBlockEntity)blockEntity;
            blockEntity = blockEntity2.metaMachine;
            iMultiController = blockEntity instanceof IMultiController ? (controller = (IMultiController)blockEntity) : null;
        } else {
            iMultiController = null;
        }
        IMultiController controllerBase = iMultiController;
        ObjectIterator it = blockMap.long2ReferenceEntrySet().fastIterator();
        while (it.hasNext()) {
            Long2ReferenceMap.Entry entry = (Long2ReferenceMap.Entry)it.next();
            LEVEL.addBlock(BlockPos.m_122022_((long)entry.getLongKey()), (BlockInfo)entry.getValue());
        }
        if (controllerBase != null) {
            controllerBase.self().holder.getSelf().m_142339_((Level)LEVEL);
            LEVEL.setInnerBlockEntity((BlockEntity)controllerBase.self().holder.getSelf());
        }
        Long2ObjectOpenHashMap long2ObjectOpenHashMap = predicateMap = controllerBase == null ? null : new Long2ObjectOpenHashMap();
        if (controllerBase != null) {
            this.loadControllerFormed(predicateMap.keySet(), controllerBase, index);
            predicateMap = controllerBase.getMultiblockState().getMatchContext().getPredicates();
        }
        return controllerBase == null ? null : new MBPattern((Long2ReferenceOpenHashMap<BlockInfo>)blockMap, pattern.parts(), (Long2ObjectOpenHashMap<TraceabilityPredicate>)predicateMap, controllerBase);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseDragged(double mouseX, double mouseY, int button2, double dragX, double dragY) {
        if (button2 == 1) {
            double rotationPitch = Math.toRadians(this.sceneWidget.getRotationPitch());
            double rotationYaw = Math.toRadians(this.sceneWidget.getRotationYaw());
            float moveX = -((float)((dragY *= 0.1) * Math.sin(rotationYaw) * Math.cos(rotationPitch) + (dragX *= 0.1) * Math.sin(rotationPitch)));
            float moveY = (float)(dragY * Math.cos(rotationYaw));
            float moveZ = (float)(-dragY * Math.sin(rotationYaw) * Math.sin(rotationPitch) + dragX * Math.cos(rotationPitch));
            this.sceneWidget.setCenter(this.sceneWidget.getCenter().add(moveX, moveY, moveZ));
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button2, dragX, dragY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseWheelMove(double mouseX, double mouseY, double wheelDelta) {
        if (this.scrollableWidgetGroup.isMouseOverElement(mouseX, mouseY)) {
            return super.mouseWheelMove(mouseX, mouseY, wheelDelta);
        }
        if (this.sceneWidget.isMouseOverElement(mouseX, mouseY)) {
            double rotationPitch = Math.toRadians(this.sceneWidget.getRotationPitch());
            double rotationYaw = Math.toRadians(this.sceneWidget.getRotationYaw());
            float moveX = -((float)(wheelDelta * Math.cos(rotationYaw) * Math.cos(rotationPitch)));
            float moveY = -((float)(wheelDelta * Math.sin(rotationYaw)));
            float moveZ = -((float)(wheelDelta * Math.cos(rotationYaw) * Math.sin(rotationPitch)));
            this.sceneWidget.setCenter(this.sceneWidget.getCenter().add(moveX, moveY, moveZ));
            return true;
        }
        return super.mouseWheelMove(mouseX, mouseY, wheelDelta);
    }

    public void updateScreen() {
        super.updateScreen();
        if (!this.isLoaded && Minecraft.m_91087_().f_91080_ instanceof RecipeScreen) {
            this.setPage();
            this.isLoaded = true;
        }
    }

    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.enableBlend();
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
    }

    static {
        CACHE = new Reference2ReferenceOpenHashMap();
    }

    private static final class MySceneWidget
    extends SceneWidget {
        private MySceneWidget() {
            super(3, 3, 150, 150, (Level)LEVEL);
        }

        public void renderBlockOverLay(WorldSceneRenderer renderer) {
            BlockPosFace tmp;
            BlockHitResult hit;
            PoseStack poseStack = new PoseStack();
            this.hoverPosFace = null;
            this.hoverItem = null;
            if (this.isMouseOverElement(this.currentMouseX, this.currentMouseY) && (hit = renderer.getLastTraceResult()) != null) {
                if (this.core.contains(hit.m_82425_())) {
                    this.hoverPosFace = new BlockPosFace(hit.m_82425_(), hit.m_82434_());
                } else if (!this.useOrtho) {
                    Vector3f hitPos = hit.m_82450_().m_252839_();
                    Level world = renderer.world;
                    Vec3 eyePos = new Vec3(renderer.getEyePos());
                    hitPos.mul(2.0f);
                    Vec3 endPos = new Vec3((double)hitPos.x - eyePos.f_82479_, (double)hitPos.y - eyePos.f_82480_, (double)hitPos.z - eyePos.f_82481_);
                    double min = 3.4028234663852886E38;
                    for (BlockPos pos : this.core) {
                        double dist;
                        BlockState blockState = world.m_8055_(pos);
                        if (blockState.m_60734_() == Blocks.f_50016_ || (hit = world.m_45558_(eyePos, endPos, pos, blockState.m_60808_((BlockGetter)world, pos), blockState)) == null || hit.m_6662_() == HitResult.Type.MISS || !((dist = eyePos.m_82557_(hit.m_82450_())) < min)) continue;
                        min = dist;
                        this.hoverPosFace = new BlockPosFace(hit.m_82425_(), hit.m_82434_());
                    }
                }
            }
            if (this.hoverPosFace != null) {
                BlockState state = this.getDummyWorld().m_8055_(this.hoverPosFace.pos);
                this.hoverItem = state.m_60734_().m_7397_((BlockGetter)this.getDummyWorld(), this.hoverPosFace.pos, state);
            }
            BlockPosFace blockPosFace = tmp = this.dragging ? this.clickPosFace : this.hoverPosFace;
            if (this.selectedPosFace != null || tmp != null) {
                if (this.selectedPosFace != null && this.renderFacing) {
                    this.drawFacingBorder(poseStack, this.selectedPosFace, -16711936);
                }
                if (tmp != null && !tmp.equals((Object)this.selectedPosFace) && this.renderFacing) {
                    this.drawFacingBorder(poseStack, tmp, -1);
                }
            }
            if (this.selectedPosFace != null && this.renderSelect) {
                RenderUtils.renderBlockOverLay((PoseStack)poseStack, (BlockPos)this.selectedPosFace.pos, (float)0.6f, (float)0.0f, (float)0.0f, (float)1.03f);
            }
            if (this.afterWorldRender != null) {
                this.afterWorldRender.accept(this);
            }
        }
    }

    public static class MBPattern {
        @NotNull
        public final List<ItemStack> parts;
        @NotNull
        private final Long2ObjectOpenHashMap<TraceabilityPredicate> predicateMap;
        @NotNull
        private final IMultiController controllerBase;
        private final LongSet partsSet;
        private final int maxY;
        private final int minY;
        private final BlockPos center;

        private MBPattern(@NotNull Long2ReferenceOpenHashMap<BlockInfo> blockMap, @NotNull List<ItemStack> parts, @NotNull Long2ObjectOpenHashMap<TraceabilityPredicate> predicateMap, @NotNull IMultiController controllerBase) {
            this.parts = parts;
            this.partsSet = new LongOpenHashSet();
            this.predicateMap = predicateMap;
            this.controllerBase = controllerBase;
            this.center = controllerBase.self().getPos();
            for (Long2ObjectMap.Entry entry : predicateMap.long2ObjectEntrySet()) {
                long pos = entry.getLongKey();
                TraceabilityPredicate predicate = (TraceabilityPredicate)entry.getValue();
                predicate.common.stream().map(s -> (BlockInfo)s.blockInfo.get()).filter(Objects::nonNull).filter(s -> {
                    MetaMachineBlockEntity mmbe;
                    BlockEntity patt0$temp;
                    return s.hasBlockEntity() && (patt0$temp = s.getBlockEntity(BlockPos.m_122022_((long)entry.getLongKey()))) instanceof MetaMachineBlockEntity && (mmbe = (MetaMachineBlockEntity)patt0$temp).getMetaMachine() instanceof MultiblockPartMachine;
                }).forEach(s -> this.partsSet.add(pos));
                predicate.limited.stream().map(s -> (BlockInfo)s.blockInfo.get()).filter(Objects::nonNull).filter(s -> {
                    MetaMachineBlockEntity mmbe;
                    BlockEntity patt0$temp;
                    return s.hasBlockEntity() && (patt0$temp = s.getBlockEntity(BlockPos.m_122022_((long)entry.getLongKey()))) instanceof MetaMachineBlockEntity && (mmbe = (MetaMachineBlockEntity)patt0$temp).getMetaMachine() instanceof MultiblockPartMachine;
                }).forEach(s -> this.partsSet.add(pos));
            }
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            ObjectIterator it = blockMap.long2ReferenceEntrySet().fastIterator();
            while (it.hasNext()) {
                int y = BlockPos.m_122008_((long)((Long2ReferenceMap.Entry)it.next()).getLongKey());
                min = Math.min(min, y);
                max = Math.max(max, y);
            }
            this.minY = min;
            this.maxY = max;
        }
    }
}

