/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
public final class TurbineModel
extends Model {
    private static final Set<Direction> ALL_DIRECTIONS = EnumSet.allOf(Direction.class);
    private final ModelPart base;

    public TurbineModel() {
        super(RenderType::m_110458_);
        ModelPart.Cube[] baseCuboids = new ModelPart.Cube[]{new ModelPart.Cube(0, 0, -2.0f, -2.0f, -1.0f, 4.0f, 4.0f, 2.0f, 0.0f, 0.0f, 0.0f, false, 64.0f, 64.0f, ALL_DIRECTIONS), new ModelPart.Cube(0, 6, -1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f, false, 64.0f, 64.0f, ALL_DIRECTIONS)};
        ImmutableMap.Builder map = ImmutableMap.builder();
        ModelPart.Cube[] blade1Cuboids = new ModelPart.Cube[]{new ModelPart.Cube(0, 9, -24.0f, -1.0f, -0.5f, 24.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f, false, 64.0f, 64.0f, ALL_DIRECTIONS)};
        ModelPart blade1 = new ModelPart(Arrays.asList(blade1Cuboids), Collections.emptyMap());
        blade1.m_104227_(0.0f, 0.0f, 0.0f);
        TurbineModel.setRotation(blade1, 0.0f);
        map.put((Object)"blade1", (Object)blade1);
        ModelPart.Cube[] blade2Cuboids = new ModelPart.Cube[]{new ModelPart.Cube(0, 9, -24.0f, -1.0f, -0.5f, 24.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f, false, 64.0f, 64.0f, ALL_DIRECTIONS)};
        ModelPart blade2 = new ModelPart(Arrays.asList(blade2Cuboids), Collections.emptyMap());
        blade2.m_104227_(0.0f, 0.0f, 0.0f);
        TurbineModel.setRotation(blade2, 2.0944f);
        map.put((Object)"blade2", (Object)blade2);
        ModelPart.Cube[] blade3Cuboids = new ModelPart.Cube[]{new ModelPart.Cube(0, 9, -24.0f, -2.0f, -1.075f, 24.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f, false, 64.0f, 64.0f, ALL_DIRECTIONS)};
        ModelPart blade3 = new ModelPart(Arrays.asList(blade3Cuboids), Collections.emptyMap());
        blade3.m_104227_(0.0f, 0.0f, 0.0f);
        TurbineModel.setRotation(blade3, -2.0944f);
        map.put((Object)"blade3", (Object)blade3);
        this.base = new ModelPart(Arrays.asList(baseCuboids), (Map)map.build());
        this.base.m_104227_(0.0f, 24.0f, 0.0f);
    }

    private static void setRotation(ModelPart model, float z) {
        model.f_104203_ = -0.5236f;
        model.f_104204_ = 0.0f;
        model.f_104205_ = z;
    }

    public void setSpin(float z) {
        this.base.f_104205_ = z;
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        this.base.m_104301_(matrixStack, vertexConsumer, light, overlay);
    }
}

