/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.client.renderer.GTRenderTypes;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableCasingMachineRenderer;
import com.gregtechceu.gtceu.client.util.BloomUtils;
import com.gregtechceu.gtceu.client.util.RenderBufferHelper;
import com.gtocore.client.renderer.RenderHelper;
import com.gtocore.common.machine.multiblock.electric.AdvancedFusionReactorMachine;
import com.lowdragmc.shimmer.client.shader.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class AdvancedFusionReactorRenderer
extends WorkableCasingMachineRenderer {
    private float delta = 0.0f;
    private int lastColor = -1;

    public AdvancedFusionReactorRenderer(ResourceLocation baseCasing, ResourceLocation workableModel) {
        super(baseCasing, workableModel);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(BlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        MetaMachineBlockEntity machineBlockEntity;
        MetaMachine metaMachine;
        if (blockEntity instanceof MetaMachineBlockEntity && (metaMachine = (machineBlockEntity = (MetaMachineBlockEntity)blockEntity).getMetaMachine()) instanceof AdvancedFusionReactorMachine) {
            AdvancedFusionReactorMachine machine = (AdvancedFusionReactorMachine)metaMachine;
            if (!machine.recipeLogic.isWorking() && this.delta <= 0.0f) {
                return;
            }
            if (GTCEu.Mods.isShimmerLoaded()) {
                PoseStack finalStack = RenderUtils.copyPoseStack((PoseStack)stack);
                BloomUtils.entityBloom(source -> this.renderLightRing(machine, partialTicks, finalStack, (MultiBufferSource)source));
            } else {
                this.renderLightRing(machine, partialTicks, stack, buffer);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderLightRing(AdvancedFusionReactorMachine machine, float partialTicks, PoseStack poseStack, MultiBufferSource buffer) {
        boolean hasExtraRender;
        double x = 0.5;
        double y = 6.75;
        double z = 0.5;
        switch (machine.getFrontFacing()) {
            case NORTH: {
                z = 19.5;
                break;
            }
            case SOUTH: {
                z = -18.5;
                break;
            }
            case WEST: {
                x = 19.5;
                break;
            }
            case EAST: {
                x = -18.5;
            }
        }
        poseStack.m_85836_();
        poseStack.m_85837_(x, y, z);
        int color = machine.getColor();
        float alpha = 1.0f;
        if (machine.recipeLogic.isWorking()) {
            this.lastColor = color;
            this.delta = 60.0f;
        } else {
            alpha = this.delta / 60.0f;
            this.lastColor = FastColor.ARGB32.m_13660_((int)Mth.m_14143_((float)(alpha * 255.0f)), (int)FastColor.ARGB32.m_13665_((int)this.lastColor), (int)FastColor.ARGB32.m_13667_((int)this.lastColor), (int)FastColor.ARGB32.m_13669_((int)this.lastColor));
            this.delta -= Minecraft.m_91087_().m_91297_();
        }
        float lerpFactor = Math.abs((float)Math.abs(machine.getOffsetTimer() % 50) + partialTicks - 25.0f) / 25.0f;
        Direction front = machine.getFrontFacing();
        Direction upwards = machine.getUpwardsFacing();
        boolean flipped = machine.isFlipped();
        Direction.Axis axis = RelativeDirection.UP.getRelative(front, upwards, flipped).m_122434_();
        float r = Mth.m_14179_((float)lerpFactor, (float)FastColor.ARGB32.m_13665_((int)this.lastColor), (float)255.0f) / 255.0f;
        float g = Mth.m_14179_((float)lerpFactor, (float)FastColor.ARGB32.m_13667_((int)this.lastColor), (float)255.0f) / 255.0f;
        float b2 = Mth.m_14179_((float)lerpFactor, (float)FastColor.ARGB32.m_13669_((int)this.lastColor), (float)255.0f) / 255.0f;
        RenderBufferHelper.renderRing((PoseStack)poseStack, (VertexConsumer)buffer.m_6299_(GTRenderTypes.getLightRing()), (float)0.0f, (float)0.0f, (float)0.0f, (float)8.0f, (float)1.2f, (int)10, (int)20, (float)r, (float)g, (float)b2, (float)alpha, (Direction.Axis)axis);
        poseStack.m_85849_();
        boolean bl = hasExtraRender = machine.getSubFormed().length > 3 && machine.getSubFormed()[3];
        if (hasExtraRender) {
            double lerpFactor2 = (double)(machine.getOffsetTimer() % 50) / 100.0;
            poseStack.m_85836_();
            poseStack.m_85837_(x, y + 27.0 - lerpFactor2 * 20.0, z);
            RenderBufferHelper.renderRing((PoseStack)poseStack, (VertexConsumer)buffer.m_6299_(GTRenderTypes.getLightRing()), (float)0.0f, (float)0.0f, (float)0.0f, (float)6.0f, (float)1.0f, (int)10, (int)20, (float)r, (float)g, (float)b2, (float)alpha, (Direction.Axis)axis);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85837_(x, y + 27.0 - (0.5 + lerpFactor2) * 20.0, z);
            RenderBufferHelper.renderRing((PoseStack)poseStack, (VertexConsumer)buffer.m_6299_(GTRenderTypes.getLightRing()), (float)0.0f, (float)0.0f, (float)0.0f, (float)6.0f, (float)1.0f, (int)10, (int)20, (float)r, (float)g, (float)b2, (float)alpha, (Direction.Axis)axis);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85837_(x, y + 7.0, z);
            RenderHelper.renderCylinder(poseStack, buffer.m_6299_(GTRenderTypes.getLightRing()), 0.0f, 0.0f, 0.0f, 3.8f, 20.0f, 20, r / 2.0f, g / 2.0f, b2 / 2.0f, alpha);
            poseStack.m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasTESR(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isGlobalRenderer(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getViewDistance() {
        return 96;
    }
}

