/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.GTRenderTypes;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableCasingMachineRenderer;
import com.gregtechceu.gtceu.client.util.BloomUtils;
import com.gtocore.client.renderer.RenderHelper;
import com.gtolib.api.machine.multiblock.CoilCrossRecipeMultiblockMachine;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.lowdragmc.lowdraglib.utils.interpolate.Eases;
import com.lowdragmc.shimmer.client.shader.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class DimensionalFocusEngravingArrayRenderer
extends WorkableCasingMachineRenderer {
    public DimensionalFocusEngravingArrayRenderer() {
        super(GTCEu.id((String)"block/casings/gcym/laser_safe_engraving_casing"), GTCEu.id((String)"block/multiblock/fusion_reactor"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(BlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        CoilCrossRecipeMultiblockMachine machine;
        MetaMachineBlockEntity machineBlockEntity;
        MetaMachine metaMachine;
        if (blockEntity instanceof MetaMachineBlockEntity && (metaMachine = (machineBlockEntity = (MetaMachineBlockEntity)blockEntity).getMetaMachine()) instanceof CoilCrossRecipeMultiblockMachine && (machine = (CoilCrossRecipeMultiblockMachine)metaMachine).isFormed() && (machine.getRecipeLogic().isWorking() || blockEntity.m_58904_() instanceof TrackedDummyWorld)) {
            if (GTCEu.Mods.isShimmerLoaded() && !(blockEntity.m_58904_() instanceof TrackedDummyWorld)) {
                PoseStack finalStack = RenderUtils.copyPoseStack((PoseStack)stack);
                BloomUtils.entityBloom(source -> DimensionalFocusEngravingArrayRenderer.renderLightRing(machine, partialTicks, finalStack, source));
            } else {
                DimensionalFocusEngravingArrayRenderer.renderLightRing(machine, partialTicks, stack, buffer);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderLightRing(CoilCrossRecipeMultiblockMachine machine, float partialTicks, PoseStack stack, MultiBufferSource buffer) {
        float x = 0.5f;
        float y = -17.5f;
        float z = 0.5f;
        switch (machine.getFrontFacing()) {
            case NORTH: {
                z = 22.5f;
                break;
            }
            case SOUTH: {
                z = -21.5f;
                break;
            }
            case WEST: {
                x = 22.5f;
                break;
            }
            case EAST: {
                x = -21.5f;
            }
        }
        stack.m_252880_(x, y, z);
        int color = ColorUtils.blendColor((int)Objects.requireNonNull(machine.getCoilType().getMaterial()).getMaterialRGB(), (int)-1, (float)(0.1f + Eases.EaseQuadIn.getInterpolation(Math.abs((float)Math.abs(machine.getOffsetTimer() % 100) + partialTicks - 50.0f) / 50.0f)));
        float a2 = ColorUtils.alpha((int)color);
        float r = ColorUtils.red((int)color);
        float g = ColorUtils.green((int)color);
        float b2 = ColorUtils.blue((int)color);
        DimensionalFocusEngravingArrayRenderer.a(stack, buffer, a2, r, g, b2);
        stack.m_252781_(Axis.f_252495_.m_252977_(90.0f));
        DimensionalFocusEngravingArrayRenderer.a(stack, buffer, a2, r, g, b2);
        stack.m_252781_(Axis.f_252393_.m_252977_(90.0f));
        RenderHelper.renderCylinder(stack, buffer.m_6299_(GTRenderTypes.getLightRing()), 0.0f, 0.0f, 0.0f, 0.5f, 8.0f, 10, r, g, b2, a2);
        stack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
        RenderHelper.renderCylinder(stack, buffer.m_6299_(GTRenderTypes.getLightRing()), 0.0f, 0.0f, 0.0f, 0.5f, 8.0f, 10, r, g, b2, a2);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void a(PoseStack stack, MultiBufferSource buffer, float a2, float r, float g, float b2) {
        RenderHelper.renderCylinder(stack, buffer.m_6299_(GTRenderTypes.getLightRing()), 0.0f, 0.0f, 0.0f, 0.5f, 8.0f, 10, r, g, b2, a2);
        stack.m_252781_(Axis.f_252495_.m_252977_(90.0f));
        RenderHelper.renderCylinder(stack, buffer.m_6299_(GTRenderTypes.getLightRing()), 0.0f, 0.0f, 0.0f, 0.5f, 8.0f, 10, r, g, b2, a2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasTESR(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isGlobalRenderer(BlockEntity blockEntity) {
        return true;
    }
}

