/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.client.renderer.machine.TieredHullMachineRenderer;
import com.gregtechceu.gtceu.client.util.StaticFaceBakery;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.research.HPCAMachine;
import com.gtocore.common.machine.multiblock.part.research.ExResearchBasePartMachine;
import com.gtolib.GTOCore;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ExResearchPartRenderer
extends TieredHullMachineRenderer {
    private final ResourceLocation texture;
    private final ResourceLocation activeTexture;
    private final ResourceLocation activeEmissiveTexture;
    private final ResourceLocation damagedTexture;
    private final ResourceLocation damagedActiveTexture;
    private final ResourceLocation damagedActiveEmissiveTexture;

    public ExResearchPartRenderer(int tire, ResourceLocation texture, @Nullable ResourceLocation activeTexture, @Nullable ResourceLocation activeEmissiveTexture, @Nullable ResourceLocation damagedTexture, @Nullable ResourceLocation damagedActiveTexture, @Nullable ResourceLocation damagedActiveEmissiveTexture) {
        super(7, switch (tire) {
            case 1 -> GTCEu.id((String)"block/computer_casing");
            case 2 -> GTCEu.id((String)"block/advanced_computer_casing");
            case 3 -> GTOCore.id((String)"block/variant/biocomputer_shell_active");
            case 4 -> GTOCore.id((String)"block/graviton_computer_casing");
            default -> GTOCore.id((String)"block/variant/biocomputer_shell_active");
        });
        this.texture = texture;
        this.activeTexture = activeTexture;
        this.activeEmissiveTexture = activeEmissiveTexture;
        this.damagedTexture = damagedTexture;
        this.damagedActiveTexture = damagedActiveTexture;
        this.damagedActiveEmissiveTexture = damagedActiveEmissiveTexture;
    }

    public void renderMachine(List<BakedQuad> quads, MachineDefinition definition, @Nullable MetaMachine machine, Direction frontFacing, @Nullable Direction side, RandomSource rand, @Nullable Direction modelFacing, ModelState modelState) {
        super.renderMachine(quads, definition, machine, frontFacing, side, rand, modelFacing, modelState);
        if (machine instanceof ExResearchBasePartMachine) {
            ResourceLocation texture;
            IWorkable workable;
            IMultiController controller;
            ExResearchBasePartMachine hpcaComponent = (ExResearchBasePartMachine)machine;
            ResourceLocation emissiveTexture = null;
            IMultiController iMultiController = controller = hpcaComponent.isFormed() ? hpcaComponent.getController() : null;
            if (controller != null && controller instanceof IWorkable && (workable = (IWorkable)controller).isActive()) {
                if (hpcaComponent.isDamaged()) {
                    texture = this.damagedActiveTexture;
                    emissiveTexture = this.damagedActiveEmissiveTexture;
                } else {
                    texture = this.activeTexture;
                    emissiveTexture = this.activeEmissiveTexture;
                }
            } else {
                texture = hpcaComponent.isDamaged() ? this.damagedTexture : this.texture;
            }
            if (texture == null) {
                texture = this.texture;
            }
            if (texture != null) {
                Direction facing = frontFacing;
                if (controller instanceof HPCAMachine) {
                    HPCAMachine hpca = (HPCAMachine)controller;
                    facing = RelativeDirection.RIGHT.getRelative(hpca.getFrontFacing(), hpca.getUpwardsFacing(), hpca.isFlipped());
                }
                facing = ModelFactory.modelFacing((Direction)frontFacing, (Direction)facing);
                quads.add(StaticFaceBakery.bakeFace((AABB)StaticFaceBakery.SLIGHTLY_OVER_BLOCK, (Direction)facing, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)texture), (ModelState)modelState, (int)-1, (int)0, (boolean)true, (boolean)true));
                if (emissiveTexture != null) {
                    quads.add(StaticFaceBakery.bakeFace((AABB)StaticFaceBakery.SLIGHTLY_OVER_BLOCK, (Direction)facing, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)emissiveTexture), (ModelState)modelState, (int)-101, (int)15, (boolean)true, (boolean)false));
                }
            }
        } else {
            ResourceLocation texture = this.texture;
            if (texture != null) {
                quads.add(StaticFaceBakery.bakeFace((AABB)StaticFaceBakery.SLIGHTLY_OVER_BLOCK, (Direction)Direction.NORTH, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)texture), (ModelState)modelState, (int)-1, (int)0, (boolean)true, (boolean)true));
            }
        }
    }
}

