/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gtocore.client.renderer.machine.CustomPartRenderer;
import com.gtocore.client.renderer.machine.SpaceElevatorRenderer;
import com.gtocore.common.machine.multiblock.noenergy.HarmonyMachine;
import com.gtolib.GTOCore;
import com.gtolib.utils.ClientUtil;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Quaternionf;

public final class EyeOfHarmonyRenderer
extends CustomPartRenderer {
    private static final ResourceLocation SPACE_MODEL = GTOCore.id((String)"obj/space");
    static final ResourceLocation STAR_MODEL = GTOCore.id((String)"obj/star");
    private static final List<ResourceLocation> ORBIT_OBJECTS = List.of(GTOCore.id((String)"obj/the_nether"), GTOCore.id((String)"obj/overworld"), GTOCore.id((String)"obj/the_end"));

    public EyeOfHarmonyRenderer() {
        super(GTOCore.id((String)"block/casings/dimensionally_transcendent_casing"), GTOCore.id((String)"block/multiblock/cosmos_simulation"), GTCEu.id((String)"block/casings/hpca/high_power_casing"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(BlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        HarmonyMachine machine;
        MetaMachineBlockEntity machineBlockEntity;
        MetaMachine metaMachine;
        if (blockEntity instanceof MetaMachineBlockEntity && (metaMachine = (machineBlockEntity = (MetaMachineBlockEntity)blockEntity).getMetaMachine()) instanceof HarmonyMachine && (machine = (HarmonyMachine)metaMachine).isFormed() && (machine.isActive() || blockEntity.m_58904_() instanceof TrackedDummyWorld)) {
            float tick = (float)machine.getOffsetTimer() + partialTicks;
            double x = 0.5;
            double y = 0.5;
            double z = 0.5;
            switch (machine.getFrontFacing()) {
                case NORTH: {
                    z = 16.5;
                    break;
                }
                case SOUTH: {
                    z = -15.5;
                    break;
                }
                case WEST: {
                    x = 16.5;
                    break;
                }
                case EAST: {
                    x = -15.5;
                }
            }
            poseStack.m_85836_();
            poseStack.m_85837_(x, y, z);
            EyeOfHarmonyRenderer.renderStar(tick, poseStack, buffer);
            EyeOfHarmonyRenderer.renderOrbitObjects(tick, poseStack, buffer, x, y, z);
            EyeOfHarmonyRenderer.renderOuterSpaceShell(poseStack, buffer);
            poseStack.m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderStar(float tick, PoseStack poseStack, MultiBufferSource buffer) {
        poseStack.m_85836_();
        poseStack.m_85841_(0.02f, 0.02f, 0.02f);
        poseStack.m_252781_(new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 1.0f, tick / 2.0f % 360.0f));
        ClientUtil.modelRenderer().renderModel(poseStack.m_85850_(), buffer.m_6299_(RenderType.m_110466_()), null, ClientUtil.getBakedModel((ResourceLocation)STAR_MODEL), 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, RenderType.m_110466_());
        poseStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderOrbitObjects(float tick, PoseStack poseStack, MultiBufferSource buffer, double x, double y, double z) {
        for (int a2 = 1; a2 < 4; ++a2) {
            float scale = 0.007f + 0.003f * (float)a2;
            poseStack.m_85836_();
            poseStack.m_85841_(scale, scale, scale);
            poseStack.m_252781_(new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 1.0f, tick * 1.5f / (float)a2 % 360.0f));
            poseStack.m_85837_(x + (double)(a2 * 100 + 160) * Math.sin((double)(tick * (float)a2 / 80.0f) + 0.4), y, z + (double)(a2 * 100 + 160) * Math.cos((double)(tick * (float)a2 / 80.0f) + 0.4));
            ClientUtil.modelRenderer().renderModel(poseStack.m_85850_(), buffer.m_6299_(RenderType.m_110451_()), null, ClientUtil.getBakedModel((ResourceLocation)ORBIT_OBJECTS.get(a2 - 1)), 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, RenderType.m_110451_());
            poseStack.m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderOuterSpaceShell(PoseStack poseStack, MultiBufferSource buffer) {
        float scale = 0.175f;
        SpaceElevatorRenderer.RendererModel(poseStack, buffer, scale, SPACE_MODEL);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onAdditionalModel(Consumer<ResourceLocation> registry) {
        super.onAdditionalModel(registry);
        registry.accept(SPACE_MODEL);
        registry.accept(STAR_MODEL);
        registry.accept(ORBIT_OBJECTS.get(0));
        registry.accept(ORBIT_OBJECTS.get(1));
        registry.accept(ORBIT_OBJECTS.get(2));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasTESR(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isGlobalRenderer(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getViewDistance() {
        return 128;
    }
}

