/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.model.WorkableOverlayModel;
import com.gregtechceu.gtceu.client.renderer.machine.MachineRenderer;
import com.gtocore.integration.ae.MeWirelessConnectMachine;
import com.gtolib.GTOCore;
import com.lowdragmc.lowdraglib.client.bakedpipeline.Quad;
import com.lowdragmc.lowdraglib.client.bakedpipeline.QuadTransformers;
import com.lowdragmc.lowdraglib.client.renderer.impl.IModelRenderer;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class MeWirelessConnectMachineRenderer
extends MachineRenderer {
    public static final ResourceLocation ME_OVERLAY = GTOCore.id((String)"block/machines/me_wireless");
    public static final ResourceLocation ME_MODEL = GTOCore.id((String)"block/machine/part/me_wireless");
    protected final IModelRenderer activeOverlayModel;
    protected final WorkableOverlayModel overlayModel = new WorkableOverlayModel(ME_OVERLAY);
    public static final float OVERLAY_QUADS_OFFSET = 0.0035f;
    public static final float OVERLAY_QUADS_OFFSET_OUTER = 0.004f;

    public MeWirelessConnectMachineRenderer() {
        super(GTCEu.id((String)"block/high_power_casing"));
        this.activeOverlayModel = new IModelRenderer(ME_MODEL);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderMachine(List<BakedQuad> quads, MachineDefinition definition, @Nullable MetaMachine machine, Direction frontFacing, @Nullable Direction side, RandomSource rand, Direction modelFacing, ModelState modelState) {
        super.renderMachine(quads, definition, machine, frontFacing, side, rand, modelFacing, modelState);
        if (machine instanceof MeWirelessConnectMachine) {
            MeWirelessConnectMachine me = (MeWirelessConnectMachine)machine;
            this.overlayModel.bakeQuads(side, modelState, me.isOnline(), true).forEach(quad -> quads.add(Quad.from((BakedQuad)quad, (float)0.004f).rebake()));
            if (me.isOnline()) {
                this.activeOverlayModel.getRotatedModel(frontFacing).m_213637_(definition.defaultBlockState(), side, rand).forEach(quad -> {
                    QuadTransformers.settingEmissivity((int)15).processInPlace(quad);
                    quads.add(Quad.from((BakedQuad)quad, (float)0.0035f).rebake());
                });
            }
        } else {
            this.overlayModel.bakeQuads(side, modelState, false, false).forEach(quad -> quads.add(Quad.from((BakedQuad)quad, (float)0.0035f).rebake()));
        }
    }

    public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
        super.onPrepareTextureAtlas(atlasName, register);
        if (atlasName.equals((Object)TextureAtlas.f_118259_)) {
            this.overlayModel.registerTextureAtlas(register);
            Stream.of("top", "bottom", "side").forEach(side -> register.accept(GTOCore.id((String)("block/machines/me_wireless/" + side))));
        }
    }
}

