/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.client.renderer.machine.MachineRenderer;
import com.gregtechceu.gtceu.client.util.StaticFaceBakery;
import com.gtocore.common.machine.monitor.DisplayComponent;
import com.gtocore.common.machine.monitor.IDisplayComponent;
import com.gtocore.common.machine.monitor.IMonitor;
import com.gtocore.common.machine.monitor.Manager;
import com.gtocore.config.GTOConfig;
import com.gtolib.GTOCore;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class MonitorRenderer
extends MachineRenderer {
    public static final ResourceLocation MONITOR_OVERLAY = GTOCore.id((String)"block/overlay/machine/overlay_monitor");
    public static final ResourceLocation MONITOR_OVERLAY_FULL_CTM = GTOCore.id((String)"block/overlay/machine/overlay_monitor_full_ctm");
    private static final Map<BlockEntity, Manager.GridNetwork> renderedThisTick = new ConcurrentHashMap<BlockEntity, Manager.GridNetwork>();
    public static final Map<Manager.GridFacedPoint, Manager.GridNetwork> gridToNetworkCLIENT = new ConcurrentHashMap<Manager.GridFacedPoint, Manager.GridNetwork>();
    private static final float MARGIN = 0.15f;
    private static final int FULL_CTM_WIDTH = 64;
    private static final int FULL_CTM_HEIGHT = 64;

    public MonitorRenderer() {
        super(GTCEu.id((String)"block/cube/tinted/all"));
        this.setTextureOverride(Map.of("all", GTCEu.id((String)"block/casings/solid/machine_casing_solid_steel")));
    }

    public void renderMachine(List<BakedQuad> quads, MachineDefinition definition, @Nullable MetaMachine machine, Direction frontFacing, @Nullable Direction side, RandomSource rand, Direction modelFacing, ModelState modelState) {
        super.renderMachine(quads, definition, machine, frontFacing, side, rand, modelFacing, modelState);
        if (!(machine instanceof IMonitor)) {
            quads.add(StaticFaceBakery.bakeFace((Direction)frontFacing, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)MONITOR_OVERLAY)));
            return;
        }
        IMonitor monitor = (IMonitor)machine;
        Manager.MonitorCTM ctm = Manager.MonitorCTM.getConnection(monitor.getFrontFacing(), monitor.getPos(), monitor.getLevel());
        Direction trueFacing = RelativeDirection.FRONT.getRelative(machine.getFrontFacing(), machine.getUpwardsFacing(), false);
        trueFacing = ModelFactory.modelFacing((Direction)frontFacing, (Direction)trueFacing);
        AABB cube = StaticFaceBakery.SLIGHTLY_OVER_BLOCK;
        quads.add(StaticFaceBakery.bakeQuad((Vector3f)new Vector3f((float)cube.f_82288_ * 16.0f, (float)cube.f_82289_ * 16.0f, (float)cube.f_82290_ * 16.0f), (Vector3f)new Vector3f((float)cube.f_82291_ * 16.0f, (float)cube.f_82292_ * 16.0f, (float)cube.f_82293_ * 16.0f), (BlockElementFace)new BlockElementFace(null, -1, "", new BlockFaceUV(new float[]{(float)ctm.getU() / 64.0f * 16.0f, (float)ctm.getV() / 64.0f * 16.0f, ((float)ctm.getU() + 16.0f) / 64.0f * 16.0f, ((float)ctm.getV() + 16.0f) / 64.0f * 16.0f}, 0)), (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)MONITOR_OVERLAY_FULL_CTM), (Direction)trueFacing, (ModelState)ModelFactory.getRotation((Direction)frontFacing), null, (boolean)true, (int)0));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onAdditionalModel(Consumer<ResourceLocation> registry) {
        super.onAdditionalModel(registry);
        registry.accept(GTOCore.id((String)"obj/neutron_star"));
    }

    public boolean isGlobalRenderer(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasTESR(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(BlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Manager.GridNetwork network;
        IMonitor monitor;
        MetaMachineBlockEntity holder;
        MetaMachine metaMachine;
        if (blockEntity instanceof MetaMachineBlockEntity && (metaMachine = (holder = (MetaMachineBlockEntity)blockEntity).getMetaMachine()) instanceof IMonitor && (monitor = (IMonitor)metaMachine).getLevel() != null && (network = Manager.GridNetwork.fromClientBlock(monitor.getFrontFacing(), monitor.getPos(), monitor.getLevel())) != null && (renderedThisTick.containsKey(blockEntity) || renderedThisTick.values().stream().noneMatch(n -> n.equals(network)))) {
            renderedThisTick.put(blockEntity, network);
            stack.m_85836_();
            BlockPos pos = monitor.getPos();
            if (GTOConfig.INSTANCE.dev) {
                VoxelShape box = Shapes.m_83064_((AABB)network.aabb());
                LevelRenderer.m_285900_((PoseStack)stack, (VertexConsumer)buffer.m_6299_(RenderType.m_110504_()), (VoxelShape)box, (double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (boolean)false);
            }
            Direction front = monitor.getFrontFacing();
            float yaw = front.m_122435_() + 180.0f;
            float pitch = MonitorRenderer.toPitchAngle(front);
            stack.m_252880_((float)(network.getOriginPos().m_123341_() - pos.m_123341_()) + (front == Direction.WEST ? -0.01f : 1.01f) + (front == Direction.SOUTH ? -0.02f : 0.0f), (float)(network.getOriginPos().m_123342_() - pos.m_123342_()) + (front == Direction.DOWN ? -0.01f : 1.01f), (float)(network.getOriginPos().m_123343_() - pos.m_123343_()) + (front == Direction.NORTH ? -0.01f : 1.01f) + (front == Direction.WEST ? -0.02f : 0.0f));
            stack.m_252781_(Axis.f_252392_.m_252977_(yaw));
            stack.m_252781_(Axis.f_252529_.m_252977_(pitch));
            Font font = Minecraft.m_91087_().f_91062_;
            List<IDisplayComponent> info = network.getForDisplay();
            if (info.isEmpty()) {
                info.add(DisplayComponent.text(GTOCore.id((String)"null"), Component.m_237115_((String)"gtocore.machine.monitor.no_information").m_7532_()));
            }
            stack.m_85836_();
            stack.m_252880_(switch (front) {
                case Direction.WEST, Direction.SOUTH -> 0.85f;
                case Direction.EAST, Direction.NORTH -> (float)(network.width3D() - 1) - 0.15f;
                default -> 0.0f;
            }, (float)(network.height3D() - 1) - 0.15f, 0.0f);
            float factor = MonitorRenderer.getGlobalScaleFactor(info, (float)network.width3D() - 0.3f, (float)network.height3D() - 0.3f);
            stack.m_85841_(-factor, -factor, -factor);
            int cumulatedHeight = 0;
            int lastLineX = 0;
            for (IDisplayComponent iDisplayComponent : info) {
                if (GTOConfig.INSTANCE.dev) {
                    LevelRenderer.m_109608_((PoseStack)stack, (VertexConsumer)buffer.m_6299_(RenderType.m_110504_()), (double)0.0, (double)cumulatedHeight, (double)0.0, (double)iDisplayComponent.getVisualWidth(), (double)(cumulatedHeight + iDisplayComponent.getVisualHeight()), (double)0.0, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                }
                switch (iDisplayComponent.getDisplayType()) {
                    case STYLED_TEXT: {
                        FormattedCharSequence text = iDisplayComponent.getDisplayValue();
                        font.m_272191_(text, 0.0f, (float)cumulatedHeight, -1, false, stack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                        break;
                    }
                    case CUSTOM_RENDERER: {
                        stack.m_85836_();
                        iDisplayComponent.renderDisplay(network, blockEntity, partialTicks, stack, buffer, combinedLight, combinedOverlay, lastLineX, cumulatedHeight);
                        stack.m_85849_();
                    }
                }
                cumulatedHeight += iDisplayComponent.getVisualHeight() + 2;
                lastLineX = iDisplayComponent.getVisualWidth();
            }
            stack.m_85849_();
            stack.m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static float toPitchAngle(Direction dir) {
        return switch (dir) {
            case Direction.DOWN -> 90.0f;
            case Direction.UP -> 270.0f;
            default -> 0.0f;
        };
    }

    private static float getGlobalScaleFactor(List<IDisplayComponent> info, float displayWidth, float displayHeight) {
        if (info == null || info.isEmpty()) {
            return 1.0f;
        }
        int maxWidth = info.stream().mapToInt(IDisplayComponent::getVisualWidth).max().orElse(0);
        int maxHeight = info.stream().mapToInt(IDisplayComponent::getVisualHeight).sum() + info.size() * 2;
        float scaleX = displayWidth / Math.max((float)maxWidth, 0.01f);
        float scaleY = displayHeight / Math.max((float)maxHeight, 0.01f);
        return Math.min(scaleX, scaleY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
        super.onPrepareTextureAtlas(atlasName, register);
        if (atlasName.equals((Object)TextureAtlas.f_118259_)) {
            register.accept(MONITOR_OVERLAY);
            register.accept(MONITOR_OVERLAY_FULL_CTM);
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    @OnlyIn(value=Dist.CLIENT)
    public static class RenderedCacheClearer {
        @SubscribeEvent
        public static void clearRenderCache(ScreenEvent.Render.Pre event) {
            renderedThisTick.clear();
        }
    }
}

