/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableCasingMachineRenderer;
import com.gtocore.client.renderer.machine.IHeaterRenderer;
import com.gtocore.common.machine.multiblock.noenergy.PrimitiveDistillationTowerMachine;
import com.gtolib.GTOCore;
import com.lowdragmc.lowdraglib.client.bakedpipeline.Quad;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class PrimitiveDistillationRenderer
extends WorkableCasingMachineRenderer
implements IHeaterRenderer {
    private static final ResourceLocation CASING = GTCEu.id((String)"block/casings/steam/steel/side");
    private static final ResourceLocation WORKABLE_MODEL = GTOCore.id((String)"block/multiblock/primitive_distillation_tower");
    private static final ResourceLocation TANK_OVERLAY = GTOCore.id((String)"block/multiblock/primitive_distillation_tower/tank");
    private static final ResourceLocation TANK_BG_OVERLAY = GTOCore.id((String)"block/multiblock/primitive_distillation_tower/tank_bg");
    private static final ResourceLocation WATER_STILL = GTOCore.id((String)"block/multiblock/primitive_distillation_tower/water_still");
    private static final ResourceLocation STEAM_STILL = GTOCore.id((String)"block/multiblock/primitive_distillation_tower/steam_still");

    public PrimitiveDistillationRenderer() {
        super(CASING, WORKABLE_MODEL);
    }

    public void renderMachine(List<BakedQuad> quads, MachineDefinition definition, @Nullable MetaMachine machine, Direction frontFacing, @Nullable Direction side, RandomSource rand, Direction modelFacing, ModelState modelState) {
        this.renderHeater(quads, definition, machine, frontFacing, side, rand, modelFacing, modelState);
        super.renderMachine(quads, definition, machine, frontFacing, side, rand, modelFacing, modelState);
    }

    @Override
    public void renderHeater(List<BakedQuad> quads, MachineDefinition definition, @Nullable MetaMachine machine, Direction frontFacing, @Nullable Direction side, RandomSource rand, Direction modelFacing, ModelState modelState) {
        PrimitiveDistillationTowerMachine distillation;
        block5: {
            block4: {
                if (!(machine instanceof PrimitiveDistillationTowerMachine)) break block4;
                distillation = (PrimitiveDistillationTowerMachine)machine;
                if (side != null && distillation.isFormed()) break block5;
            }
            return;
        }
        int temp = distillation.getHeat();
        int maxTemp = PrimitiveDistillationTowerMachine.getMaxHeat();
        float tempRatio = Math.min(1.0f, (float)temp / (float)maxTemp);
        Direction direction = RelativeDirection.FRONT.getRelative(machine.getFrontFacing(), machine.getUpwardsFacing(), false);
        direction = ModelFactory.modelFacing((Direction)frontFacing, (Direction)direction);
        quads.add(PrimitiveDistillationRenderer.shiftQuad(IHeaterRenderer.bakeQuad(IHeaterRenderer.Wrapper.layer0, 1.0f, direction, IHeaterRenderer.Wrapper.BG_OVERLAY, modelState, false, -1, false)));
        quads.add(PrimitiveDistillationRenderer.shiftQuad(IHeaterRenderer.bakeQuad(IHeaterRenderer.Wrapper.layer1, tempRatio, direction, IHeaterRenderer.Wrapper.TEMP_OVERLAY, modelState, true, -1, false)));
        quads.add(PrimitiveDistillationRenderer.shiftQuad(IHeaterRenderer.bakeQuad(IHeaterRenderer.Wrapper.layer2, 1.0f, direction, IHeaterRenderer.Wrapper.METER_OVERLAY, modelState, false, -1, false)));
        PrimitiveDistillationTowerMachine.WaterState waterState = distillation.getWaterState();
        float waterLevel = Mth.m_14036_((float)((float)distillation.getWaterLevel() / (float)PrimitiveDistillationTowerMachine.getMaxWaterUsage()), (float)0.0f, (float)1.0f);
        ResourceLocation waterLayer = waterState.overlay;
        quads.add(PrimitiveDistillationRenderer.shiftQuad(IHeaterRenderer.bakeQuad(IHeaterRenderer.Wrapper.layer0, 1.0f, direction, TANK_BG_OVERLAY, modelState, false, -1, false)));
        if (waterLayer != null) {
            quads.add(PrimitiveDistillationRenderer.shiftQuad(IHeaterRenderer.bakeQuad(IHeaterRenderer.Wrapper.layer1, waterState == PrimitiveDistillationTowerMachine.WaterState.IS_COOLING ? 1.0f : waterLevel, direction, waterLayer, modelState, true, -1, false)));
        }
        quads.add(PrimitiveDistillationRenderer.shiftQuad(IHeaterRenderer.bakeQuad(IHeaterRenderer.Wrapper.layer2, 1.0f, direction, TANK_OVERLAY, modelState, false, -1, false)));
    }

    private static BakedQuad shiftQuad(BakedQuad quad) {
        Quad shiftedQuad = Quad.from((BakedQuad)quad);
        for (int i = 0; i < 4; ++i) {
            Vector3f pos = shiftedQuad.getVert(i);
            shiftedQuad = shiftedQuad.withVert(i, new Vector3f(pos.x(), pos.y() + 1.0f, pos.z()));
        }
        return shiftedQuad.rebake();
    }
}

