/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.client.renderer.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableCasingMachineRenderer;
import com.gtocore.client.renderer.GTORenderTypes;
import com.gtocore.client.renderer.RenderHelper;
import com.gtocore.common.machine.multiblock.electric.space.SpaceElevatorMachine;
import com.gtocore.common.machine.multiblock.electric.space.SuperSpaceElevatorMachine;
import com.gtolib.GTOCore;
import com.gtolib.utils.ClientUtil;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;

public final class SpaceElevatorRenderer
extends WorkableCasingMachineRenderer {
    private static final ResourceLocation CLIMBER_MODEL = GTOCore.id((String)"obj/climber");

    public SpaceElevatorRenderer() {
        super(GTOCore.id((String)"block/casings/space_elevator_mechanical_casing"), GTCEu.id((String)"block/multiblock/data_bank"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(BlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        SpaceElevatorMachine machine;
        MetaMachineBlockEntity machineBlockEntity;
        MetaMachine metaMachine;
        if (blockEntity instanceof MetaMachineBlockEntity && (metaMachine = (machineBlockEntity = (MetaMachineBlockEntity)blockEntity).getMetaMachine()) instanceof SpaceElevatorMachine && (machine = (SpaceElevatorMachine)metaMachine).isFormed() && (machine.getSpoolCount() >= machine.getMaxSpoolCount() || blockEntity.m_58904_() instanceof TrackedDummyWorld)) {
            boolean Super = machine instanceof SuperSpaceElevatorMachine;
            double x = 0.5;
            double y = 1.0;
            double z = 0.5;
            if (Super) {
                switch (machine.getFrontFacing()) {
                    case NORTH: {
                        z = 120.5;
                        break;
                    }
                    case SOUTH: {
                        z = -119.5;
                        break;
                    }
                    case WEST: {
                        x = 120.5;
                        break;
                    }
                    case EAST: {
                        x = -119.5;
                    }
                }
            } else {
                switch (machine.getFrontFacing()) {
                    case NORTH: {
                        z = 3.5;
                        break;
                    }
                    case SOUTH: {
                        z = -2.5;
                        break;
                    }
                    case WEST: {
                        x = 3.5;
                        break;
                    }
                    case EAST: {
                        x = -2.5;
                    }
                }
            }
            poseStack.m_85836_();
            RenderHelper.renderCylinder(poseStack, buffer.m_6299_(GTORenderTypes.LIGHT_CYLINDER), (float)x, (float)(y - 2.0), (float)z, Super ? 1.6f : 0.3f, Super ? 600.0f : 360.0f, 10, 0.0f, 0.0f, 0.0f, 255.0f);
            poseStack.m_85837_(x, y + machine.getHigh(), z);
            SpaceElevatorRenderer.RendererModel(poseStack, buffer, Super ? 20.0f : 4.0f, CLIMBER_MODEL);
            poseStack.m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static void RendererModel(PoseStack poseStack, MultiBufferSource buffer, float scale, ResourceLocation climberModel) {
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, scale);
        ClientUtil.modelRenderer().renderModel(poseStack.m_85850_(), buffer.m_6299_(RenderType.m_110451_()), null, ClientUtil.getBakedModel((ResourceLocation)climberModel), 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, RenderType.m_110451_());
        poseStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onAdditionalModel(Consumer<ResourceLocation> registry) {
        super.onAdditionalModel(registry);
        registry.accept(CLIMBER_MODEL);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasTESR(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isGlobalRenderer(BlockEntity blockEntity) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getViewDistance() {
        return 256;
    }

    public boolean shouldRender(BlockEntity blockEntity, Vec3 cameraPos) {
        if (blockEntity instanceof MetaMachineBlockEntity) {
            SuperSpaceElevatorMachine machine;
            MetaMachineBlockEntity machineBlockEntity = (MetaMachineBlockEntity)blockEntity;
            MetaMachine metaMachine = machineBlockEntity.getMetaMachine();
            return metaMachine instanceof SuperSpaceElevatorMachine && (machine = (SuperSpaceElevatorMachine)metaMachine).isFormed() && (machine.getSpoolCount() >= machine.getMaxSpoolCount() || blockEntity.m_58904_() instanceof TrackedDummyWorld) || super.shouldRender(blockEntity, cameraPos);
        }
        return super.shouldRender(blockEntity, cameraPos);
    }
}

