/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.block;

import com.gtocore.data.tag.Tags;
import com.gtolib.GTOCore;
import com.gtolib.utils.register.BlockRegisterUtils;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.entry.BlockEntry;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.client.model.generators.ModelFile;

public class GlowingBlock
extends Block {
    static String[] num = new String[]{"\u2160", "\u2161", "\u2162", "\u2163", "\u2164", "\u2165", "\u2166", "\u2167", "\u2168", "\u2169", "\u216a", "\u216b"};

    public GlowingBlock(int lightLevel, MapColor color) {
        this(GlowingBlock.createDefaultProperties(), lightLevel, color);
    }

    public GlowingBlock(BlockBehaviour.Properties properties, int lightLevel, MapColor color) {
        super(properties.m_60953_(state -> GlowingBlock.validateLightLevel(lightLevel)).m_284180_(color));
    }

    private static BlockBehaviour.Properties createDefaultProperties() {
        return BlockBehaviour.Properties.m_284310_().m_284495_(state -> MapColor.f_283919_).m_60953_(state -> 0).m_60913_(4.0f, 8.0f).m_60918_(SoundType.f_56742_).m_280658_(NoteBlockInstrument.BASS).m_60999_();
    }

    private static int validateLightLevel(int level) {
        if (level < 0 || level > 15) {
            throw new IllegalArgumentException("Brightness level must be in the range 0-15");
        }
        return level;
    }

    public static BlockEntry<GlowingBlock>[] createStarStone() {
        BlockEntry[] StarStone = new BlockEntry[num.length];
        for (int i = 0; i < num.length; ++i) {
            int finalI = i;
            StarStone[i] = ((BlockBuilder)BlockRegisterUtils.block((String)("star_stone_" + (i + 1)), (String)("\u661f\u8fb0\u77f3 " + num[i]), p -> new GlowingBlock(finalI + 4, MapColor.f_283919_)).lang("Star Stone " + num[i]).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().cubeAll("star_stone_" + (finalI + 1), GTOCore.id((String)"block/star_stone")))).tag(new TagKey[]{BlockTags.f_144282_}).item(BlockItem::new).tag(new TagKey[]{Tags.STAR_STONE}).build()).register();
        }
        return StarStone;
    }
}

