/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.cover;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gtolib.api.machine.feature.IPowerAmplifierMachine;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public final class PowerAmplifierCover
extends CoverBehavior {
    private final double multiplier;

    public PowerAmplifierCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide, int tier) {
        super(definition, coverHolder, attachedSide);
        this.multiplier = PowerAmplifierCover.getMultiplier(tier);
    }

    public static double getMultiplier(int tier) {
        return 1.0 + (double)tier * 0.5;
    }

    public boolean canAttach() {
        IPowerAmplifierMachine powerAmplifierMachine;
        MetaMachine metaMachine;
        return super.canAttach() && (metaMachine = this.getMachine()) instanceof IPowerAmplifierMachine && (powerAmplifierMachine = (IPowerAmplifierMachine)metaMachine).gtolib$noPowerAmplifier();
    }

    public void onAttached(@NotNull ItemStack itemStack, @NotNull ServerPlayer player) {
        super.onAttached(itemStack, player);
        this.updateCoverSub();
    }

    public void onLoad() {
        super.onLoad();
        this.updateCoverSub();
    }

    public void onRemoved() {
        super.onRemoved();
        MetaMachine machine = this.getMachine();
        if (machine instanceof IPowerAmplifierMachine) {
            IPowerAmplifierMachine amplifierMachine = (IPowerAmplifierMachine)machine;
            amplifierMachine.gtolib$setHasPowerAmplifier(false);
            amplifierMachine.gtolib$setPowerAmplifier(1.0);
        }
    }

    private void updateCoverSub() {
        Level level = this.coverHolder.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.m_7654_().m_6937_((Runnable)new TickTask(1, () -> {
                IPowerAmplifierMachine amplifierMachine;
                MetaMachine machine = this.getMachine();
                if (machine instanceof IPowerAmplifierMachine && (amplifierMachine = (IPowerAmplifierMachine)machine).gtolib$noPowerAmplifier()) {
                    amplifierMachine.gtolib$setHasPowerAmplifier(true);
                    amplifierMachine.gtolib$setPowerAmplifier(this.multiplier);
                }
            }));
        }
    }

    @Nullable
    private MetaMachine getMachine() {
        return MetaMachine.getMachine((BlockEntity)this.coverHolder.holder());
    }
}

