/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.data;

import com.fast.fastcollection.O2OOpenCacheHashMap;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockfluid.BedrockFluidDefinition;
import com.gregtechceu.gtceu.common.data.GTBedrockFluids;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gtocore.common.data.GTOMaterials;
import com.gtolib.GTOCore;
import com.gtolib.api.data.GTODimensions;
import com.gtolib.api.lang.CNEN;
import com.gtolib.utils.RLUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public final class GTOBedrockFluids {
    public static final Map<String, CNEN> LANG = GTCEu.isDataGen() ? new O2OOpenCacheHashMap() : null;
    public static final Map<ResourceKey<Level>, List<FluidStack>> ALL_BEDROCK_FLUID = new O2OOpenCacheHashMap();
    private static final BedrockFluidDefinition VOID_HEAVY_OIL = GTOBedrockFluids.create(GTCEu.id((String)"void_heavy_oil_deposit"), "\u865a\u7a7a\u91cd\u6cb9\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.OilHeavy).getFluid()).weight(15).yield(100, 200).depletionAmount(1).depletionChance(100).depletedYield(20).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.VOID)));
    private static final BedrockFluidDefinition VOID_LIGHT_OIL = GTOBedrockFluids.create(GTCEu.id((String)"void_light_oil_deposit"), "\u865a\u7a7a\u8f7b\u6cb9\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.OilLight).getFluid()).weight(25).yield(175, 300).depletionAmount(1).depletionChance(100).depletedYield(25).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.VOID)));
    private static final BedrockFluidDefinition VOID_NATURAL_GAS = GTOBedrockFluids.create(GTCEu.id((String)"void_natural_gas_deposit"), "\u865a\u7a7a\u5929\u7136\u6c14\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.NaturalGas).getFluid()).weight(15).yield(100, 175).depletionAmount(1).depletionChance(100).depletedYield(20).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.VOID)));
    private static final BedrockFluidDefinition VOID_OIL = GTOBedrockFluids.create(GTCEu.id((String)"void_oil_deposit"), "\u865a\u7a7a\u77f3\u6cb9\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.Oil).getFluid()).weight(20).yield(175, 300).depletionAmount(1).depletionChance(100).depletedYield(25).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.VOID)));
    private static final BedrockFluidDefinition VOID_RAW_OIL = GTOBedrockFluids.create(GTCEu.id((String)"void_raw_oil_deposit"), "\u865a\u7a7a\u539f\u6cb9\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.RawOil).getFluid()).weight(20).yield(200, 300).depletionAmount(1).depletionChance(100).depletedYield(25).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.VOID)));
    private static final BedrockFluidDefinition VOID_ALT_WATER = GTOBedrockFluids.create(GTCEu.id((String)"void_salt_water_deposit"), "\u865a\u7a7a\u76d0\u6c34\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.SaltWater).getFluid()).weight(10).yield(50, 100).depletionAmount(1).depletionChance(100).depletedYield(15).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.VOID)));
    private static final BedrockFluidDefinition FLAT_HEAVY_OIL = GTOBedrockFluids.create(GTCEu.id((String)"flat_heavy_oil_deposit"), "\u8d85\u5e73\u5766\u91cd\u6cb9\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.OilHeavy).getFluid()).weight(15).yield(100, 200).depletionAmount(1).depletionChance(100).depletedYield(20).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.FLAT)));
    private static final BedrockFluidDefinition FLAT_LIGHT_OIL = GTOBedrockFluids.create(GTCEu.id((String)"flat_light_oil_deposit"), "\u8d85\u5e73\u5766\u8f7b\u6cb9\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.OilLight).getFluid()).weight(25).yield(175, 300).depletionAmount(1).depletionChance(100).depletedYield(25).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.FLAT)));
    private static final BedrockFluidDefinition FLAT_NATURAL_GAS = GTOBedrockFluids.create(GTCEu.id((String)"flat_natural_gas_deposit"), "\u8d85\u5e73\u5766\u5929\u7136\u6c14\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.NaturalGas).getFluid()).weight(15).yield(100, 175).depletionAmount(1).depletionChance(100).depletedYield(20).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.FLAT)));
    private static final BedrockFluidDefinition FLAT_OIL = GTOBedrockFluids.create(GTCEu.id((String)"flat_oil_deposit"), "\u8d85\u5e73\u5766\u77f3\u6cb9\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.Oil).getFluid()).weight(20).yield(175, 300).depletionAmount(1).depletionChance(100).depletedYield(25).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.FLAT)));
    private static final BedrockFluidDefinition FLAT_RAW_OIL = GTOBedrockFluids.create(GTCEu.id((String)"flat_raw_oil_deposit"), "\u8d85\u5e73\u5766\u539f\u6cb9\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.RawOil).getFluid()).weight(20).yield(200, 300).depletionAmount(1).depletionChance(100).depletedYield(25).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.FLAT)));
    private static final BedrockFluidDefinition FLAT_ALT_WATER = GTOBedrockFluids.create(GTCEu.id((String)"flat_salt_water_deposit"), "\u8d85\u5e73\u5766\u76d0\u6c34\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.SaltWater).getFluid()).weight(10).yield(50, 100).depletionAmount(1).depletionChance(100).depletedYield(15).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.FLAT)));
    private static final BedrockFluidDefinition HELIUM_3 = GTOBedrockFluids.create(GTCEu.id((String)"helium3_deposit"), "\u6c26-3\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.Helium3).getFluid()).weight(10).yield(50, 180).depletionAmount(1).depletionChance(100).depletedYield(40).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.MOON)));
    private static final BedrockFluidDefinition HELIUM = GTOBedrockFluids.create(GTCEu.id((String)"helium_deposit"), "\u6c26\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.Helium).getFluid()).weight(20).yield(50, 300).depletionAmount(1).depletionChance(100).depletedYield(40).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.MOON)));
    private static final BedrockFluidDefinition SULFURIC_ACID = GTOBedrockFluids.create(GTCEu.id((String)"sulfuric_acid_deposit"), "\u786b\u9178\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.SulfuricAcid).getFluid()).weight(20).yield(100, 250).depletionAmount(1).depletionChance(100).depletedYield(40).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.VENUS)));
    private static final BedrockFluidDefinition DEUTERIUM = GTOBedrockFluids.create(GTCEu.id((String)"deuterium_deposit"), "\u6c18\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.Deuterium).getFluid()).weight(15).yield(80, 300).depletionAmount(1).depletionChance(100).depletedYield(40).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.MERCURY)));
    private static final BedrockFluidDefinition RADON = GTOBedrockFluids.create(GTCEu.id((String)"radon_deposit"), "\u6c21\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.Radon).getFluid()).weight(20).yield(50, 80).depletionAmount(1).depletionChance(100).depletedYield(40).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.MARS)));
    private static final BedrockFluidDefinition CERES_RADON = GTOBedrockFluids.create(GTCEu.id((String)"ceres_radon_deposit"), "\u8c37\u795e\u661f\u6c21\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.Radon).getFluid()).weight(15).yield(100, 250).depletionAmount(1).depletionChance(100).depletedYield(40).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.CERES)));
    private static final BedrockFluidDefinition METHANE = GTOBedrockFluids.create(GTCEu.id((String)"methane_deposit"), "\u7532\u70f7\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.Methane).getFluid()).weight(20).yield(100, 250).depletionAmount(1).depletionChance(100).depletedYield(40).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.TITAN)));
    private static final BedrockFluidDefinition BENZENE = GTOBedrockFluids.create(GTCEu.id((String)"benzene_deposit"), "\u82ef\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.Benzene).getFluid()).weight(15).yield(60, 160).depletionAmount(1).depletionChance(100).depletedYield(40).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.TITAN)));
    private static final BedrockFluidDefinition CHARCOAL_BYPRODUCTS = GTOBedrockFluids.create(GTCEu.id((String)"charcoal_byproducts"), "\u6728\u70ad\u526f\u4ea7\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.CharcoalByproducts).getFluid()).weight(10).yield(80, 260).depletionAmount(1).depletionChance(100).depletedYield(40).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.TITAN)));
    private static final BedrockFluidDefinition COAL_GAS = GTOBedrockFluids.create(GTCEu.id((String)"coal_gas_deposit"), "\u7164\u6c14\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.CoalGas).getFluid()).weight(20).yield(100, 300).depletionAmount(1).depletionChance(100).depletedYield(40).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.IO)));
    private static final BedrockFluidDefinition NITRIC_ACID = GTOBedrockFluids.create(GTCEu.id((String)"nitric_acid_deposit"), "\u785d\u9178\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.NitricAcid).getFluid()).weight(20).yield(80, 300).depletionAmount(1).depletionChance(100).depletedYield(40).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.PLUTO)));
    private static final BedrockFluidDefinition HYDROCHLORIC_ACID = GTOBedrockFluids.create(GTCEu.id((String)"hydrochloric_acid_deposit"), "\u76d0\u9178\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.HydrochloricAcid).getFluid()).weight(20).yield(100, 350).depletionAmount(1).depletionChance(100).depletedYield(40).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.GANYMEDE)));
    private static final BedrockFluidDefinition CERES_XENON = GTOBedrockFluids.create(GTCEu.id((String)"ceres_xenon_deposit"), "\u6c19\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.Xenon).getFluid()).weight(20).yield(100, 250).depletionAmount(1).depletionChance(100).depletedYield(40).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.CERES)));
    private static final BedrockFluidDefinition CERES_KRYPTON = GTOBedrockFluids.create(GTCEu.id((String)"ceres_krypton_deposit"), "\u6c2a\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.Krypton).getFluid()).weight(20).yield(100, 250).depletionAmount(1).depletionChance(100).depletedYield(40).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.CERES)));
    private static final BedrockFluidDefinition CERES_NEON = GTOBedrockFluids.create(GTCEu.id((String)"ceres_neon_deposit"), "\u6c16\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.Neon).getFluid()).weight(20).yield(100, 250).depletionAmount(1).depletionChance(100).depletedYield(40).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.CERES)));
    private static final BedrockFluidDefinition FLUORINE = GTOBedrockFluids.create(GTCEu.id((String)"fluorine_deposit"), "\u6c1f\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.Fluorine).getFluid()).weight(10).yield(180, 320).depletionAmount(1).depletionChance(100).depletedYield(40).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.ENCELADUS)));
    private static final BedrockFluidDefinition CHLORINE = GTOBedrockFluids.create(GTCEu.id((String)"chlorine_deposit"), "\u6c2f\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTMaterials.Chlorine).getFluid()).weight(20).yield(180, 420).depletionAmount(1).depletionChance(100).depletedYield(40).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.ENCELADUS)));
    private static final BedrockFluidDefinition UNKNOWWATER = GTOBedrockFluids.create(GTCEu.id((String)"unknowwater_deposit"), "\u4e0d\u660e\u6db2\u4f53\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTOMaterials.UnknowWater).getFluid()).weight(20).yield(40, 60).depletionAmount(1).depletionChance(100).depletedYield(40).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.BARNARDA_C)));
    private static final BedrockFluidDefinition FRACTAL_PETAL_SOLVENT = GTOBedrockFluids.create(GTCEu.id((String)"fractal_petal_solvent_deposit"), "\u788e\u854a\u8c03\u548c\u6eb6\u5242\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTOMaterials.FractalPetalSolvent).getFluid()).weight(180).yield(10, 30).depletionAmount(1).depletionChance(100).depletedYield(5).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.ALFHEIM)));
    private static final BedrockFluidDefinition THE_WATER_FROM_THE_WELL_OF_WISDOM = GTOBedrockFluids.create(GTCEu.id((String)"the_water_from_the_well_of_wisdom_deposit"), "\u667a\u6167\u4e4b\u6cc9\u6c34\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTOMaterials.TheWaterFromTheWellOfWisdom).getFluid()).weight(40).yield(20, 40).depletionAmount(1).depletionChance(100).depletedYield(5).biomes(5000, new ResourceKey[]{ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)RLUtils.fromNamespaceAndPath((String)"mythicbotany", (String)"alfheim_lakes"))}).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.ALFHEIM)));
    private static final BedrockFluidDefinition ANIMIUM = GTOBedrockFluids.create(GTCEu.id((String)"animium_deposit"), "\u7075\u9ad3\u6db2\u77ff\u85cf", builder -> builder.fluid(() -> ((Material)GTOMaterials.Animium).getFluid()).weight(20).yield(10, 20).depletionAmount(1).depletionChance(100).depletedYield(5).biomes(100, new ResourceKey[]{ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)RLUtils.fromNamespaceAndPath((String)"mythicbotany", (String)"golden_fields"))}).dimensions(GTODimensions.getDimensionKeys((ResourceLocation)GTODimensions.ALFHEIM)));

    private static BedrockFluidDefinition create(ResourceLocation id, String cn, Consumer<BedrockFluidDefinition.Builder> consumer) {
        if (LANG != null) {
            String name = id.m_135815_();
            CNEN lang = new CNEN(cn, FormattingUtil.toEnglishName((Object)name));
            if (LANG.containsKey(name)) {
                GTOCore.LOGGER.error("Repetitive Key: {}", (Object)id);
            }
            if (LANG.containsValue(lang)) {
                GTOCore.LOGGER.error("Repetitive Value: {}", (Object)lang);
            }
            LANG.put(name, lang);
        }
        BedrockFluidDefinition definition = GTBedrockFluids.create((ResourceLocation)id, consumer);
        GTOBedrockFluids.addVoid(definition);
        return definition;
    }

    public static void addVoid(BedrockFluidDefinition definition) {
        ResourceKey dimension = (ResourceKey)definition.dimensionFilter.iterator().next();
        if (dimension != GTODimensions.getDimensionKey((ResourceLocation)GTODimensions.VOID) || dimension != GTODimensions.getDimensionKey((ResourceLocation)GTODimensions.FLAT) || dimension != GTODimensions.getDimensionKey((ResourceLocation)GTODimensions.CREATE)) {
            List fluidStacks = ALL_BEDROCK_FLUID.computeIfAbsent((ResourceKey<Level>)dimension, k -> new ArrayList());
            fluidStacks.add(new FluidStack((Fluid)definition.getStoredFluid().get(), Math.max(1, definition.getMaximumYield() * definition.getWeight())));
            ALL_BEDROCK_FLUID.put((ResourceKey<Level>)dimension, fluidStacks);
        }
    }
}

