/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.item;

import com.gregtechceu.gtceu.api.gui.fancy.FancyMachineUIWidget;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.gregtechceu.gtceu.api.gui.fancy.TabsWidget;
import com.gregtechceu.gtceu.api.item.component.ICustomDescriptionId;
import com.gregtechceu.gtceu.api.item.component.IItemUIFactory;
import com.gtocore.common.data.GTOItems;
import com.gtolib.utils.RLUtils;
import com.gtolib.utils.RegistriesUtils;
import com.lowdragmc.lowdraglib.gui.factory.HeldItemUIFactory;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.widget.PhantomSlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public final class OrderItem
implements IItemUIFactory,
IFancyUIProvider,
ICustomDescriptionId {
    public static final OrderItem INSTANCE = new OrderItem();
    private InteractionHand hand;

    public InteractionResultHolder<ItemStack> use(Item item, Level level, Player player, InteractionHand usedHand) {
        this.hand = usedHand;
        return super.use(item, level, player, usedHand);
    }

    public ModularUI createUI(HeldItemUIFactory.HeldItemHolder heldItemHolder, Player player) {
        return new ModularUI(176, 166, (IUIHolder)heldItemHolder, player).widget((Widget)new FancyMachineUIWidget((IFancyUIProvider)this, 176, 166));
    }

    public static ItemStack setTarget(ItemStack stack, ItemStack target) {
        CompoundTag tag = stack.m_41784_();
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)target.m_41720_());
        tag.m_128359_("marker_id", id.toString());
        if (target.m_41782_()) {
            tag.m_128365_("marker_nbt", (Tag)target.m_41783_().m_6426_());
        }
        return stack;
    }

    public static ItemStack getTarget(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        String id = tag.m_128461_("marker_id");
        if (id.isEmpty()) {
            return ItemStack.f_41583_;
        }
        CompoundTag nbt = tag.m_128469_("marker_nbt");
        ItemStack i = new ItemStack((ItemLike)RegistriesUtils.getItem((ResourceLocation)RLUtils.parse((String)id)));
        if (nbt != null) {
            i.m_41751_(nbt.m_6426_());
        }
        return i;
    }

    public static ItemStack clearTarget(ItemStack stack) {
        if (!stack.m_41782_()) {
            return stack;
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128473_("marker_id");
        tag.m_128473_("marker_nbt");
        return stack;
    }

    public Component getItemName(ItemStack stack) {
        MutableComponent name = Component.m_237119_();
        if (stack.m_41782_()) {
            name = OrderItem.getTarget(stack).m_41786_();
        }
        return Component.m_237110_((String)stack.m_41778_(), (Object[])new Object[]{name});
    }

    public Widget createMainPage(FancyMachineUIWidget fancyMachineUIWidget) {
        WidgetGroup group = new WidgetGroup(0, 0, 34, 34);
        WidgetGroup container = new WidgetGroup(4, 4, 26, 26);
        Player player = null;
        if (fancyMachineUIWidget.getGui() != null) {
            player = fancyMachineUIWidget.getGui().entityPlayer;
        }
        if (player != null) {
            container.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new ItemHandler(this.hand, player), 0, 4, 4));
        }
        group.addWidget((Widget)container);
        return group;
    }

    public IGuiTexture getTabIcon() {
        return new ItemStackTexture(new Item[]{GTOItems.ORDER.m_5456_()});
    }

    public Component getTitle() {
        return Component.m_237115_((String)"item.gtocore.order.config");
    }

    public void attachSideTabs(TabsWidget sideTabs) {
        sideTabs.setMainTab((IFancyUIProvider)this);
    }

    private static class ItemHandler
    implements IItemTransfer {
        @NotNull
        private ItemStack stack = ItemStack.f_41583_;
        private final InteractionHand hand;
        private final Player player;

        public ItemHandler(InteractionHand hand, @NotNull Player player) {
            this.hand = hand;
            this.player = player;
        }

        public int getSlots() {
            return 1;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.stack;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate, boolean notifyChanges) {
            this.stack = stack;
            this.player.m_21008_(this.hand, OrderItem.setTarget(this.player.m_21120_(this.hand), stack));
            return null;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate, boolean notifyChanges) {
            this.stack = ItemStack.f_41583_;
            this.player.m_21008_(this.hand, OrderItem.clearTarget(this.player.m_21120_(this.hand)));
            return this.stack;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.m_41720_() == this.stack.m_41720_();
        }

        @NotNull
        public Object createSnapshot() {
            return this.stack;
        }

        public void restoreFromSnapshot(Object snapshot) {
            if (snapshot instanceof ItemStack) {
                ItemStack stack;
                this.stack = stack = (ItemStack)snapshot;
            }
        }
    }
}

