/*
 * Decompiled with CFR 0.152.
 */
package com.gtocore.common.item;

import com.fast.fastcollection.O2OOpenCacheHashMap;
import com.fast.fastcollection.OpenCacheHashSet;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.WidgetUtils;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.gui.editor.IEditableUI;
import com.gregtechceu.gtceu.api.gui.fancy.FancyMachineUIWidget;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.gregtechceu.gtceu.api.gui.fancy.TabsWidget;
import com.gregtechceu.gtceu.api.gui.widget.PhantomSlotWidget;
import com.gregtechceu.gtceu.api.gui.widget.ScrollablePhantomFluidWidget;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.gui.widget.TankWidget;
import com.gregtechceu.gtceu.api.item.component.IItemUIFactory;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ui.GTRecipeTypeUI;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.data.machines.GTMachineUtils;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.AETextInputButtonWidget;
import com.gtocore.common.data.GTOItems;
import com.gtocore.common.data.GTORecipeTypes;
import com.gtocore.common.item.ItemMap;
import com.gtocore.config.GTOConfig;
import com.gtolib.GTOCore;
import com.gtolib.api.machine.DummyMachine;
import com.gtolib.api.recipe.Recipe;
import com.gtolib.api.recipe.RecipeBuilder;
import com.gtolib.api.recipe.ingredient.FastFluidIngredient;
import com.gtolib.api.recipe.ingredient.FastSizedIngredient;
import com.gtolib.utils.FluidUtils;
import com.gtolib.utils.ItemUtils;
import com.gtolib.utils.StringConverter;
import com.gtolib.utils.StringIndex;
import com.lowdragmc.lowdraglib.gui.factory.HeldItemUIFactory;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2CharLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public final class RecipeEditorBehavior
implements IItemUIFactory,
IFancyUIProvider {
    public static final RecipeEditorBehavior INSTANCE = new RecipeEditorBehavior();
    private static final Map<MetaMachine, DummyMachine> CACHE = new Reference2ObjectOpenHashMap();
    private static final Map<BlockPos, DummyMachine> POS_CACHE = new O2OOpenCacheHashMap();
    private boolean isGT;
    private DummyMachine machine;

    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        if (Objects.requireNonNull(context.m_43723_()).m_6144_()) {
            if (GTOConfig.INSTANCE.recipeCheck) {
                Reference2ObjectOpenHashMap recipeMap = new Reference2ObjectOpenHashMap();
                for (Recipe recipe : RecipeBuilder.RECIPE_MAP.values()) {
                    GTRecipeType recipeType = recipe.recipeType;
                    if (recipeType == GTRecipeTypes.BREWING_RECIPES || recipeType == GTRecipeTypes.SCANNER_RECIPES || recipeType == GTORecipeTypes.LARGE_GAS_COLLECTOR_RECIPES) continue;
                    ((Set)recipeMap.computeIfAbsent((Object)recipeType, k -> new OpenCacheHashSet())).add(recipe);
                }
                OpenCacheHashSet cache = new OpenCacheHashSet();
                for (Set recipes : recipeMap.values()) {
                    O2OOpenCacheHashMap stringSetMap = new O2OOpenCacheHashMap(recipeMap.size());
                    for (GTRecipe recipe : recipes) {
                        ResourceLocation id = recipe.id;
                        OpenCacheHashSet input = new OpenCacheHashSet();
                        if (recipe.inputs.containsKey(ItemRecipeCapability.CAP)) {
                            block3: for (Content content : (List)recipe.inputs.get(ItemRecipeCapability.CAP)) {
                                Ingredient ingredient;
                                Ingredient inner = ingredient = (Ingredient)ItemRecipeCapability.CAP.of(content.getContent());
                                if (ingredient instanceof FastSizedIngredient) {
                                    FastSizedIngredient sizedIngredient = (FastSizedIngredient)ingredient;
                                    inner = sizedIngredient.getInner();
                                }
                                for (Ingredient.Value value : inner.f_43902_) {
                                    if (value instanceof Ingredient.ItemValue) {
                                        Ingredient.ItemValue itemValue = (Ingredient.ItemValue)value;
                                        Collection stacks = itemValue.m_6223_();
                                        if (stacks.isEmpty()) {
                                            GTOCore.LOGGER.error("\u914d\u65b9 {} \u5b58\u5728\u7a7a\u7269\u54c1\u8f93\u5165", (Object)id);
                                            continue;
                                        }
                                        for (ItemStack stack : stacks) {
                                            if (stack.m_41619_()) continue;
                                            if (stack.m_150930_((Item)GTItems.PROGRAMMED_CIRCUIT.get())) {
                                                input.add((Object)("c" + IntCircuitBehaviour.getCircuitConfiguration((ItemStack)stack)));
                                                continue block3;
                                            }
                                            Object s = ItemUtils.getId((ItemStack)stack);
                                            if (stack.m_41783_() != null) {
                                                s = (String)s + String.valueOf(stack.m_41783_());
                                            }
                                            input.add(s);
                                            continue block3;
                                        }
                                        continue;
                                    }
                                    if (!(value instanceof Ingredient.TagValue)) continue;
                                    Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                                    input.add((Object)tagValue.f_43959_.f_203868_().toString());
                                    continue block3;
                                }
                            }
                        }
                        if (recipe.inputs.containsKey(FluidRecipeCapability.CAP)) {
                            for (Content content : (List)recipe.inputs.get(FluidRecipeCapability.CAP)) {
                                FluidStack[] stacks = ((FluidIngredient)FluidRecipeCapability.CAP.of(content.getContent())).getStacks();
                                if (stacks.length == 0) {
                                    GTOCore.LOGGER.error("\u914d\u65b9 {} \u5b58\u5728\u7a7a\u6d41\u4f53\u8f93\u5165", (Object)id);
                                    continue;
                                }
                                Object s = FluidUtils.getId((Fluid)stacks[0].getFluid());
                                if (stacks[0].getTag() != null) {
                                    s = (String)s + String.valueOf(stacks[0].getTag());
                                }
                                input.add(s);
                            }
                        }
                        if (input.isEmpty()) continue;
                        stringSetMap.put((Object)id, (Object)input);
                    }
                    stringSetMap.forEach((arg_0, arg_1) -> RecipeEditorBehavior.lambda$onItemUseFirst$2(stringSetMap, (Set)cache, arg_0, arg_1));
                }
            }
            return InteractionResult.CONSUME;
        }
        MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)context.m_43725_(), (BlockPos)context.m_8083_());
        if (metaMachine instanceof IRecipeLogicMachine) {
            this.isGT = true;
            this.machine = CACHE.computeIfAbsent(metaMachine, DummyMachine::createDummyMachine);
        } else if (context.m_43725_().m_8055_(context.m_8083_()).m_60734_() instanceof CraftingTableBlock) {
            this.isGT = false;
            this.machine = POS_CACHE.computeIfAbsent(context.m_8083_(), p -> DummyMachine.createDummyMachine((BlockEntityType)BlockEntityType.f_58918_, (BlockPos)p, (BlockState)GTMachines.ASSEMBLER[1].defaultBlockState(), (GTRecipeType)GTRecipeTypes.ASSEMBLER_RECIPES));
        } else {
            return InteractionResult.PASS;
        }
        super.use(context.m_43722_().m_41720_(), context.m_43725_(), context.m_43723_(), context.m_43724_());
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> use(Item item, Level level, Player player, InteractionHand usedHand) {
        ItemStack heldItem = player.m_21120_(usedHand);
        return InteractionResultHolder.m_19090_((Object)heldItem);
    }

    public ModularUI createUI(HeldItemUIFactory.HeldItemHolder holder, Player entityPlayer) {
        return new ModularUI(176, 166, (IUIHolder)holder, entityPlayer).widget((Widget)new FancyMachineUIWidget((IFancyUIProvider)this, 176, 166));
    }

    public Widget createMainPage(FancyMachineUIWidget widget2) {
        GTRecipeTypeUI recipeUI = new GTRecipeTypeUI(this.machine.recipeType){

            protected WidgetGroup addInventorySlotGroup(boolean isOutputs, boolean isSteam, boolean isHighPressure) {
                int maxCount = 0;
                int totalR = 0;
                TreeMap<RecipeCapability, Integer> map = new TreeMap<RecipeCapability, Integer>(RecipeCapability.COMPARATOR);
                if (isOutputs) {
                    for (Map.Entry value : RecipeEditorBehavior.this.machine.recipeType.maxOutputs.entrySet()) {
                        if (!((RecipeCapability)value.getKey()).doRenderSlot) continue;
                        val = (Integer)value.getValue();
                        if (val > maxCount) {
                            maxCount = Math.min(val, 3);
                        }
                        totalR += (val + 2) / 3;
                        map.put((RecipeCapability)value.getKey(), val);
                    }
                } else {
                    for (Map.Entry value : RecipeEditorBehavior.this.machine.recipeType.maxInputs.entrySet()) {
                        if (!((RecipeCapability)value.getKey()).doRenderSlot) continue;
                        val = (Integer)value.getValue();
                        if (val > maxCount) {
                            maxCount = Math.min(val, 3);
                        }
                        totalR += (val + 2) / 3;
                        map.put((RecipeCapability)value.getKey(), val);
                    }
                }
                WidgetGroup group = new WidgetGroup(0, 0, maxCount * 18 + 8, totalR * 18 + 8);
                int index = 0;
                for (Map.Entry entry : map.entrySet()) {
                    RecipeCapability cap = (RecipeCapability)entry.getKey();
                    boolean i = cap instanceof ItemRecipeCapability;
                    if (!i && !RecipeEditorBehavior.this.isGT || cap.getWidgetClass() == null) continue;
                    int capCount = (Integer)entry.getValue();
                    for (int slotIndex = 0; slotIndex < capCount; ++slotIndex) {
                        int finalSlotIndex = slotIndex;
                        MyPhantomSlotWidget slot = i ? new MyPhantomSlotWidget() : new ScrollablePhantomFluidWidget(null, 0, 0, 0, 18, 18, isOutputs ? () -> RecipeEditorBehavior.this.machine.exportFluids.getFluidInTank(finalSlotIndex) : () -> RecipeEditorBehavior.this.machine.importFluids.getFluidInTank(finalSlotIndex), isOutputs ? f -> RecipeEditorBehavior.this.machine.exportFluids.setFluidInTank(finalSlotIndex, f) : f -> RecipeEditorBehavior.this.machine.importFluids.setFluidInTank(finalSlotIndex, f));
                        slot.setSelfPosition(new Position(index % 3 * 18 + 4, index / 3 * 18 + 4));
                        slot.setBackground(new IGuiTexture[]{this.getOverlaysForSlot(isOutputs, cap, slotIndex == capCount - 1, isSteam, isHighPressure)});
                        slot.setId(cap.slotName(isOutputs ? IO.OUT : IO.IN, slotIndex));
                        group.addWidget((Widget)slot);
                        ++index;
                    }
                    index += (3 - index % 3) % 3;
                }
                return group;
            }

            public IEditableUI<WidgetGroup, GTRecipeTypeUI.RecipeHolder> createEditableUITemplate(boolean isSteam, boolean isHighPressure) {
                return new IEditableUI.Normal(() -> {
                    WidgetGroup inputs = this.addInventorySlotGroup(false, isSteam, isHighPressure);
                    WidgetGroup outputs = this.addInventorySlotGroup(true, isSteam, isHighPressure);
                    int maxWidth = Math.max(inputs.getSize().width, outputs.getSize().width);
                    WidgetGroup group = new WidgetGroup(0, 0, 2 * maxWidth + 40, Math.max(inputs.getSize().height, outputs.getSize().height));
                    Size size = group.getSize();
                    inputs.addSelfPosition((maxWidth - inputs.getSize().width) / 2, (size.height - inputs.getSize().height) / 2);
                    outputs.addSelfPosition(maxWidth + 40 + (maxWidth - outputs.getSize().width) / 2, (size.height - outputs.getSize().height) / 2);
                    group.addWidget((Widget)inputs);
                    group.addWidget((Widget)outputs);
                    ProgressWidget progressWidget = new ProgressWidget(ProgressWidget.JEIProgress, maxWidth + 10, size.height / 2 - 10, 20, 20, this.getProgressBarTexture());
                    progressWidget.setId("progress");
                    group.addWidget((Widget)progressWidget);
                    progressWidget.setProgressTexture((IGuiTexture)this.getProgressBarTexture());
                    return group;
                }, (template, recipeHolder) -> {
                    for (Map.Entry capabilityEntry : recipeHolder.storages().rowMap().entrySet()) {
                        IO io = (IO)capabilityEntry.getKey();
                        for (Map.Entry storagesEntry : ((Map)capabilityEntry.getValue()).entrySet()) {
                            RecipeCapability cap = (RecipeCapability)storagesEntry.getKey();
                            Object storage = storagesEntry.getValue();
                            Class widgetClass = cap.getWidgetClass();
                            if (widgetClass == null) continue;
                            WidgetUtils.widgetByIdForEach((WidgetGroup)template, (String)"^%s_[0-9]+$".formatted(cap.slotName(io)), (Class)widgetClass, widget2 -> {
                                int index = WidgetUtils.widgetIdIndex((Widget)widget2);
                                cap.applyWidgetInfo(widget2, index, false, io, recipeHolder, RecipeEditorBehavior.this.machine.recipeType, null, null, storage, 0, 0);
                                if (widget2 instanceof TankWidget) {
                                    TankWidget tankWidget = (TankWidget)widget2;
                                    tankWidget.setAllowClickDrained(true).setAllowClickFilled(true);
                                } else if (widget2 instanceof SlotWidget) {
                                    SlotWidget slotWidget = (SlotWidget)widget2;
                                    slotWidget.setCanTakeItems(true).setCanPutItems(true);
                                }
                            });
                        }
                    }
                });
            }
        };
        EditableMachineUI editableUI = new EditableMachineUI("simple", GTOCore.id((String)"re"), () -> {
            WidgetGroup template = (WidgetGroup)recipeUI.createEditableUITemplate(false, false).createDefault();
            WidgetGroup group = new WidgetGroup(0, 0, template.getSize().width, Math.max(template.getSize().height, 78));
            template.setSelfPosition(new Position(0, (group.getSize().height - template.getSize().height) / 2));
            group.addWidget((Widget)template);
            return group;
        }, (template, m) -> {
            Table storages = Tables.newCustomTable(new EnumMap(IO.class), LinkedHashMap::new);
            storages.put((Object)IO.IN, (Object)ItemRecipeCapability.CAP, (Object)this.machine.importItems);
            storages.put((Object)IO.OUT, (Object)ItemRecipeCapability.CAP, (Object)this.machine.exportItems);
            if (this.isGT) {
                storages.put((Object)IO.IN, (Object)FluidRecipeCapability.CAP, (Object)this.machine.importFluids);
                storages.put((Object)IO.OUT, (Object)FluidRecipeCapability.CAP, (Object)this.machine.exportFluids);
            }
            recipeUI.createEditableUITemplate(false, false).setupUI(template, (Object)new GTRecipeTypeUI.RecipeHolder(() -> 0.0, storages, new CompoundTag(), Collections.emptyList(), false, false));
        });
        WidgetGroup template2 = editableUI.createCustomUI();
        if (template2 == null) {
            template2 = editableUI.createDefault();
        }
        editableUI.setupUI(template2, (MetaMachine)this.machine);
        int x = template2.getSize().width - RecipeEditorBehavior.getXOffset(this.machine.recipeType) - 18;
        int y = template2.getSize().height - 10;
        if (this.isGT) {
            template2.addWidget((Widget)new AETextInputButtonWidget(x - 48, y - 70, 76, 12).setText(String.valueOf(this.machine.id)).setOnConfirm(arg_0 -> ((DummyMachine)this.machine).setId(arg_0)).setButtonTooltips(new Component[]{Component.m_237113_((String)"ID")}));
            template2.addWidget((Widget)new AETextInputButtonWidget(x - 36, y - 55, 64, 12).setText(String.valueOf(this.machine.circuit)).setOnConfirm(arg_0 -> ((DummyMachine)this.machine).setCircuit(arg_0)).setButtonTooltips(new Component[]{Component.m_237113_((String)"Circuit")}));
            template2.addWidget((Widget)new AETextInputButtonWidget(x - 36, y - 40, 64, 12).setText(String.valueOf(this.machine.eut)).setOnConfirm(arg_0 -> ((DummyMachine)this.machine).setEUt(arg_0)).setButtonTooltips(new Component[]{Component.m_237113_((String)"EUt")}));
            template2.addWidget((Widget)new AETextInputButtonWidget(x - 36, y - 25, 64, 12).setText(String.valueOf(this.machine.duration)).setOnConfirm(arg_0 -> ((DummyMachine)this.machine).setDuration(arg_0)).setButtonTooltips(new Component[]{Component.m_237113_((String)"Duration")}));
            template2.addWidget((Widget)new AETextInputButtonWidget(x - 36, y - 10, 64, 12).setText(String.valueOf(this.machine.temp)).setOnConfirm(arg_0 -> ((DummyMachine)this.machine).sett(arg_0)).setButtonTooltips(new Component[]{Component.m_237113_((String)"FurnaceTemp")}));
            template2.addWidget((Widget)new AETextInputButtonWidget(x - 36, y + 5, 64, 12).setText(String.valueOf(this.machine.manat)).setOnConfirm(arg_0 -> ((DummyMachine)this.machine).setMANAt(arg_0)).setButtonTooltips(new Component[]{Component.m_237113_((String)"MANAt")}));
        }
        template2.addWidget((Widget)new ButtonWidget(x, y, 16, 16, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.BUTTON, new TextTexture("X")}), cd -> {
            if (cd.isRemote) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (this.isGT) {
                String stringFluid;
                String stringItem;
                ItemStack stack;
                int i;
                Object recipeType = StringIndex.RECIPETYPE_MAP.containsKey(this.machine.recipeType) ? (String)StringIndex.RECIPETYPE_MAP.get(this.machine.recipeType) : this.machine.recipeType.registryName.m_135815_().toUpperCase() + "_RECIPES";
                String id = this.machine.id;
                if (id.isEmpty()) {
                    for (i = 0; i < this.machine.exportItems.getSlots() && id.isEmpty(); ++i) {
                        stack = this.machine.exportItems.getStackInSlot(i);
                        if (stack.m_41619_()) continue;
                        id = ItemUtils.getIdLocation((Item)stack.m_41720_()).m_135815_();
                    }
                    for (i = 0; i < this.machine.exportFluids.getSize() && id.isEmpty(); ++i) {
                        stack = this.machine.exportFluids.getFluidInTank(i);
                        if (stack.isEmpty()) continue;
                        id = FluidUtils.getIdLocation((Fluid)stack.getFluid()).m_135815_();
                    }
                }
                stringBuilder.append("\n").append((String)recipeType).append(".builder(\"").append(id).append("\")\n");
                for (i = 0; i < this.machine.importItems.getSlots(); ++i) {
                    stack = this.machine.importItems.getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    stringItem = StringConverter.fromItem((Ingredient)RecipeEditorBehavior.getItemIngredient(stack), (int)1);
                    stringBuilder.append(".inputItems(").append(stringItem).append(")").append("\n");
                }
                for (i = 0; i < this.machine.exportItems.getSlots(); ++i) {
                    stack = this.machine.exportItems.getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    stringItem = StringConverter.fromItem((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}), (int)1);
                    stringBuilder.append(".outputItems(").append(stringItem).append(")").append("\n");
                }
                for (i = 0; i < this.machine.importFluids.getSize(); ++i) {
                    stack = this.machine.importFluids.getFluidInTank(i);
                    if (stack.isEmpty()) continue;
                    stringFluid = StringConverter.fromFluid((FluidIngredient)FastFluidIngredient.of((FluidStack[])new FluidStack[]{stack}), (boolean)true);
                    stringBuilder.append(".inputFluids(").append(stringFluid).append(")").append("\n");
                }
                for (i = 0; i < this.machine.exportFluids.getSize(); ++i) {
                    stack = this.machine.exportFluids.getFluidInTank(i);
                    if (stack.isEmpty()) continue;
                    stringFluid = StringConverter.fromFluid((FluidIngredient)FastFluidIngredient.of((FluidStack[])new FluidStack[]{stack}), (boolean)true);
                    stringBuilder.append(".outputFluids(").append(stringFluid).append(")").append("\n");
                }
                if (this.machine.circuit > 0) {
                    stringBuilder.append(".circuitMeta(").append(this.machine.circuit).append(")\n");
                }
                if (this.machine.eut != 0L) {
                    stringBuilder.append(".EUt(").append(this.machine.eut).append(")\n");
                }
                if (this.machine.temp != 0) {
                    stringBuilder.append(".blastFurnaceTemp(").append(this.machine.temp).append(")\n");
                }
                if (this.machine.duration == 0) {
                    GTOCore.LOGGER.error("\u65e0\u65f6\u95f4");
                    return;
                }
                stringBuilder.append(".duration(").append(this.machine.duration).append(")\n");
                if (this.machine.manat != 0) {
                    stringBuilder.append(".MANAt(").append(this.machine.manat).append(")\n");
                }
                stringBuilder.append(".save();\n");
            } else {
                String id = this.machine.id;
                if (id.isEmpty()) {
                    id = ItemUtils.getIdLocation((Item)this.machine.exportItems.getStackInSlot(0).m_41720_()).m_135815_();
                }
                stringBuilder.append("\nVanillaRecipeHelper.addShapedRecipe(");
                stringBuilder.append("GTOCore.id(\"").append(id).append("\"), ");
                stringBuilder.append(StringConverter.fromItem((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.machine.exportItems.getStackInSlot(0)}), (int)0)).append(",\n\"");
                char c = 'A';
                Reference2CharLinkedOpenHashMap map = new Reference2CharLinkedOpenHashMap();
                int i = 0;
                int j = 0;
                while (i < this.machine.importItems.getSlots()) {
                    char d;
                    Item item = this.machine.importItems.getStackInSlot(i).m_41720_();
                    if (item != Items.f_41852_ && !map.containsKey((Object)item)) {
                        map.put((Object)item, c);
                        c = (char)(c + '\u0001');
                    }
                    char c2 = d = item == Items.f_41852_ ? (char)' ' : (char)map.getChar((Object)item);
                    if (j > 2) {
                        stringBuilder.append("\",\n\"").append(d);
                        j = 0;
                    } else {
                        stringBuilder.append(d);
                    }
                    ++i;
                    ++j;
                }
                stringBuilder.append("\",\n");
                map.forEach((k, v) -> stringBuilder.append("'").append(v).append("', ").append(StringConverter.fromItem((Ingredient)RecipeEditorBehavior.getItemIngredient(k.m_7968_()), (int)2)).append(","));
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                stringBuilder.append(");");
            }
            GTOCore.LOGGER.info(stringBuilder.toString());
        }));
        return template2;
    }

    private static Ingredient getItemIngredient(ItemStack stack) {
        if (ItemMap.UNIVERSAL_CIRCUITS.contains((Object)stack.m_41720_())) {
            for (int tier : GTMachineUtils.ALL_TIERS) {
                if (!GTOItems.UNIVERSAL_CIRCUIT[tier].is(stack.m_41720_())) continue;
                return FastSizedIngredient.create((TagKey)CustomTags.CIRCUITS_ARRAY[tier], (long)stack.m_41613_());
            }
        }
        return FastSizedIngredient.create((ItemStack)stack);
    }

    private static int getXOffset(GTRecipeType recipe) {
        if (recipe.getRecipeUI().getOriginalWidth() != recipe.getRecipeUI().getJEISize().width) {
            return (recipe.getRecipeUI().getJEISize().width - recipe.getRecipeUI().getOriginalWidth()) / 2;
        }
        return 0;
    }

    public void attachSideTabs(TabsWidget sideTabs) {
        sideTabs.setMainTab((IFancyUIProvider)this);
    }

    public IGuiTexture getTabIcon() {
        return new ItemStackTexture(new Item[]{(Item)GTOItems.ULV_ROBOT_ARM.get()});
    }

    public Component getTitle() {
        return Component.m_237115_((String)"item.gtocore.recipe_editor");
    }

    private static /* synthetic */ void lambda$onItemUseFirst$2(O2OOpenCacheHashMap stringSetMap, Set cache, ResourceLocation id, Set set) {
        O2OOpenCacheHashMap map = new O2OOpenCacheHashMap((Object2ObjectMap)stringSetMap);
        map.remove((Object)id);
        map.forEach((k, v) -> {
            BiCache object = new BiCache(id, k);
            if (cache.contains(object)) {
                return;
            }
            if (set.containsAll((Collection<?>)v)) {
                cache.add(object);
                GTOCore.LOGGER.error("\n{} \u4e0e {} \u51b2\u7a81\n{}\n{}", new Object[]{id, k, set, v});
            }
        });
    }

    private record BiCache(Object a, Object b) {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            Object a1;
            Object object;
            if (!(o instanceof BiCache)) return false;
            BiCache biCache = (BiCache)o;
            try {
                a1 = object = biCache.a();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            Object b1 = object = biCache.b();
            if (this.a.equals(a1) && this.b.equals(b1)) {
                return true;
            }
            if (!this.a.equals(b1)) return false;
            if (!this.b.equals(a1)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.a.hashCode() + this.b.hashCode();
        }
    }

    private static class MyPhantomSlotWidget
    extends PhantomSlotWidget {
        private MyPhantomSlotWidget() {
        }

        public ItemStack slotClickPhantom(Slot slot, int mouseButton, ClickType clickTypeIn, ItemStack stackHeld) {
            if (this.isRemote()) {
                return slot.m_7993_();
            }
            return super.slotClickPhantom(slot, mouseButton, clickTypeIn, stackHeld);
        }
    }
}

